/*
 * Decompiled with CFR 0.152.
 */
package org.rhm.undertale_death_screen.forge;

import java.nio.file.Path;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.rhm.undertale_death_screen.UndertaleDeathScreenBase;
import org.rhm.undertale_death_screen.UndertaleDeathScreenCommon;

@Mod(value="undertale_death_screen")
public class UndertaleDeathScreenForge {
    public UndertaleDeathScreenForge() {
        this(FMLJavaModLoadingContext.get());
    }

    public UndertaleDeathScreenForge(FMLJavaModLoadingContext context) {
        UndertaleDeathScreenCommon.init(new Impl());
        Impl.register(context.getModBusGroup());
        if (UndertaleDeathScreenCommon.isConfigSupported()) {
            context.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, parent) -> UndertaleDeathScreenCommon.getConfigScreen(parent)));
        }
    }

    public static class Impl
    implements UndertaleDeathScreenBase {
        private static final DeferredRegister<SoundEvent> SOUND_EVENT_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"undertale_death_screen");

        public static void register(BusGroup eventBus) {
            SOUND_EVENT_REGISTRY.register(eventBus);
        }

        @Override
        public Supplier<SoundEvent> registerSoundEvent(String path) {
            return SOUND_EVENT_REGISTRY.register(path, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)UndertaleDeathScreenCommon.id(path)));
        }

        @Override
        public boolean isModLoaded(String id) {
            return ModList.get().isLoaded(id);
        }

        @Override
        public Path getConfigDir() {
            return FMLPaths.CONFIGDIR.get();
        }
    }
}

