/*
 * Decompiled with CFR 0.152.
 */
package org.rhm.undertale_death_screen.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_418;
import net.minecraft.class_437;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.rhm.undertale_death_screen.BGMSoundInstance;
import org.rhm.undertale_death_screen.Config;
import org.rhm.undertale_death_screen.DeathScreenAccess;
import org.rhm.undertale_death_screen.HeartPiece;
import org.rhm.undertale_death_screen.UndertaleDeathScreenCommon;
import org.rhm.undertale_death_screen.registry.SoundEventRegistry;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_418.class})
public abstract class DeathScreenMixin
extends class_437
implements DeathScreenAccess {
    @Unique
    private static final List<Function<class_1657, Integer>> COLUMN_SELECTOR = List.of(player -> player.method_6059(class_1294.field_5899) ? Integer.valueOf(1) : null, player -> player.method_6059(class_1294.field_5920) ? Integer.valueOf(2) : null, player -> player.method_40071() ? Integer.valueOf(3) : null);
    @Unique
    private static final int HEART_WIDTH = 13;
    @Unique
    private static final int HEART_HEIGHT = 15;
    @Unique
    private static final int HEART_TEXTURE_WIDTH = 52;
    @Unique
    private static final int HEART_TEXTURE_HEIGHT = 60;
    @Unique
    private static final class_2960 HEART_TEXTURE_LOCATION = UndertaleDeathScreenCommon.id("undertale_death/heart_shatter");
    @Unique
    private static final class_2960 HEART_TEXTURE_LOCATION_HC = UndertaleDeathScreenCommon.id("undertale_death/heart_shatter_hardcore");
    @Shadow
    @Final
    private boolean field_18974;
    @Unique
    private class_5819 undertale_death_animation$randomSource;
    @Unique
    private List<HeartPiece> undertale_death_animation$pieces;
    @Unique
    private int undertale_death_animation$age;
    @Unique
    private int undertale_death_animation$finishedAge;
    @Unique
    private boolean undertale_death_animation$hasFinished;
    @Unique
    private boolean undertale_death_animation$shouldStart;
    @Unique
    private double undertale_death_animation$progress;
    @Unique
    private int undertale_death_animation$bgmProgress;
    @Unique
    private Integer undertale_death_animation$heartStyle;
    @Unique
    @Nullable
    private BGMSoundInstance undertale_death_animation$bgmSoundInstance;

    protected DeathScreenMixin(class_2561 component) {
        super(component);
    }

    @Inject(method={"renderDeathBackground"}, at={@At(value="HEAD")}, require=0, cancellable=true)
    private static void disableBackground(class_332 guiGraphics, int i, int j, CallbackInfo ci) {
        ci.cancel();
    }

    @Shadow
    protected abstract void method_49299(boolean var1);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void setUpVariables(CallbackInfo ci) {
        if (Config.INSTANCE.getShouldStopSound()) {
            class_310.method_1551().method_1538().method_4859();
            class_310.method_1551().method_1483().method_4881();
        }
        this.undertale_death_animation$age = 0;
        this.undertale_death_animation$finishedAge = 0;
        this.undertale_death_animation$bgmProgress = 0;
        this.undertale_death_animation$progress = 0.0;
        this.undertale_death_animation$pieces = new ArrayList<HeartPiece>();
        this.undertale_death_animation$hasFinished = false;
        boolean bl = this.undertale_death_animation$shouldStart = !Config.INSTANCE.getCenteredHeartAnimation() && Config.INSTANCE.getCenteredHeart();
        if (class_310.method_1551().field_1724 != null) {
            this.undertale_death_animation$randomSource = class_310.method_1551().field_1724.method_37908().method_8409();
            this.undertale_death_animation$heartStyle = 0;
            if (Config.INSTANCE.getDynamicHeart()) {
                for (Function<class_1657, Integer> selector : COLUMN_SELECTOR) {
                    Integer style = selector.apply((class_1657)class_310.method_1551().field_1724);
                    if (style == null) continue;
                    this.undertale_death_animation$heartStyle = style;
                    break;
                }
            }
        }
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        this.method_49299(true);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void tick(CallbackInfo ci) {
        class_310.method_1551().method_1538().method_4859();
        if (!this.undertale_death_animation$pieces.isEmpty() && this.undertale_death_animation$pieces.stream().allMatch(piece -> piece.y >= (float)this.field_22790) && !this.undertale_death_animation$hasFinished) {
            if (this.undertale_death_animation$finishedAge == 0) {
                this.undertale_death_animation$finishedAge = this.undertale_death_animation$age;
            } else if (this.undertale_death_animation$age - this.undertale_death_animation$finishedAge >= 5) {
                this.undertale_death_animation$pieces.clear();
                this.undertale_death_animation$hasFinished = true;
            }
        }
        ++this.undertale_death_animation$age;
        if (this.undertale_death_animation$age == 25) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)SoundEventRegistry.HEART_SHATTER_NOISES.get(), (float)1.0f));
        }
        if (!this.undertale_death_animation$hasFinished) {
            ci.cancel();
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void render(class_332 guiGraphics, int i, int j, float delta, CallbackInfo ci) {
        int y;
        int x;
        if (Config.INSTANCE.getCenteredHeart()) {
            x = guiGraphics.method_51421() / 2 - 6;
            y = guiGraphics.method_51443() / 2 - 7;
        } else {
            x = guiGraphics.method_51421() / 2 - 91 - 2;
            y = guiGraphics.method_51443() - 39 - 3;
        }
        double fadeSpeed = Config.INSTANCE.getBackgroundFadeSpeed();
        int bgColor = 0;
        if (fadeSpeed > 0.0) {
            if (fadeSpeed >= 1.0) {
                bgColor = -16777216;
            } else {
                int alpha = (int)(class_3532.method_16435((double)Math.min((double)((float)this.undertale_death_animation$age + delta) * Math.pow(fadeSpeed, 0.5) / 5.0, 1.0)) * 255.0);
                bgColor = alpha << 24;
            }
        }
        if (bgColor >>> 24 > 0) {
            guiGraphics.method_25294(0, 0, guiGraphics.method_51421(), guiGraphics.method_51443(), bgColor);
        }
        if (!this.undertale_death_animation$shouldStart) {
            this.undertale_death_animation$progress = Math.min(this.undertale_death_animation$progress + (double)delta * Config.INSTANCE.getCenteredHeartSpeed(), 1.0);
            double easedProgress = class_3532.method_16435((double)this.undertale_death_animation$progress);
            int startX = guiGraphics.method_51421() / 2 - 91 - 2;
            int startY = guiGraphics.method_51443() - 39 - 3;
            int lerpedX = (int)class_3532.method_16436((double)easedProgress, (double)startX, (double)x);
            int lerpedY = (int)class_3532.method_16436((double)easedProgress, (double)startY, (double)y);
            this.undertale_death_animation$renderHeart(guiGraphics, 0, lerpedX, lerpedY);
            if (lerpedX == x && lerpedY == y) {
                this.undertale_death_animation$shouldStart = true;
            }
        } else if (!this.undertale_death_animation$hasFinished && this.undertale_death_animation$age < 47) {
            this.undertale_death_animation$renderHeart(guiGraphics, this.undertale_death_animation$age < 25 ? 0 : Math.min(3, this.undertale_death_animation$age - 25), x, y);
        } else if (!this.undertale_death_animation$hasFinished && this.undertale_death_animation$pieces.isEmpty()) {
            for (int i1 = 0; i1 < this.undertale_death_animation$randomSource.method_43051(6, 8); ++i1) {
                double angle = this.undertale_death_animation$randomSource.method_43058() * 2.0 * Math.PI;
                double speed = 2.0 + this.undertale_death_animation$randomSource.method_43058() * 2.0;
                double vx = Math.cos(angle) * speed;
                double vy = Math.sin(angle) * speed;
                this.undertale_death_animation$pieces.add(new HeartPiece((float)x + 6.5f, (float)y + 7.5f, vx, vy, this.undertale_death_animation$randomSource.method_43048(8), this.undertale_death_animation$heartStyle * 5, this.undertale_death_animation$randomSource.method_43058() * 360.0, this.undertale_death_animation$randomSource.method_43058() * 8.0 - 2.0));
            }
        } else {
            if (this.undertale_death_animation$bgmProgress != -1 && this.undertale_death_animation$bgmProgress++ >= 35) {
                if (Config.INSTANCE.getDetermination()) {
                    this.undertale_death_animation$bgmSoundInstance = new BGMSoundInstance(SoundEventRegistry.DETERMINATION.get());
                    class_310.method_1551().method_1483().method_4873((class_1113)this.undertale_death_animation$bgmSoundInstance);
                    this.undertale_death_animation$bgmSoundInstance.fadeIn();
                }
                this.undertale_death_animation$bgmProgress = -1;
            }
            for (HeartPiece piece : this.undertale_death_animation$pieces) {
                piece.renderTick();
                piece.render(guiGraphics);
            }
        }
        if (!this.undertale_death_animation$hasFinished) {
            ci.cancel();
        }
    }

    @Unique
    private void undertale_death_animation$renderHeart(class_332 guiGraphics, int stage, int x, int y) {
        guiGraphics.method_52708(class_1921::method_62277, this.field_18974 ? HEART_TEXTURE_LOCATION_HC : HEART_TEXTURE_LOCATION, 52, 60, 13 * stage, 15 * this.undertale_death_animation$heartStyle, x, y, 13, 15);
    }

    @Override
    public void undertale_death_animation$stopBackgroundMusic() {
        class_310.method_1551().method_1483().method_4870((class_1113)this.undertale_death_animation$bgmSoundInstance);
    }

    @WrapOperation(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fillGradient(IIIIII)V")}, require=0)
    private void disableTint(class_332 instance, int i, int j, int k, int l, int m, int n, Operation<Void> original) {
    }
}

