/*
 * Decompiled with CFR 0.152.
 */
package org.rhm.undertale_death_screen.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import org.rhm.undertale_death_screen.BGMSoundInstance;
import org.rhm.undertale_death_screen.Config;
import org.rhm.undertale_death_screen.DeathScreenAccess;
import org.rhm.undertale_death_screen.HeartPiece;
import org.rhm.undertale_death_screen.UndertaleDeathScreenCommon;
import org.rhm.undertale_death_screen.registry.SoundEventRegistry;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DeathScreen.class})
public abstract class DeathScreenMixin
extends Screen
implements DeathScreenAccess {
    @Unique
    private static final List<Function<Player, Integer>> COLUMN_SELECTOR = List.of(player -> player.m_21023_(MobEffects.f_19614_) ? Integer.valueOf(1) : null, player -> player.m_21023_(MobEffects.f_19615_) ? Integer.valueOf(2) : null, player -> player.m_203117_() ? Integer.valueOf(3) : null);
    @Unique
    private static final int HEART_WIDTH = 13;
    @Unique
    private static final int HEART_HEIGHT = 15;
    @Unique
    private static final int HEART_TEXTURE_WIDTH = 52;
    @Unique
    private static final int HEART_TEXTURE_HEIGHT = 60;
    @Unique
    private static final ResourceLocation HEART_TEXTURE_LOCATION = UndertaleDeathScreenCommon.id("undertale_death/heart_shatter");
    @Unique
    private static final ResourceLocation HEART_TEXTURE_LOCATION_HC = UndertaleDeathScreenCommon.id("undertale_death/heart_shatter_hardcore");
    @Shadow
    @Final
    private boolean f_95908_;
    @Unique
    private RandomSource undertale_death_animation$randomSource;
    @Unique
    private List<HeartPiece> undertale_death_animation$pieces;
    @Unique
    private int undertale_death_animation$age;
    @Unique
    private int undertale_death_animation$finishedAge;
    @Unique
    private boolean undertale_death_animation$hasFinished;
    @Unique
    private boolean undertale_death_animation$shouldStart;
    @Unique
    private double undertale_death_animation$progress;
    @Unique
    private int undertale_death_animation$bgmProgress;
    @Unique
    private Integer undertale_death_animation$heartStyle;
    @Unique
    @Nullable
    private BGMSoundInstance undertale_death_animation$bgmSoundInstance;

    protected DeathScreenMixin(Component component) {
        super(component);
    }

    @Inject(method={"renderDeathBackground"}, at={@At(value="HEAD")}, require=0, cancellable=true)
    private static void disableBackground(GuiGraphics guiGraphics, int i, int j, CallbackInfo ci) {
        ci.cancel();
    }

    @Shadow
    protected abstract void m_272014_(boolean var1);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void setUpVariables(CallbackInfo ci) {
        if (Config.INSTANCE.getShouldStopSound()) {
            Minecraft.m_91087_().m_91397_().m_120186_();
            Minecraft.m_91087_().m_91106_().m_120405_();
        }
        this.undertale_death_animation$age = 0;
        this.undertale_death_animation$finishedAge = 0;
        this.undertale_death_animation$bgmProgress = 0;
        this.undertale_death_animation$progress = 0.0;
        this.undertale_death_animation$pieces = new ArrayList<HeartPiece>();
        this.undertale_death_animation$hasFinished = false;
        boolean bl = this.undertale_death_animation$shouldStart = !Config.INSTANCE.getCenteredHeartAnimation() && Config.INSTANCE.getCenteredHeart();
        if (Minecraft.m_91087_().f_91074_ != null) {
            this.undertale_death_animation$randomSource = Minecraft.m_91087_().f_91074_.m_9236_().m_213780_();
            this.undertale_death_animation$heartStyle = 0;
            if (Config.INSTANCE.getDynamicHeart()) {
                for (Function<Player, Integer> selector : COLUMN_SELECTOR) {
                    Integer style = selector.apply((Player)Minecraft.m_91087_().f_91074_);
                    if (style == null) continue;
                    this.undertale_death_animation$heartStyle = style;
                    break;
                }
            }
        }
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        this.m_272014_(true);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void tick(CallbackInfo ci) {
        Minecraft.m_91087_().m_91397_().m_120186_();
        if (!this.undertale_death_animation$pieces.isEmpty() && this.undertale_death_animation$pieces.stream().allMatch(piece -> piece.y >= (float)this.f_96544_) && !this.undertale_death_animation$hasFinished) {
            if (this.undertale_death_animation$finishedAge == 0) {
                this.undertale_death_animation$finishedAge = this.undertale_death_animation$age;
            } else if (this.undertale_death_animation$age - this.undertale_death_animation$finishedAge >= 5) {
                this.undertale_death_animation$pieces.clear();
                this.undertale_death_animation$hasFinished = true;
            }
        }
        ++this.undertale_death_animation$age;
        if (this.undertale_death_animation$age == 25) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEventRegistry.HEART_SHATTER_NOISES.get(), (float)1.0f));
        }
        if (!this.undertale_death_animation$hasFinished) {
            ci.cancel();
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void render(GuiGraphics guiGraphics, int i, int j, float delta, CallbackInfo ci) {
        int y;
        int x;
        if (Config.INSTANCE.getCenteredHeart()) {
            x = guiGraphics.m_280182_() / 2 - 6;
            y = guiGraphics.m_280206_() / 2 - 7;
        } else {
            x = guiGraphics.m_280182_() / 2 - 91 - 2;
            y = guiGraphics.m_280206_() - 39 - 3;
        }
        double fadeSpeed = Config.INSTANCE.getBackgroundFadeSpeed();
        int bgColor = 0;
        if (fadeSpeed > 0.0) {
            if (fadeSpeed >= 1.0) {
                bgColor = -16777216;
            } else {
                int alpha = (int)(Mth.m_14197_((double)Math.min((double)((float)this.undertale_death_animation$age + delta) * Math.pow(fadeSpeed, 0.5) / 5.0, 1.0)) * 255.0);
                bgColor = alpha << 24;
            }
        }
        if (bgColor >>> 24 > 0) {
            guiGraphics.m_280509_(0, 0, guiGraphics.m_280182_(), guiGraphics.m_280206_(), bgColor);
        }
        if (!this.undertale_death_animation$shouldStart) {
            this.undertale_death_animation$progress = Math.min(this.undertale_death_animation$progress + (double)delta * Config.INSTANCE.getCenteredHeartSpeed(), 1.0);
            double easedProgress = Mth.m_14197_((double)this.undertale_death_animation$progress);
            int startX = guiGraphics.m_280182_() / 2 - 91 - 2;
            int startY = guiGraphics.m_280206_() - 39 - 3;
            int lerpedX = (int)Mth.m_14139_((double)easedProgress, (double)startX, (double)x);
            int lerpedY = (int)Mth.m_14139_((double)easedProgress, (double)startY, (double)y);
            this.undertale_death_animation$renderHeart(guiGraphics, 0, lerpedX, lerpedY);
            if (lerpedX == x && lerpedY == y) {
                this.undertale_death_animation$shouldStart = true;
            }
        } else if (!this.undertale_death_animation$hasFinished && this.undertale_death_animation$age < 47) {
            this.undertale_death_animation$renderHeart(guiGraphics, this.undertale_death_animation$age < 25 ? 0 : Math.min(3, this.undertale_death_animation$age - 25), x, y);
        } else if (!this.undertale_death_animation$hasFinished && this.undertale_death_animation$pieces.isEmpty()) {
            for (int i1 = 0; i1 < this.undertale_death_animation$randomSource.m_216339_(6, 8); ++i1) {
                double angle = this.undertale_death_animation$randomSource.m_188500_() * 2.0 * Math.PI;
                double speed = 2.0 + this.undertale_death_animation$randomSource.m_188500_() * 2.0;
                double vx = Math.cos(angle) * speed;
                double vy = Math.sin(angle) * speed;
                this.undertale_death_animation$pieces.add(new HeartPiece((float)x + 6.5f, (float)y + 7.5f, vx, vy, this.undertale_death_animation$randomSource.m_188503_(8), this.undertale_death_animation$heartStyle * 5, this.undertale_death_animation$randomSource.m_188500_() * 360.0, this.undertale_death_animation$randomSource.m_188500_() * 8.0 - 2.0));
            }
        } else {
            if (this.undertale_death_animation$bgmProgress != -1 && this.undertale_death_animation$bgmProgress++ >= 35) {
                if (Config.INSTANCE.getDetermination()) {
                    this.undertale_death_animation$bgmSoundInstance = new BGMSoundInstance(SoundEventRegistry.DETERMINATION.get());
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.undertale_death_animation$bgmSoundInstance);
                    this.undertale_death_animation$bgmSoundInstance.fadeIn();
                }
                this.undertale_death_animation$bgmProgress = -1;
            }
            for (HeartPiece piece : this.undertale_death_animation$pieces) {
                piece.renderTick();
                piece.render(guiGraphics);
            }
        }
        if (!this.undertale_death_animation$hasFinished) {
            ci.cancel();
        }
    }

    @Unique
    private void undertale_death_animation$renderHeart(GuiGraphics guiGraphics, int stage, int x, int y) {
        guiGraphics.m_280163_((this.f_95908_ ? HEART_TEXTURE_LOCATION_HC : HEART_TEXTURE_LOCATION).m_246208_("textures/gui/sprites/").m_266382_(".png"), x, y, (float)(13 * stage), (float)(15 * this.undertale_death_animation$heartStyle), 13, 15, 52, 60);
    }

    @Override
    public void undertale_death_animation$stopBackgroundMusic() {
        Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)this.undertale_death_animation$bgmSoundInstance);
    }

    @WrapOperation(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fillGradient(IIIIII)V")}, require=0)
    private void disableTint(GuiGraphics instance, int i, int j, int k, int l, int m, int n, Operation<Void> original) {
    }
}

