/*
 * Decompiled with CFR 0.152.
 */
package org.rhm.undertale_death_screen.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import org.rhm.undertale_death_screen.BGMSoundInstance;
import org.rhm.undertale_death_screen.Config;
import org.rhm.undertale_death_screen.DeathScreenAccess;
import org.rhm.undertale_death_screen.HeartPiece;
import org.rhm.undertale_death_screen.UndertaleDeathScreenCommon;
import org.rhm.undertale_death_screen.registry.SoundEventRegistry;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DeathScreen.class})
public abstract class DeathScreenMixin
extends Screen
implements DeathScreenAccess {
    @Unique
    private static final List<Function<Player, Integer>> COLUMN_SELECTOR = List.of(player -> player.hasEffect(MobEffects.POISON) ? Integer.valueOf(1) : null, player -> player.hasEffect(MobEffects.WITHER) ? Integer.valueOf(2) : null, player -> player.isFreezing() ? Integer.valueOf(3) : null);
    @Unique
    private static final int HEART_WIDTH = 13;
    @Unique
    private static final int HEART_HEIGHT = 15;
    @Unique
    private static final int HEART_TEXTURE_WIDTH = 52;
    @Unique
    private static final int HEART_TEXTURE_HEIGHT = 60;
    @Unique
    private static final ResourceLocation HEART_TEXTURE_LOCATION = UndertaleDeathScreenCommon.id("undertale_death/heart_shatter");
    @Unique
    private static final ResourceLocation HEART_TEXTURE_LOCATION_HC = UndertaleDeathScreenCommon.id("undertale_death/heart_shatter_hardcore");
    @Shadow
    @Final
    private boolean field_18974;
    @Unique
    private RandomSource undertale_death_animation$randomSource;
    @Unique
    private List<HeartPiece> undertale_death_animation$pieces;
    @Unique
    private int undertale_death_animation$age;
    @Unique
    private int undertale_death_animation$finishedAge;
    @Unique
    private boolean undertale_death_animation$hasFinished;
    @Unique
    private boolean undertale_death_animation$shouldStart;
    @Unique
    private double undertale_death_animation$progress;
    @Unique
    private int undertale_death_animation$bgmProgress;
    @Unique
    private Integer undertale_death_animation$heartStyle;
    @Unique
    @Nullable
    private BGMSoundInstance undertale_death_animation$bgmSoundInstance;

    protected DeathScreenMixin(Component component) {
        super(component);
    }

    @Inject(method={"renderDeathBackground(Lnet/minecraft/client/gui/GuiGraphics;II)V"}, at={@At(value="HEAD")}, require=0, cancellable=true)
    private static void disableBackground(GuiGraphics guiGraphics, int i, int j, CallbackInfo ci) {
        ci.cancel();
    }

    @Shadow
    protected abstract void method_49299(boolean var1);

    @Inject(method={"<init>(Lnet/minecraft/network/chat/Component;Z)V"}, at={@At(value="TAIL")})
    private void setUpVariables(CallbackInfo ci) {
        if (Config.INSTANCE.getShouldStopSound()) {
            Minecraft.getInstance().getMusicManager().stopPlaying();
            Minecraft.getInstance().getSoundManager().stop();
        }
        this.undertale_death_animation$age = 0;
        this.undertale_death_animation$finishedAge = 0;
        this.undertale_death_animation$bgmProgress = 0;
        this.undertale_death_animation$progress = 0.0;
        this.undertale_death_animation$pieces = new ArrayList<HeartPiece>();
        this.undertale_death_animation$hasFinished = false;
        boolean bl = this.undertale_death_animation$shouldStart = !Config.INSTANCE.getCenteredHeartAnimation() && Config.INSTANCE.getCenteredHeart();
        if (Minecraft.getInstance().player != null) {
            this.undertale_death_animation$randomSource = Minecraft.getInstance().player.level().getRandom();
            this.undertale_death_animation$heartStyle = 0;
            if (Config.INSTANCE.getDynamicHeart()) {
                for (Function<Player, Integer> selector : COLUMN_SELECTOR) {
                    Integer style = selector.apply((Player)Minecraft.getInstance().player);
                    if (style == null) continue;
                    this.undertale_death_animation$heartStyle = style;
                    break;
                }
            }
        }
    }

    @Inject(method={"init()V"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        this.method_49299(true);
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void tick(CallbackInfo ci) {
        Minecraft.getInstance().getMusicManager().stopPlaying();
        if (!this.undertale_death_animation$pieces.isEmpty() && this.undertale_death_animation$pieces.stream().allMatch(piece -> piece.y >= (float)this.height) && !this.undertale_death_animation$hasFinished) {
            if (this.undertale_death_animation$finishedAge == 0) {
                this.undertale_death_animation$finishedAge = this.undertale_death_animation$age;
            } else if (this.undertale_death_animation$age - this.undertale_death_animation$finishedAge >= 5) {
                this.undertale_death_animation$pieces.clear();
                this.undertale_death_animation$hasFinished = true;
            }
        }
        ++this.undertale_death_animation$age;
        if (this.undertale_death_animation$age == 25) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEventRegistry.HEART_SHATTER_NOISES.get(), (float)1.0f));
        }
        if (!this.undertale_death_animation$hasFinished) {
            ci.cancel();
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void render(GuiGraphics guiGraphics, int i, int j, float delta, CallbackInfo ci) {
        int y;
        int x;
        if (Config.INSTANCE.getCenteredHeart()) {
            x = guiGraphics.guiWidth() / 2 - 6;
            y = guiGraphics.guiHeight() / 2 - 7;
        } else {
            x = guiGraphics.guiWidth() / 2 - 91 - 2;
            y = guiGraphics.guiHeight() - 39 - 3;
        }
        double fadeSpeed = Config.INSTANCE.getBackgroundFadeSpeed();
        int bgColor = 0;
        if (fadeSpeed > 0.0) {
            if (fadeSpeed >= 1.0) {
                bgColor = -16777216;
            } else {
                int alpha = (int)(Mth.smoothstep((double)Math.min((double)((float)this.undertale_death_animation$age + delta) * Math.pow(fadeSpeed, 0.5) / 5.0, 1.0)) * 255.0);
                bgColor = alpha << 24;
            }
        }
        if (bgColor >>> 24 > 0) {
            guiGraphics.fill(0, 0, guiGraphics.guiWidth(), guiGraphics.guiHeight(), bgColor);
        }
        if (!this.undertale_death_animation$shouldStart) {
            this.undertale_death_animation$progress = Math.min(this.undertale_death_animation$progress + (double)delta * Config.INSTANCE.getCenteredHeartSpeed(), 1.0);
            double easedProgress = Mth.smoothstep((double)this.undertale_death_animation$progress);
            int startX = guiGraphics.guiWidth() / 2 - 91 - 2;
            int startY = guiGraphics.guiHeight() - 39 - 3;
            int lerpedX = (int)Mth.lerp((double)easedProgress, (double)startX, (double)x);
            int lerpedY = (int)Mth.lerp((double)easedProgress, (double)startY, (double)y);
            this.undertale_death_animation$renderHeart(guiGraphics, 0, lerpedX, lerpedY);
            if (lerpedX == x && lerpedY == y) {
                this.undertale_death_animation$shouldStart = true;
            }
        } else if (!this.undertale_death_animation$hasFinished && this.undertale_death_animation$age < 47) {
            this.undertale_death_animation$renderHeart(guiGraphics, this.undertale_death_animation$age < 25 ? 0 : Math.min(3, this.undertale_death_animation$age - 25), x, y);
        } else if (!this.undertale_death_animation$hasFinished && this.undertale_death_animation$pieces.isEmpty()) {
            for (int i1 = 0; i1 < this.undertale_death_animation$randomSource.nextInt(6, 8); ++i1) {
                double angle = this.undertale_death_animation$randomSource.nextDouble() * 2.0 * Math.PI;
                double speed = 2.0 + this.undertale_death_animation$randomSource.nextDouble() * 2.0;
                double vx = Math.cos(angle) * speed;
                double vy = Math.sin(angle) * speed;
                this.undertale_death_animation$pieces.add(new HeartPiece((float)x + 6.5f, (float)y + 7.5f, vx, vy, this.undertale_death_animation$randomSource.nextInt(8), this.undertale_death_animation$heartStyle * 5, this.undertale_death_animation$randomSource.nextDouble() * 360.0, this.undertale_death_animation$randomSource.nextDouble() * 8.0 - 2.0));
            }
        } else {
            if (this.undertale_death_animation$bgmProgress != -1 && this.undertale_death_animation$bgmProgress++ >= 35) {
                if (Config.INSTANCE.getDetermination()) {
                    this.undertale_death_animation$bgmSoundInstance = new BGMSoundInstance(SoundEventRegistry.DETERMINATION.get());
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)this.undertale_death_animation$bgmSoundInstance);
                    this.undertale_death_animation$bgmSoundInstance.fadeIn();
                }
                this.undertale_death_animation$bgmProgress = -1;
            }
            for (HeartPiece piece : this.undertale_death_animation$pieces) {
                piece.renderTick();
                piece.render(guiGraphics);
            }
        }
        if (!this.undertale_death_animation$hasFinished) {
            ci.cancel();
        }
    }

    @Unique
    private void undertale_death_animation$renderHeart(GuiGraphics guiGraphics, int stage, int x, int y) {
        guiGraphics.blitSprite(this.field_18974 ? HEART_TEXTURE_LOCATION_HC : HEART_TEXTURE_LOCATION, 52, 60, 13 * stage, 15 * this.undertale_death_animation$heartStyle, x, y, 13, 15);
    }

    @Override
    public void undertale_death_animation$stopBackgroundMusic() {
        Minecraft.getInstance().getSoundManager().stop((SoundInstance)this.undertale_death_animation$bgmSoundInstance);
    }

    @WrapOperation(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fillGradient(IIIIII)V")}, require=0)
    private void disableTint(GuiGraphics instance, int i, int j, int k, int l, int m, int n, Operation<Void> original) {
    }
}

