/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.loot;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.init.ModItems;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class HayBackpackLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<HayBackpackLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> HayBackpackLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ItemStack.CODEC.listOf().fieldOf("possibleCropItems").forGetter(m -> m.possibleCropItems)).and((App)Codec.FLOAT.fieldOf("cropFromGrassChance").forGetter(m -> Float.valueOf(m.cropFromGrassChance))).and((App)Codec.FLOAT.fieldOf("multiplierChance").forGetter(m -> Float.valueOf(m.multiplierChance))).and((App)Codec.INT.fieldOf("multiplierAmount").forGetter(m -> m.multiplierAmount)).apply((Applicative)inst, HayBackpackLootModifier::new)));
    private final List<ItemStack> possibleCropItems;
    private final float cropFromGrassChance;
    private final float multiplierChance;
    private final int multiplierAmount;

    protected HayBackpackLootModifier(LootItemCondition[] conditionsIn, List<ItemStack> possibleCropItems, float cropFromGrassChance, float multiplierChance, int multiplierAmount) {
        super(conditionsIn);
        this.possibleCropItems = possibleCropItems;
        this.cropFromGrassChance = cropFromGrassChance;
        this.multiplierChance = multiplierChance;
        this.multiplierAmount = multiplierAmount;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Player player;
        BlockState blockState = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
        boolean grassVariant = false;
        if (blockState == null) {
            return generatedLoot;
        }
        if (blockState.getBlock() instanceof TallGrassBlock) {
            grassVariant = true;
        }
        if (!(grassVariant || blockState.getBlock() instanceof CropBlock && blockState.hasProperty((Property)CropBlock.AGE) && (Integer)blockState.getValue((Property)CropBlock.AGE) == 7)) {
            return generatedLoot;
        }
        Entity entity = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (entity instanceof Player && BackpackAbilities.ABILITIES.checkBackpack(player = (Player)entity, (Item)ModItems.HAY_TRAVELERS_BACKPACK.get())) {
            if (grassVariant) {
                if (context.getRandom().nextFloat() < this.cropFromGrassChance && !this.possibleCropItems.isEmpty()) {
                    ItemStack randomCrop = this.possibleCropItems.get(context.getRandom().nextInt(this.possibleCropItems.size()));
                    generatedLoot.add((Object)randomCrop);
                }
            } else {
                for (ItemStack stack : generatedLoot) {
                    if (!(context.getRandom().nextFloat() < this.multiplierChance)) continue;
                    int count = stack.getCount();
                    stack.setCount(count * this.multiplierAmount);
                }
            }
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return (MapCodec)CODEC.get();
    }
}

