/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.mojang.serialization.Codec;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ClientboundSyncItemStackPacket(int entityId, int slot, ItemStack itemStackInstance, DataComponentMap map) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"sync_itemstack");
    public static final CustomPacketPayload.Type<ClientboundSyncItemStackPacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundSyncItemStackPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ClientboundSyncItemStackPacket::entityId, (StreamCodec)ByteBufCodecs.INT, ClientboundSyncItemStackPacket::slot, (StreamCodec)ByteBufCodecs.fromCodec((Codec)ItemStack.SIMPLE_ITEM_CODEC), ClientboundSyncItemStackPacket::itemStackInstance, (StreamCodec)ByteBufCodecs.fromCodecWithRegistries((Codec)DataComponentMap.CODEC), ClientboundSyncItemStackPacket::map, ClientboundSyncItemStackPacket::new);

    public static void handle(ClientboundSyncItemStackPacket message, IPayloadContext ctx) {
        if (ctx.flow().isClientbound()) {
            ctx.enqueueWork(() -> {
                Player player = (Player)Minecraft.getInstance().player.level().getEntity(message.entityId());
                if (player != null && message.slot() == -1) {
                    AbstractContainerMenu patt0$temp = player.containerMenu;
                    if (patt0$temp instanceof BackpackBaseMenu) {
                        BackpackBaseMenu menu = (BackpackBaseMenu)patt0$temp;
                        ItemStack oldStack = menu.getWrapper().getBackpackStack().copy();
                        oldStack.applyComponents(message.map());
                        menu.getWrapper().setBackpackStack(oldStack);
                        return;
                    }
                    return;
                }
                if (player != null && ((ItemStack)player.getInventory().items.get(message.slot())).is(message.itemStackInstance().getItem())) {
                    int changedMode;
                    ItemStack oldStack = ((ItemStack)player.getInventory().items.get(message.slot())).copy();
                    ((ItemStack)player.getInventory().items.get(message.slot())).applyComponents(message.map());
                    ItemStack newStack = ((ItemStack)player.getInventory().items.get(message.slot())).copy();
                    AbstractContainerMenu patt0$temp = player.containerMenu;
                    if (patt0$temp instanceof BackpackBaseMenu) {
                        BackpackBaseMenu menu = (BackpackBaseMenu)patt0$temp;
                        menu.getWrapper().setBackpackStack((ItemStack)player.getInventory().items.get(message.slot()));
                    }
                    if (message.map().has((DataComponentType)ModDataComponents.HOSE_MODES.get()) && (changedMode = ClientboundSyncItemStackPacket.getChangedMode(oldStack, newStack)) != -1) {
                        player.displayClientMessage(ClientboundSyncItemStackPacket.getNextModeMessage(changedMode, (Integer)((List)message.map().get((DataComponentType)ModDataComponents.HOSE_MODES.get())).get(changedMode)), true);
                    }
                }
            });
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static int getChangedMode(ItemStack oldStack, ItemStack newStack) {
        if (((List)oldStack.getOrDefault(ModDataComponents.HOSE_MODES, List.of(Integer.valueOf(0), Integer.valueOf(0)))).get(0) != ((List)newStack.getOrDefault(ModDataComponents.HOSE_MODES, List.of(Integer.valueOf(0), Integer.valueOf(0)))).get(0)) {
            return 0;
        }
        if (((List)oldStack.getOrDefault(ModDataComponents.HOSE_MODES, List.of(Integer.valueOf(0), Integer.valueOf(0)))).get(1) != ((List)newStack.getOrDefault(ModDataComponents.HOSE_MODES, List.of(Integer.valueOf(0), Integer.valueOf(0)))).get(1)) {
            return 1;
        }
        return -1;
    }

    public static Component getNextModeMessage(int changedMode, int data) {
        if (changedMode == 0) {
            if (data == 2) {
                return Component.translatable((String)"item.travelersbackpack.hose.spill");
            }
            if (data == 3) {
                return Component.translatable((String)"item.travelersbackpack.hose.drink");
            }
            return Component.translatable((String)"item.travelersbackpack.hose.suck");
        }
        if (data == 1) {
            return Component.translatable((String)"item.travelersbackpack.hose.tank_left");
        }
        return Component.translatable((String)"item.travelersbackpack.hose.tank_right");
    }
}

