/*
 * Decompiled with CFR 0.152.
 */
package throwabletnt;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@Mod(value="tnt_grenades")
public class ThrowableTNT {
    private final HashMap<UUID, Integer> cooldowns = new HashMap();

    public ThrowableTNT() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickItem event) {
        UUID playerId;
        int cd;
        Player player = event.getEntity();
        Level world = player.level();
        if (world.isClientSide) {
            return;
        }
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ItemStack mainhand = player.getMainHandItem();
        ItemStack offhand = player.getOffhandItem();
        if (mainhand.getItem() == Items.TNT && offhand.getItem() == Items.FLINT_AND_STEEL && (cd = this.cooldowns.getOrDefault(playerId = player.getUUID(), 0).intValue()) <= 0) {
            boolean isCreative = player.getAbilities().instabuild;
            if (!isCreative) {
                mainhand.shrink(1);
                offhand.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.OFFHAND);
            }
            PrimedTnt tnt = new PrimedTnt(world, player.getX(), player.getEyeY(), player.getZ(), (LivingEntity)player);
            tnt.setFuse(65);
            tnt.setDeltaMovement(player.getLookAngle().scale(1.5));
            world.addFreshEntity((Entity)tnt);
            this.cooldowns.put(playerId, 15);
        }
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post event) {
        this.cooldowns.replaceAll((uuid, cd) -> cd > 0 ? cd - 1 : 0);
    }
}

