/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.knockable.network;

import net.fabricmc.fabric.api.gamerule.v1.rule.DoubleRule;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.server.MinecraftServer;
import net.shirojr.knockable.init.KnockableGamerules;
import net.shirojr.knockable.init.KnockableSounds;
import net.shirojr.knockable.init.KnockableTags;
import net.shirojr.knockable.network.NetworkIdentifiers;

public class KnockableC2SNetworking {
    private static void handleKnockingRaycast(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        class_2338 hitPos = buf.method_10811();
        server.execute(() -> {
            float pitch;
            class_3218 world = player.method_51469();
            class_2680 hitState = world.method_8320(hitPos);
            if (!hitState.method_26164(KnockableTags.Blocks.KNOCKABLE_BLOCKS)) {
                return;
            }
            double maxRange = ((DoubleRule)world.method_8450().method_20746(KnockableGamerules.KNOCKING_RANGE)).get();
            double sqMaxRange = maxRange * maxRange;
            double sqDistanceToBlock = player.method_5707(hitPos.method_46558());
            if (sqDistanceToBlock > sqMaxRange) {
                return;
            }
            float minPitch = 0.85f;
            float maxPitch = 1.2f;
            class_2586 patt0$temp = world.method_8321(hitPos);
            if (patt0$temp instanceof class_1263) {
                class_1263 inventory = (class_1263)patt0$temp;
                int occupiedSlots = 0;
                for (int i = 0; i < inventory.method_5439(); ++i) {
                    if (inventory.method_5438(i).method_7960()) continue;
                    ++occupiedSlots;
                }
                pitch = class_3532.method_16439((float)(1.0f - (float)occupiedSlots / (float)inventory.method_5439()), (float)minPitch, (float)maxPitch);
            } else {
                float normalizedDistance = (float)class_3532.method_15350((double)(sqDistanceToBlock / sqMaxRange), (double)0.0, (double)1.0);
                pitch = class_3532.method_16439((float)normalizedDistance, (float)minPitch, (float)maxPitch);
            }
            world.method_8396(null, hitPos, KnockableSounds.KNOCK, class_3419.field_15245, 2.0f, pitch);
        });
    }

    public static void initialize() {
    }

    static {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)NetworkIdentifiers.KNOCKING_RAYCAST, KnockableC2SNetworking::handleKnockingRaycast);
    }
}

