/*
 * Decompiled with CFR 0.152.
 */
package de.adventurecraft.business.nsb_utils.blocks;

import de.adventurecraft.business.nsb_utils.items.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="nsb_utils")
public class BlockBreakEventHandler {
    private static final List<Item> SAPLINGS = new ArrayList<Item>();

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Level level = (Level)event.getLevel();
        if (level.isClientSide() || event.getPlayer() == null) {
            return;
        }
        if (event.getState().is(Blocks.DIRT) && event.getPlayer().getMainHandItem().is((Item)ModItems.CROOK.get())) {
            event.setCanceled(true);
            BlockPos pos = event.getPos();
            RandomSource random = level.getRandom();
            int dropCount = random.nextInt(4) + 2;
            for (int i = 0; i < dropCount; ++i) {
                Item randomSapling = SAPLINGS.get(random.nextInt(SAPLINGS.size()));
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)randomSapling));
            }
            level.destroyBlock(pos, false);
        }
    }

    static {
        SAPLINGS.add(Blocks.OAK_SAPLING.asItem());
        SAPLINGS.add(Blocks.BIRCH_SAPLING.asItem());
        SAPLINGS.add(Blocks.SPRUCE_SAPLING.asItem());
        SAPLINGS.add(Blocks.DARK_OAK_SAPLING.asItem());
        SAPLINGS.add(Blocks.ACACIA_SAPLING.asItem());
        SAPLINGS.add(Blocks.JUNGLE_SAPLING.asItem());
        SAPLINGS.add(Blocks.CHERRY_SAPLING.asItem());
    }
}

