/*
 * Decompiled with CFR 0.152.
 */
package de.adventurecraft.business.nsb_utils.blocks;

import de.adventurecraft.business.nsb_utils.blocks.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="nsb_utils")
public class BlockReplaceEventHandler {
    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Level level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level && !(level = (Level)levelAccessor).isClientSide()) {
            BlockState brokenState = event.getState();
            BlockPos pos = event.getPos();
            if (brokenState.is((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"stone")))) {
                event.setCanceled(true);
                Item dropItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"exdeorum", (String)"stone_pebble"));
                if (dropItem != null) {
                    ItemStack dropStack = new ItemStack((ItemLike)dropItem, 1);
                    ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, dropStack);
                    level.addFreshEntity((Entity)itemEntity);
                }
                level.setBlock(pos, ((Block)ModBlocks.CRACKED_STONE.get()).defaultBlockState(), 3);
            }
        }
    }
}

