/*
 * Decompiled with CFR 0.152.
 */
package fuzs.villagemasquerade;

import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.AddBlockEntityTypeBlocksCallback;
import fuzs.puzzleslib.api.event.v1.entity.ServerEntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDropsCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingVisibilityCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.MobEffectEvents;
import fuzs.puzzleslib.api.event.v1.server.LootTableLoadCallback;
import fuzs.villagemasquerade.VillagerTradesContext;
import fuzs.villagemasquerade.handler.ClothingEquipmentHandler;
import fuzs.villagemasquerade.init.ModBlocks;
import fuzs.villagemasquerade.init.ModItems;
import fuzs.villagemasquerade.init.ModLootTables;
import fuzs.villagemasquerade.init.ModRegistry;
import fuzs.villagemasquerade.util.VillagerTradingHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerProfession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VillageMasquerade
implements ModConstructor {
    public static final String MOD_ID = "villagemasquerade";
    public static final String MOD_NAME = "Village Masquerade";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Village Masquerade");

    public void onConstructMod() {
        ModRegistry.bootstrap();
        VillageMasquerade.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        AddBlockEntityTypeBlocksCallback.EVENT.register(ModBlocks::onAddBlockEntityTypeBlocks);
        LivingDropsCallback.EVENT.register(ClothingEquipmentHandler::onLivingDrops);
        LootTableLoadCallback.EVENT.register(ModLootTables::onLootTableLoad);
        ServerEntityLevelEvents.LOAD.register(ClothingEquipmentHandler::onEntityLoad);
        MobEffectEvents.AFFECTS.register(ClothingEquipmentHandler::onMobEffectAffects);
        LivingVisibilityCallback.EVENT.register(ClothingEquipmentHandler::onLivingVisibility);
    }

    public void onRegisterVillagerTrades(VillagerTradesContext context) {
        BuiltInRegistries.ITEM.listElements().filter(holder -> holder.key().location().getNamespace().equals(MOD_ID)).map(Holder.Reference::value).forEach(item -> {
            ResourceKey resourceKey = (ResourceKey)item.components().getOrDefault((DataComponentType)ModRegistry.VILLAGER_PROFESSION_DATA_COMPONENT_TYPE.value(), (Object)VillagerProfession.NONE);
            if (resourceKey != VillagerProfession.NONE) {
                context.registerVillagerTrades((ResourceKey<VillagerProfession>)resourceKey, VillagerTradesContext.VillagerLevel.MASTER, itemListings -> itemListings.add(VillagerTradingHelper.createVillagerItemListing(item)));
            }
        });
        context.registerWanderingTrades(VillagerTradesContext.WanderingTradesPool.SPECIAL_SALES, VillagerTradingHelper.createWanderingItemListing(ModItems.WANDERING_TRADER_HOOD_ITEM), VillagerTradingHelper.createWanderingItemListing(ModItems.WANDERING_TRADER_ROBE_ITEM), VillagerTradingHelper.createWanderingItemListing(ModItems.WANDERING_TRADER_LEGGINGS_ITEM));
    }

    public static ResourceLocation id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

