/*
 * Decompiled with CFR 0.152.
 */
package fuzs.villagemasquerade.init;

import fuzs.villagemasquerade.init.ModRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class ModLootTables {
    static final Map<ResourceLocation, ResourceKey<LootTable>> LOOT_TABLE_INJECTIONS = new HashMap<ResourceLocation, ResourceKey<LootTable>>();
    public static final ResourceKey<LootTable> IGLOO_CHEST_INJECTION = ModLootTables.registerLootTableInjection((ResourceKey<LootTable>)BuiltInLootTables.IGLOO_CHEST);
    public static final ResourceKey<LootTable> VILLAGE_PLAINS_HOUSE_INJECTION = ModLootTables.registerLootTableInjection((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_PLAINS_HOUSE);
    public static final ResourceKey<LootTable> VILLAGE_DESERT_HOUSE_INJECTION = ModLootTables.registerLootTableInjection((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_DESERT_HOUSE);
    public static final ResourceKey<LootTable> VILLAGE_SNOWY_HOUSE_INJECTION = ModLootTables.registerLootTableInjection((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_SNOWY_HOUSE);
    public static final ResourceKey<LootTable> VILLAGE_TAIGA_HOUSE_INJECTION = ModLootTables.registerLootTableInjection((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_TAIGA_HOUSE);
    public static final ResourceKey<LootTable> VILLAGE_SAVANNA_HOUSE_INJECTION = ModLootTables.registerLootTableInjection((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_SAVANNA_HOUSE);
    public static final ResourceKey<LootTable> EVOKER_INJECTION = ModLootTables.registerLootTableInjection((ResourceKey<LootTable>)((ResourceKey)EntityType.EVOKER.getDefaultLootTable().orElseThrow()));
    public static final ResourceKey<LootTable> VINDICATOR_INJECTION = ModLootTables.registerLootTableInjection((ResourceKey<LootTable>)((ResourceKey)EntityType.VINDICATOR.getDefaultLootTable().orElseThrow()));
    public static final ResourceKey<LootTable> PILLAGER_INJECTION = ModLootTables.registerLootTableInjection((ResourceKey<LootTable>)((ResourceKey)EntityType.PILLAGER.getDefaultLootTable().orElseThrow()));
    public static final ResourceKey<LootTable> WITCH_INJECTION = ModLootTables.registerLootTableInjection((ResourceKey<LootTable>)((ResourceKey)EntityType.WITCH.getDefaultLootTable().orElseThrow()));
    public static final ResourceKey<LootTable> IRON_GOLEM_INJECTION = ModLootTables.registerLootTableInjection((ResourceKey<LootTable>)((ResourceKey)EntityType.IRON_GOLEM.getDefaultLootTable().orElseThrow()));

    public static void bootstrap() {
    }

    static ResourceKey<LootTable> registerLootTableInjection(ResourceKey<LootTable> resourceKey) {
        ResourceKey newResourceKey = ModRegistry.REGISTRIES.makeResourceKey(Registries.LOOT_TABLE, "inject/" + resourceKey.location().getPath());
        LOOT_TABLE_INJECTIONS.put(resourceKey.location(), (ResourceKey<LootTable>)newResourceKey);
        return newResourceKey;
    }

    public static void onLootTableLoad(ResourceLocation resourceLocation, LootTable.Builder lootTable, HolderLookup.Provider registries) {
        if (LOOT_TABLE_INJECTIONS.containsKey(resourceLocation)) {
            lootTable.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference(LOOT_TABLE_INJECTIONS.get(resourceLocation))));
        }
    }
}

