/*
 * Decompiled with CFR 0.152.
 */
package fuzs.villagemasquerade.util;

import fuzs.villagemasquerade.init.ModRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class VillagerTradingHelper {
    public static VillagerTrades.ItemListing createVillagerItemListing(Item item) {
        return VillagerTradingHelper.createItemListing(item, 30, 0.2f);
    }

    public static VillagerTrades.ItemListing createWanderingItemListing(Holder<Item> item) {
        return VillagerTradingHelper.createItemListing((Item)item.value(), 1, 0.05f);
    }

    private static VillagerTrades.ItemListing createItemListing(Item item, int villagerXp, float priceMultiplier) {
        int priceForPiece = VillagerTradingHelper.getPriceForPiece(VillagerTradingHelper.getArmorEquipmentSlot(item));
        return new VillagerTrades.ItemsForEmeralds(new ItemStack((ItemLike)item), priceForPiece, 1, 1, villagerXp, priceMultiplier);
    }

    private static EquipmentSlot getArmorEquipmentSlot(Item item) {
        EquipmentSlot equipmentSlot;
        if (item.components().has(DataComponents.EQUIPPABLE) && (equipmentSlot = ((Equippable)item.components().get(DataComponents.EQUIPPABLE)).slot()).getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
            return equipmentSlot;
        }
        throw new IllegalArgumentException("No armor: " + String.valueOf(item));
    }

    private static int getPriceForPiece(EquipmentSlot equipmentSlot) {
        return switch (equipmentSlot) {
            case EquipmentSlot.FEET, EquipmentSlot.HEAD -> 8;
            case EquipmentSlot.CHEST -> 16;
            case EquipmentSlot.LEGS -> 12;
            default -> throw new IllegalArgumentException();
        };
    }

    public static void updateSpecialPrices(Villager villager, Player player) {
        int equippedArmorForProfession = VillagerTradingHelper.getEquippedArmorForProfession(player, villager.getVillagerData());
        if (equippedArmorForProfession > 0) {
            for (MerchantOffer merchantOffer : villager.getOffers()) {
                double priceMultiplier = 0.3 + 0.0625 * (double)equippedArmorForProfession;
                int newPriceInItems = (int)Math.floor(priceMultiplier * (double)merchantOffer.getBaseCostA().getCount());
                merchantOffer.addToSpecialPriceDiff(-Math.max(newPriceInItems, 1));
            }
        }
    }

    private static int getEquippedArmorForProfession(Player player, VillagerData villagerData) {
        int equippedArmorForProfession = 0;
        for (EquipmentSlot equipmentSlot : EquipmentSlotGroup.ARMOR) {
            ItemStack itemStack;
            ResourceKey resourceKey;
            if (equipmentSlot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR || (resourceKey = (ResourceKey)(itemStack = player.getItemBySlot(equipmentSlot)).get((DataComponentType)ModRegistry.VILLAGER_PROFESSION_DATA_COMPONENT_TYPE.value())) == null || !villagerData.profession().is(resourceKey)) continue;
            ++equippedArmorForProfession;
        }
        return equippedArmorForProfession;
    }
}

