/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.lycanthropes.init;

import net.mcreator.lycanthropes.network.ClimbMessage;
import net.mcreator.lycanthropes.network.LycanMenuMessage;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class LycanthropesModKeyMappings {
    public static final KeyMapping CLIMB = new KeyMapping("key.lycanthropes.climb", 32, "key.categories.misc"){
        private boolean isDownOld = false;

        public void setDown(boolean isDown) {
            super.setDown(isDown);
            if (this.isDownOld != isDown && isDown) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ClimbMessage(0, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ClimbMessage.pressAction((Player)Minecraft.getInstance().player, 0, 0);
            }
            this.isDownOld = isDown;
        }
    };
    public static final KeyMapping LYCAN_MENU = new KeyMapping("key.lycanthropes.lycan_menu", 75, "key.categories.lycanthropes"){
        private boolean isDownOld = false;

        public void setDown(boolean isDown) {
            super.setDown(isDown);
            if (this.isDownOld != isDown && isDown) {
                LYCAN_MENU_LASTPRESS = System.currentTimeMillis();
            } else if (this.isDownOld != isDown && !isDown) {
                int dt = (int)(System.currentTimeMillis() - LYCAN_MENU_LASTPRESS);
                PacketDistributor.sendToServer((CustomPacketPayload)new LycanMenuMessage(1, dt), (CustomPacketPayload[])new CustomPacketPayload[0]);
                LycanMenuMessage.pressAction((Player)Minecraft.getInstance().player, 1, dt);
            }
            this.isDownOld = isDown;
        }
    };
    private static long LYCAN_MENU_LASTPRESS = 0L;

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(CLIMB);
        event.register(LYCAN_MENU);
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class KeyEventListener {
        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Post event) {
            if (Minecraft.getInstance().screen == null) {
                CLIMB.consumeClick();
                LYCAN_MENU.consumeClick();
            }
        }
    }
}

