/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.lycanthropes.network;

import net.mcreator.lycanthropes.LycanthropesMod;
import net.mcreator.lycanthropes.procedures.BigPressedProcedure;
import net.mcreator.lycanthropes.procedures.SlimKeyPressedProcedure;
import net.mcreator.lycanthropes.procedures.SmallPressedProcedure;
import net.mcreator.lycanthropes.procedures.TransformKeyPressedProcedure;
import net.mcreator.lycanthropes.procedures.TurnbackKeyPressedProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record LycanMenuGUI2ButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<LycanMenuGUI2ButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"lycanthropes", (String)"lycan_menu_gui_2_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, LycanMenuGUI2ButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new LycanMenuGUI2ButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<LycanMenuGUI2ButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(LycanMenuGUI2ButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> LycanMenuGUI2ButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            SmallPressedProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            TransformKeyPressedProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            BigPressedProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            SlimKeyPressedProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            TurnbackKeyPressedProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            SlimKeyPressedProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        LycanthropesMod.addNetworkMessage(TYPE, STREAM_CODEC, LycanMenuGUI2ButtonMessage::handleData);
    }
}

