package net.db64.homelawnsecurity.block.custom;

import net.db64.homelawnsecurity.block.ModBlocks;
import net.db64.homelawnsecurity.entity.custom.PlantEntity;
import net.db64.homelawnsecurity.entity.custom.ZombieEntity;
import net.db64.homelawnsecurity.entity.custom.other.CurrencyEntity;
import net.db64.homelawnsecurity.item.ModItems;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_5819;

public class CurrencySpawnerBlock extends class_2248 {
	public final class_1799 stack;
	//private static final float SPAWN_CHANCE = 0.1f;
	private static final int SPAWN_DISTANCE = 10;
	private static final int SPAWN_TICKS = 200;
	private static final int INITIAL_SPAWN_TICKS = 20;

	public CurrencySpawnerBlock(class_2251 settings, class_1799 stack) {
		super(settings);
		this.stack = stack;
	}

	public class_1799 getDefaultItemStack() {
		return new class_1799(ModItems.SUN);
	}

	@Override
	protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
		return class_2248.method_9541(2, 0, 2, 14, 12, 14);
	}

	/*@Override
	protected void randomTick(BlockState state, ServerWorld world, BlockPos pos, Random random) {
		super.randomTick(state, world, pos, random);

		//HomeLawnSecurity.LOGGER.info("currency spawner block at {} ticked", pos.toShortString());

		if (random.nextFloat() < SPAWN_CHANCE) {
			spawnCurrency(world, pos, random);
		}
	}*/

	protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
		super.method_9588(state, world, pos, random);

		if (world instanceof class_3218) {
			//HomeLawnSecurity.LOGGER.info("currency spawner block at {} ticked", pos.toShortString());

			//if (random.nextFloat() < SPAWN_CHANCE) {
			if (!world.method_49803(pos) && world.method_8530()) {
				spawnCurrency(world, pos, random);
			}

			world.method_64310(pos, this, SPAWN_TICKS);
		}
	}

	@Override
	protected void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
		super.method_9615(state, world, pos, oldState, notify);

		world.method_64310(pos, this, INITIAL_SPAWN_TICKS);
	}

	/*@Override
	protected boolean hasRandomTicks(BlockState state) {
		return true;
	}*/

	public void spawnCurrency(class_3218 world, class_2338 pos, class_5819 random) {
		Iterable<class_2338> iterable = class_2338.method_34848(random, 30, pos, SPAWN_DISTANCE);

		if (world.method_8320(pos).method_26204() != ModBlocks.BRAINPOWER_BEACON) {
			for (class_2338 pos2 : iterable) {
				class_2338 spawnPos = getGroundPos(world, pos2);
				if (isValidSunSpawnLocation(world, spawnPos)) {
					world.method_8649(new CurrencyEntity(spawnPos.method_10263() + 0.5, spawnPos.method_10264() + 16, spawnPos.method_10260() + 0.5, world, stack.method_7972()));
					break;
				}
			}
		}
		else {
			for (class_2338 pos2 : iterable) {
				class_2338 spawnPos = getGroundPos(world, pos2);
				if (isValidBrainpowerSpawnLocation(world, spawnPos)) {
					world.method_8649(new CurrencyEntity(spawnPos.method_10263() + 0.5, spawnPos.method_10264() + 16, spawnPos.method_10260() + 0.5, world, stack.method_7972()));
					break;
				}
			}
		}
	}

	public class_2338 getGroundPos(class_3218 world, class_2338 pos) {
		class_2338 pos2 = pos;
		class_2680 state = world.method_8320(pos2);

		while (pos.method_10264() > world.method_31607() && state.method_26167())
		{
			pos2 = pos2.method_10074();
			state = world.method_8320(pos2);
		}

		//HomeLawnSecurity.LOGGER.info("block at {} is not transparent", pos2.toShortString());

		return pos2;
	}

	public static boolean isValidSunSpawnLocation(class_3218 world, class_2338 pos) {
		/*BlockState state = world.getBlockState(pos);
		BlockState markerState = world.getBlockState(pos.up());

		if (markerState.isIn(ModTags.Blocks.REVEALS_MARKERS)) {
			return markerState.isIn(ModTags.Blocks.PLANT_PLACEABLE_LAWN_MARKERS);
		}
		return state.isIn(ModTags.Blocks.PLANT_PLACEABLE_LAWN);*/

		return PlantEntity.isPlaceableLawn(pos, world) || PlantEntity.isPlaceablePath(pos, world);
	}

	public static boolean isValidBrainpowerSpawnLocation(class_3218 world, class_2338 pos) {
		/*BlockState state = world.getBlockState(pos);
		BlockState markerState = world.getBlockState(pos.up());

		if (markerState.isIn(ModTags.Blocks.REVEALS_MARKERS)) {
			return markerState.isIn(ModTags.Blocks.PLANT_PLACEABLE_LAWN_MARKERS);
		}
		return state.isIn(ModTags.Blocks.PLANT_PLACEABLE_LAWN);*/

		return ZombieEntity.isPlaceable(pos, world);
	}
}
