package net.db64.homelawnsecurity.block.custom.lawn;

import net.db64.homelawnsecurity.HomeLawnSecurity;
import net.db64.homelawnsecurity.util.LawnUtil;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2758;

public interface ILawnBlock {
	int PATH_TYPE_AMOUNT = 4;

	class_2758 PATH_ID_MAIN = class_2758.method_11867("path_id_main", 0, PATH_TYPE_AMOUNT);
	class_2758 PATH_ID_INTERSECTING = class_2758.method_11867("path_id_intersecting", 0, PATH_TYPE_AMOUNT);
	//BooleanProperty TURF = BooleanProperty.of("turf");

	static boolean isPath(class_2680 state) {
		return state.method_26204() instanceof ILawnBlock && getMainPathId(state) != 0;
	}

	static void setMainPathId(class_2338 pos, class_1937 world, int pathId) {
		class_2680 state = world.method_8320(pos);
		if (state.method_26204() instanceof ILawnBlock) {
			if (pathId == 0) {
				world.method_8501(pos, world.method_8320(pos).method_11657(PATH_ID_MAIN, pathId).method_11657(PATH_ID_INTERSECTING, 0));
			}
			else if (pathId <= PATH_TYPE_AMOUNT && pathId >= 0) {
				if (pathId == getIntersectingPathId(state))
					world.method_8501(pos, state.method_11657(PATH_ID_MAIN, pathId).method_11657(PATH_ID_INTERSECTING, 0));
				else
					world.method_8501(pos, state.method_11657(PATH_ID_MAIN, pathId));
			}
			else {
				HomeLawnSecurity.LOGGER.warn("Attempted to set main path of block {} to value outside of bounds!", pos.method_23854());
			}
		}
		else {
			HomeLawnSecurity.LOGGER.warn("Attempted to set main path of block {}, but the block isn't a lawn block!", pos.method_23854());
		}
	}

	static void setIntersectingPathId(class_2338 pos, class_1937 world, int pathId) {
		class_2680 state = world.method_8320(pos);
		if (state.method_26204() instanceof ILawnBlock) {
			if (pathId <= PATH_TYPE_AMOUNT && pathId >= 0) {
				if (getMainPathId(state) != 0) {
					if (pathId == getMainPathId(state))
						world.method_8501(pos, state.method_11657(PATH_ID_MAIN, pathId).method_11657(PATH_ID_INTERSECTING, 0));
					else
						world.method_8501(pos, state.method_11657(PATH_ID_INTERSECTING, pathId));
				}
			}
			else {
				HomeLawnSecurity.LOGGER.warn("Attempted to set intersecting path of block {} to value outside of bounds!", pos.method_23854());
			}
		}
		else {
			HomeLawnSecurity.LOGGER.warn("Attempted to set intersecting path of block {}, but the block isn't a lawn block!", pos.method_23854());
		}
	}

	/**
	 * Expects the block to use this class!
	 */
	static void removePath(class_2338 pos, class_1937 world) {
		setMainPathId(pos, world, 0);
	}

	/**
	 * Expects the block to use this class!
	 */
	static int getMainPathId(class_2680 state) {
		return state.method_11654(PATH_ID_MAIN);
	}

	/**
	 * Expects the block to use this class!
	 */
	static int getIntersectingPathId(class_2680 state) {
		return state.method_11654(PATH_ID_INTERSECTING);
	}

	/**
	 * Expects the block to use this class!
	 */
	@Deprecated
	static void setTurf(class_2338 pos, class_1937 world, boolean turf) {
		//world.setBlockState(pos, world.getBlockState(pos).with(TURF, turf));
	}

	static boolean getTurf(class_2680 state) {
		//return state.get(TURF);
		class_2248 block = state.method_26204();
		return block instanceof SoddedLawnBlockBlock || block instanceof SoddedLawnMarkerBlock;
	}


	/**
	 * Expects the block to use this class!
	 */
	static int getNextMainPathId(class_2680 state) {
		int result = (getMainPathId(state) + 1) % (LawnUtil.getPathTypeAmount() + 1);
		if (result != 0 && result == getIntersectingPathId(state)) return (result + 1) % (LawnUtil.getPathTypeAmount() + 1);
		return result;
	}


	/**
	 * Expects the block to use this class!
	 */
	static int getNextIntersectingPathId(class_2680 state) {
		int result = (getIntersectingPathId(state) + 1) % (LawnUtil.getPathTypeAmount() + 1);
		if (result != 0 && result == getMainPathId(state)) return (result + 1) % (LawnUtil.getPathTypeAmount() + 1);
		return result;
	}
}
