package net.db64.homelawnsecurity.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;
import net.minecraft.class_9473;

public record CurrencyComponent(int amount, String name) implements class_9299 {
	public static final Codec<CurrencyComponent> CODEC = RecordCodecBuilder.create(
		instance -> instance.group(
				class_5699.field_33441.fieldOf("amount").forGetter(CurrencyComponent::amount),
				class_5699.field_41759.fieldOf("name").forGetter(CurrencyComponent::name)
			)
			.apply(instance, CurrencyComponent::new)
	);
	public static final class_9139<class_9129, CurrencyComponent> PACKET_CODEC = class_9139.method_56435(
		class_9135.field_48550,
		CurrencyComponent::amount,
		class_9135.field_48554,
		CurrencyComponent::name,
		CurrencyComponent::new
	);

	@Override
	public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltip, class_1836 type, class_9473 components) {
		tooltip.accept(class_2561.method_43469("tooltip.homelawnsecurity.currency." + name, amount));
	}

	public static class Builder {
		private int amount;
		private String name;

		public CurrencyComponent.Builder amount(int amount) {
			this.amount = amount;
			return this;
		}

		public CurrencyComponent.Builder name(String name) {
			this.name = name;
			return this;
		}

		public CurrencyComponent build() {
			return new CurrencyComponent(this.amount, this.name);
		}
	}
}
