package net.db64.homelawnsecurity.datagen;

import net.db64.homelawnsecurity.HomeLawnSecurity;
import net.db64.homelawnsecurity.block.ModBlocks;
import net.db64.homelawnsecurity.block.custom.lawn.ILawnBlock;
import net.db64.homelawnsecurity.item.ModItems;
import net.db64.homelawnsecurity.util.LawnUtil;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_10410;
import net.minecraft.class_10439;
import net.minecraft.class_10544;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.client.data.*;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ModModelProvider extends FabricModelProvider {
	public ModModelProvider(FabricDataOutput output) {
		super(output);
	}

	@Override
	public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
		ModBlockModels.registerCubeBottomTop(
			blockStateModelGenerator,
			ModBlocks.GARDEN_BLOCK,
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/garden_block_top"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/side_sodded"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/unsodded")
		);
		ModBlockModels.registerCubeBottomTop(
			blockStateModelGenerator,
			ModBlocks.GRAVEYARD_BLOCK,
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/graveyard_block_top"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/side_sodded"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/unsodded")
		);

		/*ModBlockModels.registerLawnBlock(blockStateModelGenerator, ModBlocks.LAWN_BLOCK);

		ModBlockModels.registerLawnBlock(blockStateModelGenerator, ModBlocks.FERTILE_PATH_BLOCK_1);
		ModBlockModels.registerLawnBlock(blockStateModelGenerator, ModBlocks.FERTILE_PATH_BLOCK_2);
		ModBlockModels.registerLawnBlock(blockStateModelGenerator, ModBlocks.FERTILE_PATH_BLOCK_CROSS);

		ModBlockModels.registerUnsoddedPathBlock(blockStateModelGenerator, ModBlocks.ZOMBIE_PATH_BLOCK_1);
		ModBlockModels.registerUnsoddedPathBlock(blockStateModelGenerator, ModBlocks.ZOMBIE_PATH_BLOCK_2);
		ModBlockModels.registerUnsoddedPathBlock(blockStateModelGenerator, ModBlocks.ZOMBIE_PATH_BLOCK_CROSS);

		blockStateModelGenerator.registerCubeAllModelTexturePool(ModBlocks.UNSODDED_LAWN_BLOCK);
		//blockStateModelGenerator.registerSimpleCubeAll(ModBlocks.UNSODDED_LAWN_BLOCK);*/

		ModBlockModels.registerLawnBlockV2(
			blockStateModelGenerator,
			ModBlocks.SODDED_LAWN_BLOCK,
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/top_sodded"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/top_sodded_path"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/side_sodded"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/unsodded")
		);
		ModBlockModels.registerLawnBlockV2(
			blockStateModelGenerator,
			ModBlocks.UNSODDED_LAWN_BLOCK,
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/unsodded"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/top_unsodded_path"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/unsodded"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/unsodded")
		);

		blockStateModelGenerator.method_25542(ModBlocks.GRAVEYARD_MARKER, ModBlocks.GRAVEYARD_MARKER.method_8389());
		blockStateModelGenerator.method_25542(ModBlocks.GARDEN_MARKER, ModBlocks.GARDEN_MARKER.method_8389());

		blockStateModelGenerator.method_25542(ModBlocks.SODDED_LAWN_MARKER, ModBlocks.SODDED_LAWN_MARKER.method_8389());
		blockStateModelGenerator.method_25542(ModBlocks.UNSODDED_LAWN_MARKER, ModBlocks.UNSODDED_LAWN_MARKER.method_8389());

		/*blockStateModelGenerator.registerBuiltinWithParticle(ModBlocks.LAWN_MARKER, ModBlocks.LAWN_MARKER.asItem());

		blockStateModelGenerator.registerBuiltinWithParticle(ModBlocks.FERTILE_PATH_MARKER_1, ModBlocks.FERTILE_PATH_MARKER_1.asItem());
		blockStateModelGenerator.registerBuiltinWithParticle(ModBlocks.FERTILE_PATH_MARKER_2, ModBlocks.FERTILE_PATH_MARKER_2.asItem());
		blockStateModelGenerator.registerBuiltinWithParticle(ModBlocks.FERTILE_PATH_MARKER_CROSS, ModBlocks.FERTILE_PATH_MARKER_CROSS.asItem());

		blockStateModelGenerator.registerBuiltinWithParticle(ModBlocks.ZOMBIE_PATH_MARKER_1, ModBlocks.ZOMBIE_PATH_MARKER_1.asItem());
		blockStateModelGenerator.registerBuiltinWithParticle(ModBlocks.ZOMBIE_PATH_MARKER_2, ModBlocks.ZOMBIE_PATH_MARKER_2.asItem());
		blockStateModelGenerator.registerBuiltinWithParticle(ModBlocks.ZOMBIE_PATH_MARKER_CROSS, ModBlocks.ZOMBIE_PATH_MARKER_CROSS.asItem());

		blockStateModelGenerator.registerBuiltinWithParticle(ModBlocks.UNSODDED_LAWN_MARKER, ModBlocks.UNSODDED_LAWN_MARKER.asItem());*/

		/*blockStateModelGenerator.registerLog(ModBlocks.RUBBER_LOG).log(ModBlocks.RUBBER_LOG).wood(ModBlocks.RUBBER_WOOD);
		blockStateModelGenerator.registerLog(ModBlocks.STRIPPED_RUBBER_LOG).log(ModBlocks.STRIPPED_RUBBER_LOG).wood(ModBlocks.STRIPPED_RUBBER_WOOD);
		blockStateModelGenerator.registerLog(ModBlocks.DRIPPING_RUBBER_LOG).log(ModBlocks.DRIPPING_RUBBER_LOG).wood(ModBlocks.DRIPPING_RUBBER_WOOD);

		BlockStateModelGenerator.BlockTexturePool rubberwoodPlanksPool = blockStateModelGenerator.registerCubeAllModelTexturePool(ModBlocks.RUBBERWOOD_PLANKS);
		rubberwoodPlanksPool.stairs(ModBlocks.RUBBERWOOD_STAIRS);
		rubberwoodPlanksPool.slab(ModBlocks.RUBBERWOOD_SLAB);
		rubberwoodPlanksPool.fence(ModBlocks.RUBBERWOOD_FENCE);
		rubberwoodPlanksPool.fenceGate(ModBlocks.RUBBERWOOD_FENCE_GATE);
		blockStateModelGenerator.registerDoor(ModBlocks.RUBBERWOOD_DOOR);
		blockStateModelGenerator.registerTrapdoor(ModBlocks.RUBBERWOOD_TRAPDOOR);
		rubberwoodPlanksPool.pressurePlate(ModBlocks.RUBBERWOOD_PRESSURE_PLATE);
		rubberwoodPlanksPool.button(ModBlocks.RUBBERWOOD_BUTTON);

		blockStateModelGenerator.registerCubeAllModelTexturePool(ModBlocks.RUBBER_LEAVES);
		blockStateModelGenerator.registerTintableCrossBlockState(ModBlocks.RUBBER_SAPLING, BlockStateModelGenerator.TintType.NOT_TINTED);
		blockStateModelGenerator.registerItemModel(ModBlocks.RUBBER_SAPLING); // So that the sapling is 2D in the inventory*/
	}

	private static class ModBlockModels {
		/*public static void registerLawnBlock(BlockStateModelGenerator blockStateModelGenerator, Block block) {
			TextureMap textureMap = new TextureMap()
				.put(TextureKey.BOTTOM, TextureMap.getId(ModBlocks.UNSODDED_LAWN_BLOCK))
				.put(TextureKey.TOP, TextureMap.getSubId(block, "_top"))
				.put(TextureKey.SIDE, TextureMap.getSubId(ModBlocks.LAWN_BLOCK, "_side"));
			blockStateModelGenerator.blockStateCollector.accept(BlockStateModelGenerator.createSingletonBlockState(block, BlockStateModelGenerator.createWeightedVariant(Models.CUBE_BOTTOM_TOP.upload(block, textureMap, blockStateModelGenerator.modelCollector))));
		}

		public static void registerUnsoddedPathBlock(BlockStateModelGenerator blockStateModelGenerator, Block block) {
			TextureMap textureMap = new TextureMap()
				.put(TextureKey.BOTTOM, TextureMap.getId(ModBlocks.UNSODDED_LAWN_BLOCK))
				.put(TextureKey.TOP, TextureMap.getSubId(block, "_top"))
				.put(TextureKey.SIDE, TextureMap.getId(ModBlocks.UNSODDED_LAWN_BLOCK));
			blockStateModelGenerator.blockStateCollector.accept(BlockStateModelGenerator.createSingletonBlockState(block, BlockStateModelGenerator.createWeightedVariant(Models.CUBE_BOTTOM_TOP.upload(block, textureMap, blockStateModelGenerator.modelCollector))));
		}*/

		public static void registerCubeBottomTop(class_4910 generator, class_2248 block, class_2960 topTexture, class_2960 sideTexture, class_2960 bottomTexture) {
			class_4944 textureMap = new class_4944()
				.method_25868(class_4945.field_23015, topTexture)
				.method_25868(class_4945.field_23018, sideTexture)
				.method_25868(class_4945.field_23014, bottomTexture);
			generator.field_22830.accept(class_4910.method_25644(block, class_4910.method_67835(class_4943.field_22977.method_25846(block, textureMap, generator.field_22831))));
		}



		public static final class_4945 textureKeyMainPath = class_4945.method_27043("main_path");
		public static final class_4945 textureKeyIntersectingPath = class_4945.method_27043("intersecting_path");
		public static final class_4942 LAWN_BLOCK_V2 = new class_4942(Optional.of(class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block_v2")), Optional.empty(), class_4945.field_23014, class_4945.field_23018, class_4945.field_23015, textureKeyMainPath, textureKeyIntersectingPath);

		public static void registerLawnBlockV2(class_4910 generator, class_2248 block, class_2960 topTexture, class_2960 topDarkTexture, class_2960 sideTexture, class_2960 bottomTexture) {
			class_2960 noPath = class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/no_path");
			class_2960[][] identifiers = new class_2960[LawnUtil.getPathTypeAmount() + 1][LawnUtil.getPathTypeAmount() + 1];



			class_4944 textureMap = new class_4944()
				.method_25868(class_4945.field_23014, bottomTexture)
				.method_25868(class_4945.field_23018, sideTexture);



			for (int mainPathId = 0; mainPathId <= LawnUtil.getPathTypeAmount(); mainPathId++) {
				class_2960 mainPathNormalTexture = class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/main_path/normal_" + mainPathId);
				class_2960 mainPathIntersectingTexture = class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/main_path/intersecting_" + mainPathId);



				for (int intersectingPathId = 0; intersectingPathId <= LawnUtil.getPathTypeAmount(); intersectingPathId++) {
					class_2960 intersectingPathTexture = class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/intersecting_path/" + intersectingPathId);

					if (mainPathId == 0) {
						textureMap.method_25868(class_4945.field_23015, topTexture)
							.method_25868(textureKeyMainPath, noPath);
					}
					else {
						textureMap.method_25868(class_4945.field_23015, topDarkTexture);
						if (intersectingPathId == 0) {
							textureMap.method_25868(textureKeyMainPath, mainPathNormalTexture);
						} else {
							textureMap.method_25868(textureKeyMainPath, mainPathIntersectingTexture);
						}
					}

					if (intersectingPathId == 0) {
						textureMap.method_25868(textureKeyIntersectingPath, noPath);
					}
					else {
						textureMap.method_25868(textureKeyIntersectingPath, intersectingPathTexture);
					}

					identifiers[mainPathId][intersectingPathId] = LAWN_BLOCK_V2.method_25847(block,
						"_" + mainPathId + "_" + intersectingPathId,
						textureMap,
						generator.field_22831);
				}
			}

			generator.field_22830
				.accept(
					class_4925.method_67852(block)
						.method_67859(class_4926.method_67865(ILawnBlock.PATH_ID_MAIN, ILawnBlock.PATH_ID_INTERSECTING)
							.method_25800((mainPath, intersectingPath)
								-> class_4910.method_67835(identifiers[mainPath][intersectingPath])
							)
						)
				);
			//generator.registerParentedItemModel(block, identifiers[1][0][0]);

			/*generator.blockStateCollector
				.accept(
					VariantsBlockModelDefinitionCreator.of(block)
						.with(
							BlockStateVariantMap.models(turfProperty, mainPathIdProperty, intersectingPathIdProperty)
								.register(false, 0, 0,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_0_0")))
								.register(false, 1, 0,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_1_0")))
								.register(false, 2, 0,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_2_0")))
								.register(false, 3, 0,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_3_0")))
								.register(false, 4, 0,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_4_0")))

								.register(false, 0, 1,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_0_1")))
								.register(false, 1, 1,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_1_1")))
								.register(false, 2, 1,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_2_1")))
								.register(false, 3, 1,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_3_1")))
								.register(false, 4, 1,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_4_1")))

								.register(false, 0, 2,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_0_2")))
								.register(false, 1, 2,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_1_2")))
								.register(false, 2, 2,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_2_2")))
								.register(false, 3, 2,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_3_2")))
								.register(false, 4, 2,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_4_2")))

								.register(false, 0, 3,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_0_3")))
								.register(false, 1, 3,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_1_3")))
								.register(false, 2, 3,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_2_3")))
								.register(false, 3, 3,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_3_3")))
								.register(false, 4, 3,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_4_3")))

								.register(false, 0, 4,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_0_4")))
								.register(false, 1, 4,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_1_4")))
								.register(false, 2, 4,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_2_4")))
								.register(false, 3, 4,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_3_4")))
								.register(false, 4, 4,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/false_4_4")))



								.register(true, 0, 0,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_0_0")))
								.register(true, 1, 0,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_1_0")))
								.register(true, 2, 0,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_2_0")))
								.register(true, 3, 0,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_3_0")))
								.register(true, 4, 0,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_4_0")))

								.register(true, 0, 1,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_0_1")))
								.register(true, 1, 1,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_1_1")))
								.register(true, 2, 1,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_2_1")))
								.register(true, 3, 1,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_3_1")))
								.register(true, 4, 1,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_4_1")))

								.register(true, 0, 2,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_0_2")))
								.register(true, 1, 2,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_1_2")))
								.register(true, 2, 2,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_2_2")))
								.register(true, 3, 2,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_3_2")))
								.register(true, 4, 2,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_4_2")))

								.register(true, 0, 3,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_0_3")))
								.register(true, 1, 3,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_1_3")))
								.register(true, 2, 3,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_2_3")))
								.register(true, 3, 3,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_3_3")))
								.register(true, 4, 3,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_4_3")))

								.register(true, 0, 4,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_0_4")))
								.register(true, 1, 4,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_1_4")))
								.register(true, 2, 4,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_2_4")))
								.register(true, 3, 4,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_3_4")))
								.register(true, 4, 4,
									BlockStateModelGenerator.createWeightedVariant(Identifier.of(HomeLawnSecurity.MOD_ID, "lawn_block/true_4_4")))
						)
				);*/
		}

		/*public static final TexturedModel.Factory LAWN_BLOCK = makeFactory(TextureMap::all, Models.CUBE_BOTTOM_TOP);
		public static final TexturedModel.Factory UNSODDED_PATH = makeFactory(TextureMap::all, Models.CUBE_BOTTOM_TOP);


		public static TextureMap lawnBlock(Block block) {
			return new TextureMap().put(TextureKey.SIDE, TextureMap.getSubId(ModBlocks.LAWN_BLOCK, "_side")).put(TextureKey.TOP, TextureMap.getSubId(block, "_top")).put(TextureKey.BOTTOM, TextureMap.getId(ModBlocks.UNSODDED_LAWN_BLOCK));
		}

		public static TextureMap unsoddedPath(Block block) {
			return new TextureMap().put(TextureKey.SIDE, TextureMap.getId(ModBlocks.UNSODDED_LAWN_BLOCK)).put(TextureKey.TOP, TextureMap.getSubId(block, "_top")).put(TextureKey.BOTTOM, TextureMap.getId(ModBlocks.UNSODDED_LAWN_BLOCK));
		}

		public static TexturedModel.Factory makeFactory(Function<Block, TextureMap> texturesGetter, Model model) {
			return (block) -> {
				return new TexturedModel((TextureMap)texturesGetter.apply(block), model);
			};
		}*/
	}

	@Override
	public void generateItemModels(class_4915 itemModelGenerator) {
		//itemModelGenerator.register(ModItems.PEASHOOTER_SPAWN_EGG,
			//new Model(Optional.of(Identifier.of("item/template_spawn_egg")), Optional.empty()));
		//itemModelGenerator.registerSpawnEgg(ModItems.PEASHOOTER_SPAWN_EGG, 0xD7FF37, 0x3BC10E);

		//itemModelGenerator.register(ModItems.BASIC_ZOMBIE_SPAWN_EGG,
			//new Model(Optional.of(Identifier.of("item/template_spawn_egg")), Optional.empty()));
		//itemModelGenerator.registerSpawnEgg(ModItems.BASIC_ZOMBIE_SPAWN_EGG, 0x6D7858, 0x4A341D);

		//ModItemModels.registerHeadgear(itemModelGenerator, ModItems.DAVES_PAN, , );

		itemModelGenerator.method_65442(ModItems.BAG_OF_SUN, class_4943.field_22938);
		itemModelGenerator.method_65442(ModItems.BAG_OF_BRAINPOWER, class_4943.field_22938);

		itemModelGenerator.method_65442(ModItems.SUN, class_4943.field_22938);
		itemModelGenerator.method_65442(ModItems.BRAINPOWER, class_4943.field_22938);

		itemModelGenerator.method_65442(ModItems.LAWN_MOWER, class_4943.field_22938);

		itemModelGenerator.method_65442(ModItems.TARGET, class_4943.field_22938);

		itemModelGenerator.method_65442(ModItems.SHOVEL, class_4943.field_22939);
		itemModelGenerator.method_65442(ModItems.LAWN_GADGET, class_4943.field_22939);

		itemModelGenerator.method_65442(ModItems.TURF, class_4943.field_22938);

		itemModelGenerator.method_65442(ModItems.BRAIN, class_4943.field_22938);

		itemModelGenerator.method_65442(ModBlocks.GARDEN_MARKER.method_8389(), class_4943.field_22938);
		itemModelGenerator.method_65442(ModBlocks.GRAVEYARD_MARKER.method_8389(), class_4943.field_22938);

		/*itemModelGenerator.register(ModBlocks.LAWN_MARKER.asItem(), Models.GENERATED);

		itemModelGenerator.register(ModBlocks.FERTILE_PATH_MARKER_1.asItem(), Models.GENERATED);
		itemModelGenerator.register(ModBlocks.FERTILE_PATH_MARKER_2.asItem(), Models.GENERATED);
		itemModelGenerator.register(ModBlocks.FERTILE_PATH_MARKER_CROSS.asItem(), Models.GENERATED);

		itemModelGenerator.register(ModBlocks.ZOMBIE_PATH_MARKER_1.asItem(), Models.GENERATED);
		itemModelGenerator.register(ModBlocks.ZOMBIE_PATH_MARKER_2.asItem(), Models.GENERATED);
		itemModelGenerator.register(ModBlocks.ZOMBIE_PATH_MARKER_CROSS.asItem(), Models.GENERATED);

		itemModelGenerator.register(ModBlocks.UNSODDED_LAWN_MARKER.asItem(), Models.GENERATED);*/

		ModItemModels.registerLawnMarkerV2(
			itemModelGenerator,
			ModBlocks.SODDED_LAWN_MARKER,
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/marker_sodded"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/marker_sodded_path"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "item/lawn_marker/sodded"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "item/lawn_marker/sodded_path")
		);
		ModItemModels.registerLawnMarkerV2(
			itemModelGenerator,
			ModBlocks.UNSODDED_LAWN_MARKER,
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/marker_unsodded"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/marker_unsodded_path"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "item/lawn_marker/unsodded"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "item/lawn_marker/unsodded_path")
		);

		ModItemModels.registerLawnBlockItemV2(
			itemModelGenerator,
			ModBlocks.SODDED_LAWN_BLOCK,
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/top_sodded"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/top_sodded_path"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/side_sodded"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/unsodded"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "item/lawn_block/sodded"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "item/lawn_block/sodded_path")
		);
		ModItemModels.registerLawnBlockItemV2(
			itemModelGenerator,
			ModBlocks.UNSODDED_LAWN_BLOCK,
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/unsodded"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/top_unsodded_path"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/unsodded"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/unsodded"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "item/lawn_block/unsodded"),
			class_2960.method_60655(HomeLawnSecurity.MOD_ID, "item/lawn_block/unsodded_path")
		);



		HashMap<String, class_2960> seedPacketBases = new HashMap<>();
		{
			seedPacketBases.put("plantBase", ModItemModels.registerSeedPacketBase(itemModelGenerator, "plant"));
			seedPacketBases.put("zombieBase", ModItemModels.registerSeedPacketBase(itemModelGenerator, "zombie"));
			seedPacketBases.put("imitaterBase", ModItemModels.registerSeedPacketBase(itemModelGenerator, "imitater"));
			seedPacketBases.put("upgradeBase", ModItemModels.registerSeedPacketBase(itemModelGenerator, "upgrade"));
		}

		HashMap<String, class_2960> seedPacketImages = new HashMap<>();
		{
			seedPacketImages.put("peashooter", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "peashooter"));
			seedPacketImages.put("sunflower", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "sunflower"));
			seedPacketImages.put("cherryBomb", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "cherry_bomb"));
			seedPacketImages.put("wallNut", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "wall_nut"));
			seedPacketImages.put("potatoMine", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "potato_mine"));
			seedPacketImages.put("snowPea", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "snow_pea"));
			seedPacketImages.put("chomper", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "chomper"));
			seedPacketImages.put("repeater", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "repeater"));
			seedPacketImages.put("puffShroom", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "puff_shroom"));
			seedPacketImages.put("sunShroom", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "sun_shroom"));
			seedPacketImages.put("fumeShroom", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "fume_shroom"));
			seedPacketImages.put("graveBuster", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "grave_buster"));
			seedPacketImages.put("hypnoShroom", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "hypno_shroom"));
			seedPacketImages.put("scaredyShroom", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "scaredy_shroom"));
			seedPacketImages.put("iceShroom", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "ice_shroom"));
			seedPacketImages.put("doomShroom", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "doom_shroom"));
			seedPacketImages.put("lilyPad", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "lily_pad"));
			seedPacketImages.put("squash", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "squash"));
			seedPacketImages.put("threepeater", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "threepeater"));
			seedPacketImages.put("tangleKelp", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "tangle_kelp"));
			seedPacketImages.put("jalapeno", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "jalapeno"));
			seedPacketImages.put("spikeweed", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "spikeweed"));
			seedPacketImages.put("torchwood", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "torchwood"));
			seedPacketImages.put("tallNut", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "tall_nut"));
			seedPacketImages.put("seaShroom", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "sea_shroom"));
			seedPacketImages.put("plantern", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "plantern"));
			seedPacketImages.put("cactus", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "cactus"));
			seedPacketImages.put("blover", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "blover"));
			seedPacketImages.put("splitPea", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "split_pea"));
			seedPacketImages.put("starfruit", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "starfruit"));
			seedPacketImages.put("pumpkin", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "pumpkin"));
			seedPacketImages.put("magnetShroom", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "magnet_shroom"));
			seedPacketImages.put("cabbagePult", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "cabbage_pult"));
			seedPacketImages.put("flowerPot", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "flower_pot"));
			seedPacketImages.put("kernelPult", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "kernel_pult"));
			seedPacketImages.put("coffeeBean", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "coffee_bean"));
			seedPacketImages.put("garlic", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "garlic"));
			seedPacketImages.put("umbrellaLeaf", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "umbrella_leaf"));
			seedPacketImages.put("marigold", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "marigold"));
			seedPacketImages.put("melonPult", ModItemModels.registerSeedPacketImage(itemModelGenerator, "plant", "melon_pult"));

			seedPacketImages.put("zombieGravestone", ModItemModels.registerSeedPacketImage(itemModelGenerator, "zombie", "zombie_gravestone"));
			seedPacketImages.put("basicZombie", ModItemModels.registerSeedPacketImage(itemModelGenerator, "zombie", "basic_zombie"));
			seedPacketImages.put("trashCanZombie", ModItemModels.registerSeedPacketImage(itemModelGenerator, "zombie", "trash_can_zombie"));
			seedPacketImages.put("coneheadZombie", ModItemModels.registerSeedPacketImage(itemModelGenerator, "zombie", "conehead_zombie"));
			seedPacketImages.put("poleVaultingZombie", ModItemModels.registerSeedPacketImage(itemModelGenerator, "zombie", "pole_vaulting_zombie"));
			seedPacketImages.put("bucketheadZombie", ModItemModels.registerSeedPacketImage(itemModelGenerator, "zombie", "buckethead_zombie"));
			seedPacketImages.put("flagZombie", ModItemModels.registerSeedPacketImage(itemModelGenerator, "zombie", "flag_zombie"));
			seedPacketImages.put("newspaperZombie", ModItemModels.registerSeedPacketImage(itemModelGenerator, "zombie", "newspaper_zombie"));
			seedPacketImages.put("screenDoorZombie", ModItemModels.registerSeedPacketImage(itemModelGenerator, "zombie", "screen_door_zombie"));
			seedPacketImages.put("footballZombie", ModItemModels.registerSeedPacketImage(itemModelGenerator, "zombie", "football_zombie"));
			seedPacketImages.put("dancingZombie", ModItemModels.registerSeedPacketImage(itemModelGenerator, "zombie", "dancing_zombie"));
			seedPacketImages.put("zomboni", ModItemModels.registerSeedPacketImage(itemModelGenerator, "zombie", "zomboni"));
			seedPacketImages.put("jackInTheBoxZombie", ModItemModels.registerSeedPacketImage(itemModelGenerator, "zombie", "jack_in_the_box_zombie"));
			seedPacketImages.put("diggerZombie", ModItemModels.registerSeedPacketImage(itemModelGenerator, "zombie", "digger_zombie"));
			seedPacketImages.put("pogoZombie", ModItemModels.registerSeedPacketImage(itemModelGenerator, "zombie", "pogo_zombie"));
			seedPacketImages.put("bungeeZombie", ModItemModels.registerSeedPacketImage(itemModelGenerator, "zombie", "bungee_zombie"));
			seedPacketImages.put("ladderZombie", ModItemModels.registerSeedPacketImage(itemModelGenerator, "zombie", "ladder_zombie"));
			seedPacketImages.put("catapultZombie", ModItemModels.registerSeedPacketImage(itemModelGenerator, "zombie", "catapult_zombie"));
			seedPacketImages.put("gargantuar", ModItemModels.registerSeedPacketImage(itemModelGenerator, "zombie", "gargantuar"));
		}

		HashMap<String, class_2960> seedPacketCosts = new HashMap<>();
		{
			seedPacketCosts.put("plant0", ModItemModels.registerSeedPacketCost(itemModelGenerator, "plant", "0"));
			seedPacketCosts.put("plant25", ModItemModels.registerSeedPacketCost(itemModelGenerator, "plant", "25"));
			seedPacketCosts.put("plant50", ModItemModels.registerSeedPacketCost(itemModelGenerator, "plant", "50"));
			seedPacketCosts.put("plant75", ModItemModels.registerSeedPacketCost(itemModelGenerator, "plant", "75"));
			seedPacketCosts.put("plant100", ModItemModels.registerSeedPacketCost(itemModelGenerator, "plant", "100"));
			seedPacketCosts.put("plant125", ModItemModels.registerSeedPacketCost(itemModelGenerator, "plant", "125"));
			seedPacketCosts.put("plant150", ModItemModels.registerSeedPacketCost(itemModelGenerator, "plant", "150"));
			seedPacketCosts.put("plant175", ModItemModels.registerSeedPacketCost(itemModelGenerator, "plant", "175"));
			seedPacketCosts.put("plant300", ModItemModels.registerSeedPacketCost(itemModelGenerator, "plant", "300"));

			seedPacketCosts.put("zombie25", ModItemModels.registerSeedPacketCost(itemModelGenerator, "zombie", "25"));
			seedPacketCosts.put("zombie50", ModItemModels.registerSeedPacketCost(itemModelGenerator, "zombie", "50"));
			seedPacketCosts.put("zombie75", ModItemModels.registerSeedPacketCost(itemModelGenerator, "zombie", "75"));
			seedPacketCosts.put("zombie100", ModItemModels.registerSeedPacketCost(itemModelGenerator, "zombie", "100"));
			seedPacketCosts.put("zombie125", ModItemModels.registerSeedPacketCost(itemModelGenerator, "zombie", "125"));
			seedPacketCosts.put("zombie150", ModItemModels.registerSeedPacketCost(itemModelGenerator, "zombie", "150"));
			seedPacketCosts.put("zombie175", ModItemModels.registerSeedPacketCost(itemModelGenerator, "zombie", "175"));
			seedPacketCosts.put("zombie200", ModItemModels.registerSeedPacketCost(itemModelGenerator, "zombie", "200"));
			seedPacketCosts.put("zombie225", ModItemModels.registerSeedPacketCost(itemModelGenerator, "zombie", "225"));
			seedPacketCosts.put("zombie250", ModItemModels.registerSeedPacketCost(itemModelGenerator, "zombie", "250"));
			seedPacketCosts.put("zombie300", ModItemModels.registerSeedPacketCost(itemModelGenerator, "zombie", "300"));
		}

		// Plant seed packets
		{
			ModItemModels.registerSeedPacket(itemModelGenerator, ModItems.SEED_PACKET_PEASHOOTER,
				seedPacketBases.get("plantBase"),
				seedPacketImages.get("peashooter"),
				seedPacketCosts.get("plant100")
			);

			ModItemModels.registerSeedPacket(itemModelGenerator, ModItems.SEED_PACKET_SUNFLOWER,
				seedPacketBases.get("plantBase"),
				seedPacketImages.get("sunflower"),
				seedPacketCosts.get("plant50")
			);

			ModItemModels.registerSeedPacket(itemModelGenerator, ModItems.SEED_PACKET_WALL_NUT,
				seedPacketBases.get("plantBase"),
				seedPacketImages.get("wallNut"),
				seedPacketCosts.get("plant50")
			);
		}

		// Zombie seed packets
		{
			ModItemModels.registerSeedPacket(itemModelGenerator, ModItems.SEED_PACKET_ZOMBIE_GRAVESTONE,
				seedPacketBases.get("zombieBase"),
				seedPacketImages.get("zombieGravestone"),
				seedPacketCosts.get("zombie50")
			);

			ModItemModels.registerSeedPacket(itemModelGenerator, ModItems.SEED_PACKET_BASIC_ZOMBIE,
				seedPacketBases.get("zombieBase"),
				seedPacketImages.get("basicZombie"),
				seedPacketCosts.get("zombie25")
			);

			ModItemModels.registerSeedPacket(itemModelGenerator, ModItems.SEED_PACKET_CONEHEAD_ZOMBIE,
				seedPacketBases.get("zombieBase"),
				seedPacketImages.get("coneheadZombie"),
				seedPacketCosts.get("zombie75")
			);
		}
	}

	private static class ModItemModels {
		public static final class_4942 TEMPLATE_SEED_PACKET_BASE = item("template_seed_packet_base", class_4945.field_23006);
		public static final class_4942 TEMPLATE_SEED_PACKET_IMAGE = item("template_seed_packet_image", class_4945.field_23006);
		public static final class_4942 TEMPLATE_SEED_PACKET_COST = item("template_seed_packet_cost", class_4945.field_23006);

		private static class_4942 item(String parent, class_4945... requiredTextureKeys) {
			return new class_4942(Optional.of(class_2960.method_60655(HomeLawnSecurity.MOD_ID, "item/" + parent)), Optional.empty(), requiredTextureKeys);
		}

		/*public static void registerHeadgear(ItemModelGenerator itemModelGenerator, Item item, Model model, ItemModel.Unbaked onHeadModel) {
			ItemModel.Unbaked unbaked = net.minecraft.client.data.ItemModels.select(
				new DisplayContextProperty(),
				net.minecraft.client.data.ItemModels.basic(itemModelGenerator.upload(item, model)),
				net.minecraft.client.data.ItemModels.switchCase(List.of(ModelTransformationMode.HEAD), onHeadModel)
			);
			itemModelGenerator.output.accept(item, unbaked);
		}*/

		public static void registerSeedPacket(class_4915 itemModelGenerator, class_1792 item, class_2960 baseModel, class_2960 imageModel, class_2960 costModel) {
			class_10439.class_10441 unbaked = net.minecraft.class_10410.method_65500(
				net.minecraft.class_10410.method_65481(baseModel),
				net.minecraft.class_10410.method_65481(imageModel),
				net.minecraft.class_10410.method_65481(costModel)
			);

			itemModelGenerator.field_55245.method_65460(item, unbaked);
		}

		public static class_2960 registerSeedPacketBase(class_4915 itemModelGenerator, String base) {
			class_2960 id = class_2960.method_60655(HomeLawnSecurity.MOD_ID, "item/seed_packet/base/" + base);
			return class_4943.field_22938.method_25852(id, class_4944.method_25895(id), itemModelGenerator.field_55246);
		}

		public static class_2960 registerSeedPacketImage(class_4915 itemModelGenerator, String team, String image) {
			class_2960 id = class_2960.method_60655(HomeLawnSecurity.MOD_ID, "item/seed_packet/image/" + team + "/" + image);
			return class_4943.field_22938.method_25852(id, class_4944.method_25895(id), itemModelGenerator.field_55246);
		}

		public static class_2960 registerSeedPacketCost(class_4915 itemModelGenerator, String team, String cost) {
			class_2960 id = class_2960.method_60655(HomeLawnSecurity.MOD_ID, "item/seed_packet/cost/" + team + "/" + cost);
			return class_4943.field_22938.method_25852(id, class_4944.method_25895(id), itemModelGenerator.field_55246);
		}

		private static boolean generatedMarkerPathModels = false;

		public static void registerLawnMarkerV2(class_4915 generator, class_2248 block, class_2960 lawnTexture, class_2960 lawnDarkTexture, class_2960 lawnModel, class_2960 lawnDarkModel) {
			class_4943.field_22938.method_25852(lawnModel, class_4944.method_25895(lawnTexture), generator.field_55246);
			class_4943.field_22938.method_25852(lawnDarkModel, class_4944.method_25895(lawnDarkTexture), generator.field_55246);

			class_10439.class_10441 empty = new class_10544.class_10545();

			HashMap<Integer, class_10439.class_10441> mainPathNormalModels = new HashMap<>();
			HashMap<Integer, class_10439.class_10441> mainPathIntersectingModels = new HashMap<>();
			HashMap<Integer, class_10439.class_10441> tempMap = new HashMap<>();
			for (int mainPathId = 1; mainPathId <= LawnUtil.getPathTypeAmount(); mainPathId++) {
				class_2960 mainPathNormalModel = class_2960.method_60655(HomeLawnSecurity.MOD_ID, "item/marker_path/main_path/normal_" + mainPathId);
				mainPathNormalModels.put(mainPathId, class_10410.method_65481(mainPathNormalModel));
				if (!generatedMarkerPathModels)
					class_4943.field_22938.method_25852(mainPathNormalModel, class_4944.method_25895(class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/main_path/normal_" + mainPathId)), generator.field_55246);

				class_2960 mainPathIntersectingModel = class_2960.method_60655(HomeLawnSecurity.MOD_ID, "item/marker_path/main_path/intersecting_" + mainPathId);
				mainPathIntersectingModels.put(mainPathId, class_10410.method_65481(mainPathIntersectingModel));
				if (!generatedMarkerPathModels)
					class_4943.field_22938.method_25852(mainPathIntersectingModel, class_4944.method_25895(class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/main_path/intersecting_" + mainPathId)), generator.field_55246);

				tempMap.put(mainPathId, class_10410.method_65481(lawnDarkModel));
			}

			HashMap<Integer, class_10439.class_10441> intersectingPathModels = new HashMap<>();
			for (int intersectingPathId = 1; intersectingPathId <= LawnUtil.getPathTypeAmount(); intersectingPathId++) {
				class_2960 intersectingPathModel = class_2960.method_60655(HomeLawnSecurity.MOD_ID, "item/marker_path/intersecting_path/" + intersectingPathId);
				intersectingPathModels.put(intersectingPathId, class_10410.method_65481(intersectingPathModel));
				if (!generatedMarkerPathModels)
					class_4943.field_22938.method_25852(intersectingPathModel, class_4944.method_25895(class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/intersecting_path/" + intersectingPathId)), generator.field_55246);
			}

			generatedMarkerPathModels = true;

			generator.field_55245.method_65460(block.method_8389(),
				class_10410.method_65500(
					// Base
					class_10410.method_65484(
						ILawnBlock.PATH_ID_MAIN,
						class_10410.method_65481(lawnModel),
						tempMap
					),
					// Main path
					class_10410.method_65484(
						ILawnBlock.PATH_ID_INTERSECTING,
						class_10410.method_65484(
							ILawnBlock.PATH_ID_MAIN,
							empty,
							mainPathIntersectingModels
						),
						Map.of(0, class_10410.method_65484(
							ILawnBlock.PATH_ID_MAIN,
							empty,
							mainPathNormalModels
						))
					),
					// Intersecting path
					class_10410.method_65484(
						ILawnBlock.PATH_ID_INTERSECTING,
						empty,
						intersectingPathModels
					)
				)
			);
		}

		private static boolean generatedBlockPathModels = false;

		public static void registerLawnBlockItemV2(class_4915 generator, class_2248 block, class_2960 topTexture, class_2960 topDarkTexture, class_2960 sideTexture, class_2960 bottomTexture, class_2960 lawnModel, class_2960 lawnDarkModel) {
			class_4943.field_22977.method_25852(lawnModel,
				new class_4944()
					.method_25868(class_4945.field_23015, topTexture)
					.method_25868(class_4945.field_23018, sideTexture)
					.method_25868(class_4945.field_23014, bottomTexture),
				generator.field_55246);

			class_4943.field_22977.method_25852(lawnDarkModel,
				new class_4944()
					.method_25868(class_4945.field_23015, topDarkTexture)
					.method_25868(class_4945.field_23018, sideTexture)
					.method_25868(class_4945.field_23014, bottomTexture),
				generator.field_55246);

			class_10439.class_10441 empty = new class_10544.class_10545();

			HashMap<Integer, class_10439.class_10441> mainPathNormalModels = new HashMap<>();
			HashMap<Integer, class_10439.class_10441> mainPathIntersectingModels = new HashMap<>();
			HashMap<Integer, class_10439.class_10441> tempMap = new HashMap<>();
			for (int mainPathId = 1; mainPathId <= LawnUtil.getPathTypeAmount(); mainPathId++) {
				class_2960 mainPathNormalModel = class_2960.method_60655(HomeLawnSecurity.MOD_ID, "item/lawn_block/main_path/normal_" + mainPathId);
				mainPathNormalModels.put(mainPathId, class_10410.method_65481(mainPathNormalModel));
				if (!generatedBlockPathModels)
					class_4943.field_22976.method_25852(mainPathNormalModel,
						new class_4944()
							.method_25868(class_4945.field_23015, class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/main_path/normal_" + mainPathId))
							.method_25868(class_4945.field_23018, class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/no_path")),
						generator.field_55246);

				class_2960 mainPathIntersectingModel = class_2960.method_60655(HomeLawnSecurity.MOD_ID, "item/lawn_block/main_path/intersecting_" + mainPathId);
				mainPathIntersectingModels.put(mainPathId, class_10410.method_65481(mainPathIntersectingModel));
				if (!generatedBlockPathModels)
					class_4943.field_22976.method_25852(mainPathIntersectingModel,
						new class_4944()
							.method_25868(class_4945.field_23015, class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/main_path/intersecting_" + mainPathId))
							.method_25868(class_4945.field_23018, class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/no_path")),
						generator.field_55246);

				tempMap.put(mainPathId, class_10410.method_65481(lawnDarkModel));
			}

			HashMap<Integer, class_10439.class_10441> intersectingPathModels = new HashMap<>();
			for (int intersectingPathId = 1; intersectingPathId <= LawnUtil.getPathTypeAmount(); intersectingPathId++) {
				class_2960 intersectingPathModel = class_2960.method_60655(HomeLawnSecurity.MOD_ID, "item/lawn_block/intersecting_path/" + intersectingPathId);
				intersectingPathModels.put(intersectingPathId, class_10410.method_65481(intersectingPathModel));
				if (!generatedBlockPathModels)
					class_4943.field_22976.method_25852(intersectingPathModel,
						new class_4944()
							.method_25868(class_4945.field_23015, class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/intersecting_path/" + intersectingPathId))
							.method_25868(class_4945.field_23018, class_2960.method_60655(HomeLawnSecurity.MOD_ID, "block/lawn_block/no_path")),
						generator.field_55246);
			}

			generatedBlockPathModels = true;

			generator.field_55245.method_65460(block.method_8389(),
				class_10410.method_65500(
					// Base
					class_10410.method_65484(
						ILawnBlock.PATH_ID_MAIN,
						class_10410.method_65481(lawnModel),
						tempMap
					),
					// Main path
					class_10410.method_65484(
						ILawnBlock.PATH_ID_INTERSECTING,
						class_10410.method_65484(
							ILawnBlock.PATH_ID_MAIN,
							empty,
							mainPathIntersectingModels
						),
						Map.of(0, class_10410.method_65484(
							ILawnBlock.PATH_ID_MAIN,
							empty,
							mainPathNormalModels
						))
					),
					// Intersecting path
					class_10410.method_65484(
						ILawnBlock.PATH_ID_INTERSECTING,
						empty,
						intersectingPathModels
					)
				)
			);
		}
	}
}
