package net.db64.homelawnsecurity.entity.ai;

import net.db64.homelawnsecurity.HomeLawnSecurity;
import net.db64.homelawnsecurity.entity.custom.IPathBoundEntity;
import net.minecraft.class_11;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

import java.util.EnumSet;

public class MoveToGoalGoal extends class_1352 {
	protected final class_1314 mob;
	protected double targetX;
	protected double targetY;
	protected double targetZ;
	protected boolean targetChosenBefore = false;
	protected final double speed;
	protected final class_1937 world;

	public MoveToGoalGoal(class_1314 mob, double speed) {
		if (!(mob instanceof IPathBoundEntity))
			HomeLawnSecurity.LOGGER.error("Entities using MoveToGoalGoal must implement IPathBoundEntity!");

		this.mob = mob;
		this.speed = speed;
		this.world = mob.method_37908();
		this.method_6265(EnumSet.of(class_4134.field_18405));
	}

	@Override
	public void method_6268() {
		super.method_6268();
		if (!mob.method_6150()) {
			this.mob.method_5942().method_6337(this.targetX, this.targetY, this.targetZ, this.speed);
		}
	}

	@Override
	public boolean method_6264() {
		return !((IPathBoundEntity) mob).isGoal(this.mob.method_23312()) && this.checkForExistingGoal();
	}

	private boolean checkForExistingGoal() {
		class_2338 targetPos = new class_2338(class_3532.method_15357(this.targetX), class_3532.method_15357(this.targetY), class_3532.method_15357(this.targetZ));
		//HomeLawnSecurity.LOGGER.info("zombie's current goal pos: " + targetX + ", " + targetY + ", " + targetZ + " | " + targetPos.toShortString() + " zombie's current pos: " + mob.getPos().toString() + " | " + mob.getBlockPos().toShortString());
		if (targetChosenBefore && ((IPathBoundEntity) mob).isGoal(targetPos.method_10074())) {
			//HomeLawnSecurity.LOGGER.info("zombie is checking for if the block at {}, {}, {} is a goal", targetX, targetY, targetZ);
			return true; // Target still exists
		}
		return targetGoalPos(); // Choose a new target
	}

	protected boolean targetGoalPos() {
		//HomeLawnSecurity.LOGGER.info("zombie is picking new goal pos, old: " + targetX + ", " + targetY + ", " + targetZ);
		class_243 vec3d = this.locateGoalPos();
		if (vec3d == null) {
			//HomeLawnSecurity.LOGGER.info("zombie couldn't pick new goal pos");
			return false;
		}
		this.targetX = vec3d.field_1352;
		this.targetY = vec3d.field_1351;
		this.targetZ = vec3d.field_1350;
		targetChosenBefore = true;
		//HomeLawnSecurity.LOGGER.info("zombie has picked new goal pos, new: " + targetX + ", " + targetY + ", " + targetZ);
		return true;
	}

	@Override
	public boolean method_6266() {
		return !((IPathBoundEntity) mob).isGoal(this.mob.method_23312()) && checkForExistingGoal();
	}

	@Override
	public void method_6269() {
		//HomeLawnSecurity.LOGGER.info("zombie started moving towards goal of " + targetX + ", " + targetY + ", " + targetZ + " while at " + mob.getPos().toString());
		this.mob.method_5942().method_6337(this.targetX, this.targetY, this.targetZ, this.speed);
	}

	/*@Override
	public void stop() {
		HomeLawnSecurity.LOGGER.info("zombie stopped moving towards goal of " + targetX + ", " + targetY + ", " + targetZ + " while at " + mob.getPos().toString());
	}*/

	@Nullable
	protected class_243 locateGoalPos() {
		int rangeH = 16;
		int rangeV = 5;
		Iterable<class_2338> iterable = class_2338.method_25996(mob.method_23312().method_10084(), rangeH, rangeV, rangeH);
		for (class_2338 blockPos : iterable) {
			//HomeLawnSecurity.LOGGER.info("zombie is checking for if the block at {}, {}, {} is a goal", blockPos.getX(), blockPos.getY(), blockPos.getZ());
			if (!((IPathBoundEntity) mob).isGoal(blockPos.method_10074())) continue;
			//HomeLawnSecurity.LOGGER.info("zombie is checking for if the goal at {}, {}, {} is reachable", blockPos.getX(), blockPos.getY(), blockPos.getZ());
			class_11 path = this.mob.method_5942().method_6352(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), 1);
			if (path == null || !path.method_21655()) continue;

			this.mob.method_5942().method_6337(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), this.speed);
			return class_243.method_24955(blockPos);
		}
		return null;
	}
}
