package net.db64.homelawnsecurity.entity.ai;

import net.db64.homelawnsecurity.HomeLawnSecurity;
import net.db64.homelawnsecurity.entity.custom.IPathBoundEntity;
import net.db64.homelawnsecurity.util.ModTags;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_14;
import net.minecraft.class_1941;
import net.minecraft.class_2338;
import net.minecraft.class_3481;
import net.minecraft.class_7;
import net.minecraft.class_9316;

public class PvzPathNodeMaker extends class_14 {
	@Override
	public class_7 method_25(class_9316 context, int x, int y, int z, class_1308 mob) {
		class_1314 entity = (class_1314) mob;
		IPathBoundEntity pathBoundEntity = (IPathBoundEntity) mob;
		class_2338 pos = new class_2338(x, y, z);
		class_1941 world = context.method_57621();

		while (pos.method_10264() > world.method_31607() && (world.method_8320(pos).method_26164(class_3481.field_44471) || world.method_8320(pos).method_26164(ModTags.Blocks.MARKERS))) {
			pos = pos.method_10074();
		}

		if (pathBoundEntity.isWalkable(entity.method_24515().method_10074()) // Standing on path (so that it can get back on track)
			&& !pathBoundEntity.isWalkable(pos)) // Block is not path

			return class_7.field_22;

		return super.method_25(context, x, y, z, mob);
	}

	@Override
	public class_7 method_17(class_9316 context, int x, int y, int z) {
		return PvzPathNodeMaker.getPvzNodeType(context, new class_2338.class_2339(x, y, z), (class_1314) this.field_33);
	}

	public static class_7 getPvzNodeType(class_9316 context, class_2338.class_2339 pos, class_1314 entity) {
		if (!(entity instanceof IPathBoundEntity pathBoundEntity)) {
			HomeLawnSecurity.LOGGER.error("Entities using PvzNavigation must implement IPathBoundEntity!");
			return class_7.field_22;
		}

		int i = pos.method_10263();
		int j = pos.method_10264();
		int k = pos.method_10260();

		class_2338 pos2 = new class_2338(i, j, k);

		class_1941 world = context.method_57621();

		while (pos2.method_10264() > world.method_31607() && (world.method_8320(pos2).method_26164(class_3481.field_44471) || world.method_8320(pos2).method_26164(ModTags.Blocks.MARKERS))) {
			pos2 = pos2.method_10074();
		}

		class_7 pathNodeType;

		if (pathBoundEntity.isWalkable(entity.method_23312()) // Standing on path (so that it can get back on track)
			&& !pathBoundEntity.isWalkable(pos2)) { // Block is not path
			pathNodeType = class_7.field_22;
		}
		else {
			pathNodeType = class_14.method_58(world, pos);
		}

		if (pathNodeType != class_7.field_7 || j < world.method_31607() + 1) {
			return pathNodeType;
		}
		return switch (class_14.method_58(world, pos.method_10103(i, j - 1, k))) {
			case field_7, field_18, field_14, field_12 -> class_7.field_7;
			case field_3 -> class_7.field_3;
			case field_17 -> class_7.field_17;
			case field_21326 -> class_7.field_21326;
			case field_33534 -> class_7.field_36432;
			case field_43351 -> class_7.field_43351;
			case field_19 -> class_7.field_47413;
			default -> class_14.method_59(context, i, j, k, class_7.field_12);
		};
	}
}
