package net.db64.homelawnsecurity.entity.ai;

import net.db64.homelawnsecurity.HomeLawnSecurity;
import net.db64.homelawnsecurity.entity.custom.IPathBoundEntity;
import net.db64.homelawnsecurity.util.LawnUtil;
import net.minecraft.class_11;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

import java.util.EnumSet;

public class StayOnPathGoal extends class_1352 {
	protected final class_1314 mob;
	protected boolean targetChosenBefore = false;
	protected double targetX;
	protected double targetY;
	protected double targetZ;
	protected final double speed;
	protected final class_1937 world;

	public StayOnPathGoal(class_1314 mob, double speed) {
		if (!(mob instanceof IPathBoundEntity))
			HomeLawnSecurity.LOGGER.error("Entities using StayOnPathGoal must implement IPathBoundEntity!");

		this.mob = mob;
		this.speed = speed;
		this.world = mob.method_37908();
		this.method_6265(EnumSet.of(class_4134.field_18405));
	}

	@Override
	public boolean method_6264() {
		//HomeLawnSecurity.LOGGER.info("zombie will see if it can start the goal");
		return !(((IPathBoundEntity) mob).isWalkable(this.mob.method_23312())
			|| ((IPathBoundEntity) mob).isStart(this.mob.method_23312())) // If the entity is on a starting block, this goal shouldn't be activated even though this block isn't pathable! This goal randomly chooses a block to path to, remember?
			&& this.checkForExistingPath();
	}

	private boolean checkForExistingPath() {
		class_2338 targetPos = new class_2338(class_3532.method_15357(this.targetX), class_3532.method_15357(this.targetY), class_3532.method_15357(this.targetZ));
		//HomeLawnSecurity.LOGGER.info("zombie's current path pos: " + targetX + ", " + targetY + ", " + targetZ + " | " + targetPos.toShortString() + " zombie's current pos: " + mob.getPos().toString() + " | " + mob.getBlockPos().toShortString());
		if (targetChosenBefore && ((IPathBoundEntity) mob).isWalkable(targetPos.method_10074())) {
			return true; // Target still exists
		}
		return targetPathPos(); // Choose a new target
	}

	protected boolean targetPathPos() {
		//HomeLawnSecurity.LOGGER.info("zombie is picking new path pos, old: " + targetX + ", " + targetY + ", " + targetZ);
		class_243 vec3d = this.locatePathPos();
		if (vec3d == null) {
			//HomeLawnSecurity.LOGGER.info("zombie couldn't pick new path pos, switching path tag");
			((IPathBoundEntity) mob).setPathId(mob.method_59922().method_43048(LawnUtil.getPathTypeAmount()) + 1);
			return false;
		}
		this.targetX = vec3d.field_1352;
		this.targetY = vec3d.field_1351;
		this.targetZ = vec3d.field_1350;
		targetChosenBefore = true;
		//HomeLawnSecurity.LOGGER.info("zombie has picked new path pos, new: " + targetX + ", " + targetY + ", " + targetZ);
		return true;
	}

	@Override
	public boolean method_6266() {
		return !(((IPathBoundEntity) mob).isWalkable(this.mob.method_23312())
			//|| ((IPathBoundEntity) mob).isStart(this.mob.getSteppingPos()) // If the entity is on a starting block, this goal shouldn't be activated even though this block isn't pathable! This goal randomly chooses a block to path to, remember?
			|| mob.method_37908().method_8320(mob.method_23312()).method_26215()) // Prevent stopping while over air
			&& checkForExistingPath();
	}

	@Override
	public void method_6269() {
		//HomeLawnSecurity.LOGGER.info("zombie started moving towards path of " + targetX + ", " + targetY + ", " + targetZ + " while at " + mob.getPos().toString());
		//this.mob.setOffTrackNbt(true);
		this.mob.method_5942().method_6337(this.targetX, this.targetY, this.targetZ, this.speed);
	}

	/*@Override
	public void stop() {
		HomeLawnSecurity.LOGGER.info("zombie stopped moving towards path of " + targetX + ", " + targetY + ", " + targetZ + " while at " + mob.getPos().toString());
	}*/

	@Nullable
	protected class_243 locatePathPos(/*int avoidPathId*/) {
		int rangeH = 2;
		int rangeV = 2;
		Iterable<class_2338> iterable = class_2338.method_27156(mob.method_59922(), ((rangeH * 2 + 1) * 2) * (rangeV * 2 + 1), class_3532.method_15357(this.mob.method_23317() - rangeH), class_3532.method_15357(this.mob.method_23318() - rangeV), class_3532.method_15357(this.mob.method_23321() - rangeH), class_3532.method_15357(this.mob.method_23317() + rangeH), class_3532.method_15357(this.mob.method_23318() + rangeV), class_3532.method_15357(this.mob.method_23321() + rangeH));
		for (class_2338 blockPos : iterable) {
			if (!((IPathBoundEntity) mob).isWalkable(blockPos.method_10074())) continue;
			class_11 path = this.mob.method_5942().method_6352(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), 1);
			if (path == null || !path.method_21655()) continue;
			//if (avoidPathId != -1 && LawnUtil.isCertainPath(blockPos, mob.getWorld(), avoidPathId)) continue;

			this.mob.method_5942().method_6337(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), this.speed);
			return class_243.method_24955(blockPos);
		}
		return null;
	}
}
