package net.db64.homelawnsecurity.entity.ai.plant;

import org.jetbrains.annotations.Nullable;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1603;
import net.minecraft.class_3532;

public class PeashooterAttackGoal extends class_1352 {
	private final class_1308 mob;
	private final class_1603 owner;
	@Nullable
	private class_1309 target;
	private int updateCountdownTicks = -1;
	private final double mobSpeed;
	private int seenTargetTicks;
	private final int minIntervalTicks;
	private final int maxIntervalTicks;
	private final float maxShootRange;
	private final float squaredMaxShootRange;

	public Predicate<class_1309> rangePredicate;

	public PeashooterAttackGoal(class_1603 mob, double mobSpeed, int intervalTicks, float maxShootRange) {
		this(mob, mobSpeed, intervalTicks, intervalTicks, maxShootRange);
	}

	public PeashooterAttackGoal(class_1603 mob, double mobSpeed, int minIntervalTicks, int maxIntervalTicks, float maxShootRange) {
		if (!(mob instanceof class_1309)) {
			throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
		}
		this.owner = mob;
		this.mob = (class_1308) mob;
		this.mobSpeed = mobSpeed;
		this.minIntervalTicks = minIntervalTicks;
		this.maxIntervalTicks = maxIntervalTicks;
		this.maxShootRange = maxShootRange;
		this.squaredMaxShootRange = maxShootRange * maxShootRange;
		this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));

		rangePredicate = entity -> {
			// Cubic attack range for a tile-based game
			return (Math.abs(this.mob.method_23317() - entity.method_23317()) < maxShootRange)
				&& (Math.abs(this.mob.method_23318() - entity.method_23318()) < maxShootRange)
				&& (Math.abs(this.mob.method_23321() - entity.method_23321()) < maxShootRange);
		};
	}

	@Override
	public boolean method_6264() {
		class_1309 livingEntity = this.mob.method_5968();
		if (livingEntity == null || !livingEntity.method_5805()) {
			return false;
		}
		this.target = livingEntity;
		return true;
	}

	@Override
	public boolean method_6266() {
		return this.method_6264() || this.target.method_5805() && !this.mob.method_5942().method_6357() && rangePredicate.test(target);
	}

	@Override
	public void method_6270() {
		this.target = null;
		this.seenTargetTicks = 0;
		this.updateCountdownTicks = -1;
	}

	@Override
	public boolean method_38846() {
		return true;
	}

	@Override
	public void method_6268() {
		double d = this.mob.method_5649(this.target.method_23317(), this.target.method_23318(), this.target.method_23321());
		boolean bl = this.mob.method_5985().method_6369(this.target);
		this.seenTargetTicks = bl ? ++this.seenTargetTicks : 0;
		if (d > (double)this.squaredMaxShootRange || this.seenTargetTicks < 5) {
			this.mob.method_5942().method_6335(this.target, this.mobSpeed);
		} else {
			this.mob.method_5942().method_6340();
		}
		this.mob.method_5988().method_6230(this.target.method_23317(), this.mob.method_23320(), this.target.method_23321(),
			30.0f, 30.0f); // Oh boy I sure love plagiarizing an entire Java class to change one instruction // Never mind
		if (--this.updateCountdownTicks == 0) {
			if (!bl) {
				return;
			}
			float f = (float)Math.sqrt(d) / this.maxShootRange;
			float g = class_3532.method_15363(f, 0.1f, 1.0f);
			this.owner.method_7105(this.target, g);
			this.updateCountdownTicks = class_3532.method_15375(f * (float)(this.maxIntervalTicks - this.minIntervalTicks) + (float)this.minIntervalTicks);
		} else if (this.updateCountdownTicks < 0) {
			this.updateCountdownTicks = class_3532.method_15357(class_3532.method_16436(Math.sqrt(d) / (double)this.maxShootRange, (double)this.minIntervalTicks, (double)this.maxIntervalTicks));
		}
	}
}
