package net.db64.homelawnsecurity.entity.ai.zombie;

import net.db64.homelawnsecurity.entity.custom.IPathBoundEntity;
import net.db64.homelawnsecurity.entity.custom.PlantEntity;
import net.db64.homelawnsecurity.entity.custom.ZombieEntity;
import net.minecraft.class_11;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1400;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4051;
import org.jetbrains.annotations.Nullable;

import java.util.function.Predicate;

public class ZombieTargetGoal<T extends class_1309> extends class_1400<T> {
	public float attackRange;

	public Predicate<class_1309> rangePredicate = entity -> {
		// Cubic attack range for a tile-based game

		/*HomeLawnSecurity.LOGGER.info("range: {}, in range: {}", attackRange, (Math.abs(mob.getBlockX() - entity.getBlockX()) <= attackRange)
			&& (Math.abs(mob.getBlockY() - entity.getBlockY()) <= attackRange)
			&& (Math.abs(mob.getBlockZ() - entity.getBlockZ()) <= attackRange));*/

		return (Math.abs(field_6660.method_31477() - entity.method_31477()) <= attackRange)
			&& (Math.abs(field_6660.method_31478() - entity.method_31478()) <= attackRange)
			&& (Math.abs(field_6660.method_31479() - entity.method_31479()) <= attackRange);
	};

	public Predicate<class_1309> notBehindPredicate = entity -> {
		// It should not target entities that are between it and its start

		//HomeLawnSecurity.LOGGER.info("checking notBehindPredicate");

		// Check for if the enemy is on a different path
		if (entity instanceof PlantEntity && ((PlantEntity) entity).onPath && !((PlantEntity) entity).isThisPath(field_6660.method_23312()))
			return false;

		// Find paths to the enemy and to the start
		class_11 targetPath = field_6660.method_5942().method_6349(entity, 1);
		class_11 startPath = findStartPath();
		if (targetPath == null || startPath == null) return false;
		//HomeLawnSecurity.LOGGER.info("targetPath: {}, startPath: {}", targetPath, startPath);

		// Get the position of the enemy
		class_2338 targetPos = targetPath.method_48();
		//HomeLawnSecurity.LOGGER.info("targetPos: {}", targetPos.toString());

		// Go through the start path and see if the enemy is behind or not
		if (startPath.method_48().equals(entity.method_24515())) return false; // *tells predicate to return true if the pos at the end of the path to the enemy is the same as the enemy's pos* "Why is it ignoring the pathfinding part of the predicate?" -Me, apparently
		for (int i = 0; i < startPath.method_38(); i++) {
			//HomeLawnSecurity.LOGGER.info("checking for if startPath has position {} at node #{}", targetPos.toShortString(), i);
			if (startPath.method_40(i).method_22879().equals(targetPos)) {
				//HomeLawnSecurity.LOGGER.info("startPath does share a node position with targetPos");
				return false;
			}
		}
		//HomeLawnSecurity.LOGGER.info("startPath did not share a node position with targetPos");
		return true;
	};

	public Predicate<class_1309> hasHeadPredicate = entity -> {
		if (field_6660 instanceof ZombieEntity zombie) {
			return zombie.hasHead();
		}
		return true;
	};

	public ZombieTargetGoal(class_1308 mob, Class<T> targetClass, boolean checkVisibility, float attackRange) {
		super(mob, targetClass, checkVisibility/*, (target, world) -> {
			ZombieEntity zombie = (ZombieEntity) mob;
			//BlockState state = world.getBlockState(target.getBlockPos().down());
			return zombie.isThisPath(target.getBlockPos().down());
		}*/);
		this.attackRange = attackRange;
	}

	@Override
	protected double method_6326() {
		return this.attackRange * 1.42; // Just barely enough to fill the cube
	}

	protected void method_18415() {
		class_3218 serverWorld = method_64451(this.field_6660);
		if (this.field_6643 != class_1657.class && this.field_6643 != class_3222.class) {
			this.field_6644 = serverWorld.method_64393(
				this.field_6660.method_37908().method_8390(this.field_6643, this.method_6321(this.method_6326()),
					livingEntity -> rangePredicate.test(livingEntity) && notBehindPredicate.test(livingEntity) && hasHeadPredicate.test(livingEntity)),
				this.method_61438(),
				this.field_6660,
				this.field_6660.method_23317(),
				this.field_6660.method_23320(),
				this.field_6660.method_23321()
			);
		} else {
			this.field_6644 = serverWorld.method_64389(this.method_61438(), this.field_6660, this.field_6660.method_23317(), this.field_6660.method_23320(), this.field_6660.method_23321());
		}
	}

	private class_4051 method_61438() {
		return this.field_6642.method_18418(this.method_6326());
	}

	@Nullable
	private class_11 findStartPath() {
		int rangeH = 16;
		int rangeV = 5;
		Iterable<class_2338> iterable = class_2338.method_25996(field_6660.method_23312().method_10084(), rangeH, rangeV, rangeH);
		for (class_2338 blockPos : iterable) {
			//HomeLawnSecurity.LOGGER.info("zombie is checking for if the block at {}, {}, {} is a goal", blockPos.getX(), blockPos.getY(), blockPos.getZ());
			if (!((IPathBoundEntity) field_6660).isStart(blockPos.method_10074())) continue;
			//HomeLawnSecurity.LOGGER.info("zombie is checking for if the start at {}, {}, {} is reachable", blockPos.getX(), blockPos.getY(), blockPos.getZ());
			class_11 path = field_6660.method_5942().method_6348(blockPos, 1);
			if (path == null) continue;
			//HomeLawnSecurity.LOGGER.info("zombie has decided the start at {}, {}, {} is reachable", blockPos.getX(), blockPos.getY(), blockPos.getZ());
			return path;
		}
		return null;
	}

	@Override
	public boolean method_6266() {
		if (field_6660 instanceof ZombieEntity zombie && !zombie.hasHead())
			field_6660.method_5980(null);
		return super.method_6266()
			&& (field_6644 == null || hasHeadPredicate.test(field_6644));
	}
}
