package net.db64.homelawnsecurity.entity.client.projectile;

import net.db64.homelawnsecurity.HomeLawnSecurity;
import net.db64.homelawnsecurity.entity.client.ModModelLayers;
import net.db64.homelawnsecurity.entity.client.plant.PeashooterRenderState;
import net.db64.homelawnsecurity.entity.custom.plant.PeashooterEntity;
import net.db64.homelawnsecurity.entity.custom.projectile.PeaEntity;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;

public class PeaRenderer extends class_897<PeaEntity, PeaRenderState> {
	private static final class_2960 TEXTURE = class_2960.method_60655(HomeLawnSecurity.MOD_ID, "textures/entity/projectile/pea.png");
	private final PeaModel model;

	public PeaRenderer(class_5617.class_5618 context) {
		super(context);
		this.model = new PeaModel(context.method_32167(ModModelLayers.Projectile.PEA));
	}

	public class_2960 getTexture(PeaRenderState state) {
		return TEXTURE;
	}

	@Override
	public void render(PeaRenderState state, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light) {
		matrixStack.method_22903();

		matrixStack.method_46416(0f, -1.25f, 0f);

		matrixStack.method_22907(class_7833.field_40716.rotationDegrees(state.yaw - 90.0F));
		matrixStack.method_22907(class_7833.field_40718.rotationDegrees(state.pitch));

		class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23576(this.getTexture(state)));

		this.model.setAngles(state);

		this.model.method_60879(matrixStack, vertexConsumer, light, class_4608.field_21444);

		matrixStack.method_22909();
		super.method_3936(state, matrixStack, vertexConsumerProvider, light);
	}

	@Override
	public PeaRenderState method_55269() {
		return new PeaRenderState();
	}

	@Override
	public void updateRenderState(PeaEntity entity, PeaRenderState state, float f) {
		super.method_62354(entity, state, f);

		state.pitch = entity.method_36455();
		state.yaw = entity.method_36454();
	}
}