package net.db64.homelawnsecurity.entity.client.zombie;

import net.db64.homelawnsecurity.entity.animation.ModAnimations;
import net.minecraft.class_11509;
import net.minecraft.class_3532;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.client.model.*;

public class TargetZombieModel extends class_583<TargetZombieRenderState> {
	private final class_630 targetZombie;
	private final class_630 head;
	private final class_630 hat;
	private final class_630 leftForearm;
	private final class_630 target;

	private final class_11509 moveAnimation;
	private final class_11509 setupAnimation;
	private final class_11509 attackAnimation;

	public TargetZombieModel(class_630 root) {
		super(root);
		this.targetZombie = root.method_32086("targetZombie");
		this.head = this.targetZombie.method_32086("body").method_32086("head");
		this.hat = this.head.method_32086("hat");
		this.leftForearm = this.targetZombie.method_32086("body").method_32086("leftArm").method_32086("leftForearm");
		this.target = this.targetZombie.method_32086("target");

		moveAnimation = ModAnimations.Zombie.BasicZombie.WALK.method_71979(root);
		setupAnimation = ModAnimations.Zombie.BasicZombie.SETUP.method_71979(root);
		attackAnimation = ModAnimations.Zombie.BasicZombie.EAT.method_71979(root);
	}

	public static class_5607 getTexturedModelData() {
		class_5609 modelData = new class_5609();
		class_5610 modelPartData = modelData.method_32111();
		class_5610 targetZombie = modelPartData.method_32117("targetZombie", class_5606.method_32108(), class_5603.method_32090(0.0F, 24.0F, 0.0F));

		class_5610 body = targetZombie.method_32117("body", class_5606.method_32108().method_32101(0, 16).method_32098(-4.0F, -12.0F, -2.0F, 8.0F, 12.0F, 4.0F, new class_5605(0.0F)), class_5603.method_32090(0.0F, -12.0F, 0.0F));

		class_5610 head = body.method_32117("head", class_5606.method_32108().method_32101(0, 0).method_32098(-4.0F, -8.0F, -4.0F, 8.0F, 8.0F, 8.0F, new class_5605(0.0F)), class_5603.method_32090(0.0F, -12.0F, 0.0F));

		class_5610 hat = head.method_32117("hat", class_5606.method_32108().method_32101(0, 51).method_32098(-4.0F, -9.0F, -4.0F, 8.0F, 3.0F, 8.0F, new class_5605(0.5F))
		.method_32101(44, 49).method_32098(-4.0F, -5.5F, -8.5F, 8.0F, 0.0F, 4.0F, new class_5605(0.0F)), class_5603.method_32090(0.0F, 0.0F, 0.0F));

		class_5610 rightArm = body.method_32117("rightArm", class_5606.method_32108().method_32101(36, 9).method_32098(-2.0F, 6.0F, -1.5F, 3.0F, 4.0F, 3.0F, new class_5605(0.0F))
		.method_32101(32, 32).method_32098(-3.0F, -2.0F, -2.0F, 4.0F, 8.0F, 4.0F, new class_5605(0.0F)), class_5603.method_32090(-5.0F, -10.0F, 0.0F));

		class_5610 leftArm = body.method_32117("leftArm", class_5606.method_32108().method_32101(16, 32).method_32098(-1.0F, -2.0F, -2.0F, 4.0F, 6.0F, 4.0F, new class_5605(0.0F)), class_5603.method_32090(5.0F, -10.0F, 0.0F));

		class_5610 leftForearm = leftArm.method_32117("leftForearm", class_5606.method_32108().method_32101(13, 44).method_32098(4.0F, -16.0F, -1.5F, 3.0F, 4.0F, 3.0F, new class_5605(0.0F))
		.method_32101(0, 41).method_32098(4.0F, -18.0F, -2.0F, 4.0F, 2.0F, 4.0F, new class_5605(0.0F)), class_5603.method_32090(-5.0F, 22.0F, 0.0F));

		class_5610 rightLeg = targetZombie.method_32117("rightLeg", class_5606.method_32108().method_32101(24, 16).method_32098(-2.0F, 0.0F, -2.0F, 4.0F, 12.0F, 4.0F, new class_5605(0.0F)), class_5603.method_32090(-2.0F, -12.0F, 0.0F));

		class_5610 leftLeg = targetZombie.method_32117("leftLeg", class_5606.method_32108().method_32101(32, 0).method_32098(-2.0F, 7.0F, -2.0F, 4.0F, 5.0F, 4.0F, new class_5605(0.0F))
		.method_32101(40, 20).method_32098(-1.5F, 5.0F, -1.5F, 3.0F, 2.0F, 3.0F, new class_5605(0.0F))
		.method_32101(0, 32).method_32098(-2.0F, 0.0F, -2.0F, 4.0F, 5.0F, 4.0F, new class_5605(0.0F)), class_5603.method_32090(2.0F, -12.0F, 0.0F));

		class_5610 target = targetZombie.method_32117("target", class_5606.method_32108().method_32101(42, 53).method_32098(-5.0F, -5.0F, -1.0F, 10.0F, 10.0F, 1.0F, new class_5605(0.0F)), class_5603.method_32090(0.0F, -14.0F, -10.0F));
		return class_5607.method_32110(modelData, 64, 64);
	}

	@Override
	public void setAngles(TargetZombieRenderState state) {
		this.method_63514();

		this.setHeadAngles(state.field_53447, state.field_53448);
		moveAnimation.method_71981(state.field_53450, state.field_53451, 8f, 8f);

		setupAnimation.method_71986(state.setupAnimationState, state.field_53328, 1f);
		attackAnimation.method_71986(state.attackAnimationState, state.field_53328, 1f);

		this.updateVisibleParts(state);
	}

	private void setHeadAngles(float headYaw, float headPitch) {
		headYaw = class_3532.method_15363(headYaw, -30.0f, 30.0f);
		headPitch = class_3532.method_15363(headPitch, -25.0f, 45.0f);

		this.head.field_3675 = headYaw * ((float)Math.PI / 180);
		this.head.field_3654 = headPitch * ((float)Math.PI / 180);
	}

	private void updateVisibleParts(TargetZombieRenderState state) {
		leftForearm.field_38456 = state.getHasLostArm();
		head.field_38456 = state.getHasLostHead();
		hat.field_38456 = state.getHasLostHead();
	}
}