package net.db64.homelawnsecurity.entity.custom;

import net.db64.homelawnsecurity.entity.ModDamageTypes;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1309;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;

public interface IDegradableEntity {
	//ArrayList<DegradationStage> degradationStages = new ArrayList<>();
	ArrayList<DegradationStage> getDegradationStageList();

	@Nullable
	default DegradationStage getDegradationStage(String name) {
		for (DegradationStage stage : getDegradationStageList()) {
			if (stage.getName().equals(name)) {
				return stage;
			}
		}
		return null;
	}

	default int getLastDegradationStage() {
		return getDegradationStageList().size() - 1;
	}

	default boolean hasTriggeredDegradationStage(String name) {
		DegradationStage stage = getDegradationStage(name);

		if (stage != null)
			return stage.hasTriggered;

		return false;
	}

	default void tickDegradation(class_1309 entity) {
		for (DegradationStage stage : getDegradationStageList()) {
			if (entity.method_6032() < stage.getHealth()) {
				if (!stage.hasTriggered) {
					stage.hasTriggered = true;

					if (stage.getSound() != null) {
						entity.method_37908().method_8396(
							null,
							entity.method_24515(),
							stage.getSound(),
							entity.method_5634(),
							1f,
							1.0f / (entity.method_59922().method_43057() * 0.4f + 0.8f)
						);
					}
				}

				if (!entity.method_37908().method_8608() && stage.getShouldDrainHealth()) {
					entity.method_64397((class_3218) entity.method_37908(), entity.method_48923().method_48795(ModDamageTypes.ZOMBIE_HEADLESS), 0.25f);
				}
			}
		}
	}

	default void writeDegradationNbt(class_11372 view) {
		if (view instanceof class_11362 nbtView) {
			ArrayList<DegradationStage> stages = getDegradationStageList();
			class_2479 degradationNbt = new class_2479(new byte[0]);

			for (int i = 0; i < stages.size(); i++) {
				degradationNbt.method_10533(i, class_2481.method_23234(stages.get(i).hasTriggered));
			}

			nbtView.field_60404.method_10566("degradation_stages", degradationNbt);
		}
	}

	default void readDegradationNbt(class_11368 view) {
		if (view instanceof class_11352 nbtView) {
			ArrayList<DegradationStage> stages = getDegradationStageList();
			byte[] degradationNbt = nbtView.field_60382.method_10547("degradation_stages").orElse(new byte[0]);

			for (int i = 0; i < degradationNbt.length; i++) {
				DegradationStage stage = stages.get(i);
				if (stage != null) {
					stage.hasTriggered = degradationNbt[i] == class_2481.field_21027.method_10698();
				}
			}
		}
	}

	class DegradationStage {
		private final String name;
		private final float health;
		private final boolean shouldDrainHealth;
		@Nullable
		private final class_3414 sound;

		public boolean hasTriggered = false;

		public DegradationStage(String name, float health, boolean shouldDrainHealth, @Nullable class_3414 sound) {
			this.name = name;
			this.health = health;
			this.shouldDrainHealth = shouldDrainHealth;
			this.sound = sound;
		}

		public DegradationStage(String name, float health, boolean shouldDrainHealth) {
			this(name, health, shouldDrainHealth, null);
		}

		public DegradationStage(String name, float health) {
			this(name, health, false);
		}

		public String getName() {
			return name;
		}

		public float getHealth() {
			return health;
		}

		public boolean getShouldDrainHealth() {
			return shouldDrainHealth;
		}

		@Nullable
		public class_3414 getSound() {
			return sound;
		}
	}
}
