package net.db64.homelawnsecurity.entity.custom.other;

import net.db64.homelawnsecurity.block.ModBlocks;
import net.db64.homelawnsecurity.component.ModDataComponentTypes;
import net.db64.homelawnsecurity.entity.ai.PvzNavigation;
import net.db64.homelawnsecurity.entity.ai.other.LawnMowerMoveGoal;
import net.db64.homelawnsecurity.entity.ai.other.LawnMowerStayOnPathGoal;
import net.db64.homelawnsecurity.entity.custom.IPathBoundEntity;
import net.db64.homelawnsecurity.entity.custom.IPvzEntity;
import net.db64.homelawnsecurity.entity.custom.ZombieEntity;
import net.db64.homelawnsecurity.entity.custom.zombie.ZombieGravestoneEntity;
import net.db64.homelawnsecurity.item.ModItems;
import net.db64.homelawnsecurity.sound.ModSounds;
import net.db64.homelawnsecurity.util.LawnUtil;
import net.db64.homelawnsecurity.util.ModTags;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1408;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.entity.*;
import org.jetbrains.annotations.Nullable;

public class LawnMowerEntity extends class_1314 implements IPvzEntity, IPathBoundEntity {
	public int pathId = 1;

	/*@Deprecated
	public TagKey<Block> pathTag = ModTags.Blocks.ZOMBIE_PATH_1;
	@Deprecated
	public TagKey<Block> pathMarkerTag = ModTags.Blocks.ZOMBIE_PATH_1_MARKERS;*/

	public boolean mowing;

	public boolean shouldDropSpawnItem = false;
	public class_1799 customSpawnItem = getDefaultSpawnItem();

	/*
		GENERAL
	 */

	public LawnMowerEntity(class_1299<LawnMowerEntity> entityType, class_1937 world) {
		super(entityType, world);

		/*if (!getWorld().isClient) {
			setPathTagNbt(pathTag);
		}*/
	}

	@Nullable
	@Override
	public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
		class_1315 result = super.method_5943(world, difficulty, spawnReason, entityData);

		//HomeLawnSecurity.LOGGER.info("new lawn mower");
		Iterable<class_2338> iterable = class_2338.method_25996(method_23312(), 5, 5, 5);
		for (class_2338 blockPos : iterable) {
			//HomeLawnSecurity.LOGGER.info("block pos {} is:", blockPos.toShortString());
			if (LawnUtil.isAnyPath(blockPos, method_37908())) {
				for (int i = 1; i <= LawnUtil.getPathTypeAmount(); i++) {
					if (LawnUtil.isCertainPath(blockPos, method_37908(), i)) {
						//HomeLawnSecurity.LOGGER.info("path {}", i);
						pathId = i;
					}
				}
				break;
			}
			//HomeLawnSecurity.LOGGER.info("not a path");
		}

		mowing = false;

		return result;
	}

	@Override
	public void method_5773() {
		super.method_5773();

		class_1937 world = method_37908();
		if (world instanceof class_3218 serverWorld) {
			boolean wasMowing = mowing;

			for (ZombieEntity entity : world
				.method_8390(ZombieEntity.class, this.method_5829(), class_1301.field_6155)) {
				if (!(entity instanceof TargetZombieEntity) && !(entity instanceof ZombieGravestoneEntity)) {
					mowing = true;
					entity.method_5768(serverWorld);
				}
			}

			if (mowing && !wasMowing)
				world.method_43129(null, this, ModSounds.ENTITY_LAWN_MOWER_ACTIVATE, class_3419.field_15254, 1f, world.method_8409().method_43057() * 0.4f + 1f);
		}
	}

	public void disappear() {
		((class_3218) method_37908()).method_65096(class_2398.field_11203, method_23316(0.5), method_23323(0.5), method_23324(0.5), 20, method_17681() * 0.5, method_17682() * 0.5, method_17681() * 0.5, 0.02);
		dropSpawnItemOnDeath();

		this.method_31472();
	}

	@Override
	protected void method_16080(class_3218 world, class_1282 damageSource) {
		super.method_16080(world, damageSource);

		if (method_29504())
			dropSpawnItemOnDeath();
	}

	protected void dropSpawnItemOnDeath() {
		if (shouldDropSpawnItem) {
			class_1542 itemEntity = method_5775((class_3218) method_37908(), getSpawnItem());
			if (itemEntity != null) {
				itemEntity.method_18800(field_5974.method_43057() * 0.1f - 0.05f, 0.1f, field_5974.method_43057() * 0.1f - 0.05f);
			}
		}
	}

	public class_1799 getSpawnItem() {
		if (customSpawnItem != null) {
			return customSpawnItem;
		}
		return getDefaultSpawnItem();
	}

	protected class_1799 getDefaultSpawnItem() {
		return ModItems.LAWN_MOWER.method_7854().method_7972();
	}

	@Override
	public void method_5652(class_11372 view) {
		super.method_5652(view);

		/*if (pathTag == ModTags.Blocks.ZOMBIE_PATH_2)
			view.putInt("path_tag", 2);
		else
			view.putInt("path_tag", 1);*/

		if (pathId < 1 || pathId > LawnUtil.getPathTypeAmount()) {
			pathId = 1;
		}
		view.method_71465("path_id", pathId);

		view.method_71472("should_drop_spawn_item", shouldDropSpawnItem);

		view.method_71468("spawn_item", class_1799.field_24671, customSpawnItem);

		if (this.mowing) {
			view.method_71472("mowing", true);
		}
	}

	@Override
	public void method_5749(class_11368 view) {
		super.method_5749(view);

		/*// path_tag
		int path = view.getInt("path_tag", 1);
		if (path == 2) {
			pathTag = ModTags.Blocks.ZOMBIE_PATH_2;
			pathMarkerTag = ModTags.Blocks.ZOMBIE_PATH_2_MARKERS;
		} else {
			pathTag = ModTags.Blocks.ZOMBIE_PATH_1;
			pathMarkerTag = ModTags.Blocks.ZOMBIE_PATH_1_MARKERS;
		}*/

		pathId = view.method_71424("path_id", 1);
		if (pathId < 1 || pathId > LawnUtil.getPathTypeAmount()) {
			pathId = 1;
			//view.putInt("path_id", pathId);
		}

		shouldDropSpawnItem = view.method_71433("should_drop_spawn_item", false);

		customSpawnItem = view.method_71426("spawn_item", class_1799.field_24671).orElse(getDefaultSpawnItem());

		// mowing
		this.mowing = view.method_71433("mowing", false);
	}

	@Override
	public void method_6005(double strength, double x, double z) {
		// oh no--i hope this really heavy beach ball doesn't break my leg

		if (method_6065() != null && method_6065().method_6047().method_57826(ModDataComponentTypes.SHOVEL)) {
			super.method_6005(strength * 3, x, z);
		}
	}

	@Override
	public boolean method_64397(class_3218 world, class_1282 source, float amount) {
		class_1297 attacker = source.method_5529();
		boolean damaged;
		if (attacker instanceof class_1309 && ((class_1309) attacker).method_6047().method_57826(ModDataComponentTypes.SHOVEL)) {
			world.method_8396(this, method_24515(), ModSounds.RANDOM_SHOVEL_ATTACK, attacker.method_5634(), 1, 1);
			damaged = super.method_64397(world, source, 1000000);
		}
		else if (attacker instanceof IPvzEntity) {
			damaged = super.method_64397(world, source, amount);

			this.field_6235 = 0;
			this.field_6008 = 0;
		}
		else {
			damaged = super.method_64397(world, source, amount * 10);
		}

		return damaged;
	}

	@Override
	protected class_1269 method_5992(class_1657 player, class_1268 hand) {
		// Don't let the player duplicate lawn mowers
		return class_1269.field_5811;
	}

	/*
		ANIMATIONS
	 */

	/*
		BLOCKS
	 */

	public int getPathId() {
		return pathId;
	}

	public void setPathId(int pathId) {
		this.pathId = pathId;
	}

	public boolean isWalkable(class_2338 pos) {
		return LawnUtil.isWalkable(pos, method_37908(), pathId, false);
	}

	public boolean isThisPath(class_2338 pos) {
		return isCertainPath(pos, pathId);
	}

	public boolean isCertainPath(class_2338 pos, int pathId) {
		return LawnUtil.isCertainPath(pos, method_37908(), pathId);
	}

	/**
	 * @return Whether a lawn mower can be placed on top of this block.
	 */
	public static boolean isPlaceable(class_2338 pos, class_1937 world) {
		class_2680 markerState = world.method_8320(pos.method_10084());

		if (markerState.method_26164(ModTags.Blocks.MARKERS)) {
			return markerState.method_26204() == ModBlocks.GARDEN_MARKER;
		}
		return world.method_8320(pos).method_26204() == ModBlocks.GARDEN_BLOCK;
	}

	/**
	 * @return Whether this block is a lawn mower goal.
	 */
	public boolean isGoal(class_2338 pos) {
		class_1937 world = method_37908();
		class_2680 state = world.method_8320(pos);
		class_2680 markerState = world.method_8320(pos.method_10084());

		if (markerState.method_26164(ModTags.Blocks.MARKERS)) {
			return markerState.method_26164(ModTags.Blocks.ZOMBIE_START_MARKERS);
		}
		return state.method_26164(ModTags.Blocks.ZOMBIE_START);
	}

	/**
	 * @return Whether this block is a lawn mower start.
	 */
	public boolean isStart(class_2338 pos) {
		class_1937 world = method_37908();
		class_2680 state = world.method_8320(pos);
		class_2680 markerState = world.method_8320(pos.method_10084());

		if (markerState.method_26164(ModTags.Blocks.MARKERS)) {
			return markerState.method_26164(ModTags.Blocks.ZOMBIE_GOAL_MARKERS);
		}
		return state.method_26164(ModTags.Blocks.ZOMBIE_GOAL);
	}

	/*@Override
	public float getPathfindingPenalty(PathNodeType nodeType) {
		if (nodeType == PathNodeType.) {
			return 0f; // Path
		}
		else if (state.isIn(ModTags.Blocks.ZOMBIE_GOAL)) {
			return 0f; // Goal
		}
		return -1f; // Off-road
	}*/

	@Override
	public float method_6144(class_2338 pos, class_4538 world) {
		//BlockState state = world.getBlockState(pos.down());
		if (isThisPath(pos.method_10074())) {
			return 0f; // Path
		}
		else if (isGoal(pos.method_10074())) {
			return 0f; // Goal
		}
		return Float.NEGATIVE_INFINITY; // Off-road
	}

	@Override
	protected class_1408 method_5965(class_1937 world) {
		return new PvzNavigation(this, world);
	}

	/*
		STATS
	 */

	public static class_5132.class_5133 createAttributes() {
		return class_1308.method_26828()
			.method_26868(class_5134.field_23716, 100 * IPvzEntity.HEALTH_SCALE)
			.method_26868(class_5134.field_23721, 10000)
			.method_26868(class_5134.field_23717, 64)
			.method_26868(class_5134.field_23719, 0.3);
	}

	@Override
	protected void method_5959() {
		this.field_6201.method_6277(0, new LawnMowerStayOnPathGoal(this, 1f));
		//this.goalSelector.add(2, new LawnMowerTargetGoal<>(this, ZombieEntity.class, true));
		//this.goalSelector.add(2, new ZombieMeleeAttackGoal(this, 1, false));
		this.field_6201.method_6277(3, new LawnMowerMoveGoal(this, 1f));
	}

	/*
		SOUNDS
	 */

	@Override
	protected void method_5712(class_2338 pos, class_2680 state) {
		//super.playStepSound(pos, state);
	}

	@Override
	protected void method_51296(class_2680 state) {
		//super.playSecondaryStepSound(state);
	}
}
