package net.db64.homelawnsecurity.entity.custom.plant;

import net.db64.homelawnsecurity.entity.custom.IPvzEntity;
import net.db64.homelawnsecurity.entity.custom.PlantEntity;
import net.db64.homelawnsecurity.entity.custom.ZombieEntity;
import net.db64.homelawnsecurity.entity.custom.other.CurrencyEntity;
import net.db64.homelawnsecurity.item.ModItems;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1361;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_7094;

public class SunflowerEntity extends PlantEntity implements IPvzEntity, ILawnPlant {
	private static final class_2940<Boolean> USING_ATTACK =
		class_2945.method_12791(SunflowerEntity.class, class_2943.field_13323);

	private static final PlantStats STATS = new PlantStats().attackRange(3f).attackTicks(30);

	public final class_7094 setupAnimationState = new class_7094();

	public final int MAX_SUN_TICKS = 480;
	public int sunTicks = 120;

	/*
		GENERAL
	 */

	public SunflowerEntity(class_1299<? extends PlantEntity> entityType, class_1937 world) {
		super(entityType, world);
	}

	/*
		ANIMATIONS
	 */

	protected void updateAnimations() {
		super.updateAnimations();

		if (!setupAnimationState.method_41327())
			setupAnimationState.method_41322(this.field_6012);
	}

	@Override
	public class_2940<Boolean> getUsingAttackTrackedData() {
		return USING_ATTACK;
	}

	/*
		BLOCKS
	 */

	/*
		SHOOTING
	 */

	@Override
	public void method_5773() {
		super.method_5773();

		if (!(method_37908() instanceof class_3218)) {
			return;
		}

		sunTicks--;

		if (sunTicks <= 0) {
			sunTicks = MAX_SUN_TICKS;

			method_37908().method_8649(createProjectile(this));
		}
	}

	public static class_1676 createProjectile(SunflowerEntity entity) {
		//ArrowItem arrowItem = (ArrowItem)(stack.getItem() instanceof ArrowItem ? stack.getItem() : Items.ARROW);
		class_5819 random = entity.method_59922();

		class_1676 projectileEntity = new CurrencyEntity(entity.method_23317(), entity.method_23318() + entity.method_17682() * 0.6, entity.method_23321(), entity.method_37908(), new class_1799(ModItems.SUN));
		projectileEntity.method_7432(entity);
		projectileEntity.method_18800(random.method_43057() * 0.2 - 0.1, 0.2, random.method_43057() * 0.2 - 0.1);

		return projectileEntity;
	}

	@Override
	public double method_23320() {
		return this.method_23318() + (this.method_17682() * 0.8);
	}

	@Override
	public void method_5652(class_11372 view) {
		super.method_5652(view);

		view.method_71465("sun_ticks", sunTicks);
	}

	@Override
	public void method_5749(class_11368 view) {
		super.method_5749(view);

		sunTicks = view.method_71424("sun_ticks", 0);
	}

	/*
		STATS
	 */

	@Override
	protected void method_5959() {
		field_6201.method_6277(2, new class_1361(this, ZombieEntity.class, 3));
	}

	public static class_5132.class_5133 createAttributes() {
		return class_1308.method_26828()
			.method_26868(class_5134.field_23716, 300 * IPvzEntity.HEALTH_SCALE)
			.method_26868(class_5134.field_23721, 20 * IPvzEntity.HEALTH_SCALE)
			.method_26868(class_5134.field_23717, 3)
			.method_26868(class_5134.field_23719, 0);
	}
}
