package net.db64.homelawnsecurity.entity.custom.projectile;

import net.db64.homelawnsecurity.entity.ModDamageTypes;
import net.db64.homelawnsecurity.entity.ModEntities;
import net.db64.homelawnsecurity.entity.custom.IPvzEntity;
import net.db64.homelawnsecurity.entity.custom.ZombieEntity;
import net.db64.homelawnsecurity.entity.custom.plant.PeashooterEntity;
import net.db64.homelawnsecurity.sound.ModSounds;
import net.minecraft.class_10774;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3966;
import net.minecraft.entity.*;
import java.util.Iterator;

public class PeaEntity extends class_1676 implements IPvzEntity {
	private static final class_2940<Float> MAX_DISTANCE =
		class_2945.method_12791(PeaEntity.class, class_2943.field_13320);

	public PeaEntity(class_1299<? extends class_1676> entityType, class_1937 world) {
		super(entityType, world);
		setMaxDistance(0f);
	}

	public PeaEntity(class_1309 livingEntity, class_1937 world, float maxDistance) {
		this(livingEntity.method_23317(), livingEntity.method_23320() - (double) 0.1f, livingEntity.method_23321(), world, maxDistance);
	}

	public PeaEntity(double x, double y, double z, class_1937 world, float maxDistance) {
		this(ModEntities.Projectile.PEA, world);
		this.method_5814(x, y, z);
		setMaxDistance(maxDistance);
	}

	@Override
	protected boolean method_26958(class_1297 entity) {
		return entity instanceof ZombieEntity && super.method_26958(entity);
	}

	@Override
	protected void method_5693(class_2945.class_9222 builder) {
		builder.method_56912(MAX_DISTANCE, 0f);
	}

	@Override
	public void method_5773() {
		this.tickInitialBubbleColumnCollision();
		this.method_56990();
		//this.applyDrag();
		class_239 hitResult = class_1675.method_49997(this, this::method_26958);
		class_243 vec3d;
		if (hitResult.method_17783() != class_239.class_240.field_1333) {
			vec3d = hitResult.method_17784();
		} else {
			vec3d = this.method_19538().method_1019(this.method_18798());
		}

		//double d = this.getX() + vec3d.x;
		//double e = this.getY() + vec3d.y;
		//double f = this.getZ() + vec3d.z;

		this.method_33574(vec3d);
		this.method_26962();
		this.method_61409();
		super.method_5773();
		if (hitResult.method_17783() != class_239.class_240.field_1333 && this.method_5805()) {
			this.method_59860(hitResult);
		}

		class_243 velocity = this.method_18798();
		this.field_5994 += (float) Math.sqrt(velocity.field_1352 * velocity.field_1352 + velocity.field_1351 * velocity.field_1351 + velocity.field_1350 * velocity.field_1350);
		//this.setPosition(d, e, f);
	}

	protected double method_7490() {
		if (field_5994 <= getMaxDistance()) // Bro why doesn't this variable work with projectiles
			return 0d;
		return 0.08d;
	}

	@Override
	protected void method_7454(class_3966 entityHitResult) {
		super.method_7454(entityHitResult);
		class_1297 entity = entityHitResult.method_17782();
		if (!(method_37908() instanceof class_3218))
			return;
		entity.method_64397((class_3218) entity.method_37908(), this.method_48923().method_48797(ModDamageTypes.PEA, this, this.method_24921()), 20 * IPvzEntity.HEALTH_SCALE);
		//entity.damage(ModDamageTypes.of(entity.getWorld(), ModDamageTypes.PEA), 20);
	}

	@Override
	protected void method_7488(class_239 hitResult) {
		super.method_7488(hitResult);
		if (!this.method_37908().field_9236) {
			this.method_5783(ModSounds.ENTITY_PEA_HIT, 1.0f, 1.0f);
			this.method_31472();
		}
	}

	private void tickInitialBubbleColumnCollision() {
		if (this.field_5953) {
			Iterator var1 = class_2338.method_62671(this.method_5829()).iterator();

			while(var1.hasNext()) {
				class_2338 blockPos = (class_2338)var1.next();
				class_2680 blockState = this.method_37908().method_8320(blockPos);
				if (blockState.method_27852(class_2246.field_10422)) {
					blockState.method_26178(this.method_37908(), blockPos, this, class_10774.field_56634);
				}
			}
		}
	}

	@Override
	public void method_5652(class_11372 view) {
		super.method_5652(view);

		view.method_71464("distance_traveled", field_5994);
	}

	@Override
	public void method_5749(class_11368 view) {
		super.method_5749(view);

		this.field_5994 = view.method_71423("distance_traveled", 0f);
	}

	public float getMaxDistance() {
		return method_5841().method_12789(MAX_DISTANCE);
	}

	public void setMaxDistance(float maxDistance) {
		method_5841().method_12778(MAX_DISTANCE, maxDistance);
	}

	public static void register(class_1299<PeaEntity> entityType) {

	}
}
