package net.db64.homelawnsecurity.entity.custom.zombie;

import net.db64.homelawnsecurity.entity.custom.IDegradableEntity;
import net.db64.homelawnsecurity.entity.custom.IPvzEntity;
import net.db64.homelawnsecurity.entity.custom.ZombieEntity;
import net.db64.homelawnsecurity.entity.custom.other.CurrencyEntity;
import net.db64.homelawnsecurity.item.ModItems;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;

public class ZombieGravestoneEntity extends ZombieEntity {
	private static final class_2940<Boolean> USING_ATTACK =
		class_2945.method_12791(ZombieGravestoneEntity.class, class_2943.field_13323);

	public final class_7094 setupAnimationState = new class_7094();

	public final int MAX_BRAINPOWER_TICKS = 480;
	public int brainpowerTicks = 120;

	/*
		GENERAL
	 */

	public ZombieGravestoneEntity(class_1299<? extends ZombieEntity> entityType, class_1937 world) {
		super(entityType, world);

		ArrayList<DegradationStage> degradationStages = getDegradationStageList();
		degradationStages.add(new IDegradableEntity.DegradationStage("cracks", 320 * IPvzEntity.HEALTH_SCALE, false, null));
		degradationStages.add(new IDegradableEntity.DegradationStage("break1", 240 * IPvzEntity.HEALTH_SCALE, false, null));
		degradationStages.add(new IDegradableEntity.DegradationStage("break2", 200 * IPvzEntity.HEALTH_SCALE, false, null));
		degradationStages.add(new IDegradableEntity.DegradationStage("break3", 160 * IPvzEntity.HEALTH_SCALE, false, null));
		degradationStages.add(new IDegradableEntity.DegradationStage("break4", 100 * IPvzEntity.HEALTH_SCALE, false, null));
	}

	/*
		ANIMATIONS
	 */

	protected void updateAnimations() {
		super.updateAnimations();

		if (!setupAnimationState.method_41327())
			setupAnimationState.method_41322(this.field_6012);
	}

	@Override
	public class_2940<Boolean> getUsingAttackTrackedData() {
		return USING_ATTACK;
	}

	/*@Override
	public float getLoseHeadwearHealth() {
		return -1;
	}

	@Override
	public float getLoseArmHealth() {
		return -1;
	}

	@Override
	public float getLoseHeadHealth() {
		return -1;
	}

	@Override
	public TrackedData<Boolean> getHasLostHeadwearTrackedData() {
		return null;
	}

	@Override
	public TrackedData<Boolean> getHasLostArmTrackedData() {
		return null;
	}

	@Override
	public TrackedData<Boolean> getHasLostHeadTrackedData() {
		return null;
	}*/

	/*
		BLOCKS
	 */

	/*
		SHOOTING
	 */

	@Override
	public void method_5773() {
		super.method_5773();

		if (!(method_37908() instanceof class_3218)) {
			return;
		}

		brainpowerTicks--;

		if (brainpowerTicks <= 0) {
			brainpowerTicks = MAX_BRAINPOWER_TICKS;

			method_37908().method_8649(createProjectile(this));
		}
	}

	public static class_1676 createProjectile(ZombieGravestoneEntity entity) {
		//ArrowItem arrowItem = (ArrowItem)(stack.getItem() instanceof ArrowItem ? stack.getItem() : Items.ARROW);
		class_5819 random = entity.method_59922();

		class_1676 projectileEntity = new CurrencyEntity(entity.method_23317(), entity.method_23318() + entity.method_17682() * 0.6, entity.method_23321(), entity.method_37908(), new class_1799(ModItems.BRAINPOWER));
		projectileEntity.method_7432(entity);
		projectileEntity.method_18800(random.method_43057() * 0.2 - 0.1, 0.2, random.method_43057() * 0.2 - 0.1);

		return projectileEntity;
	}

	@Override
	public double method_23320() {
		return this.method_23318() + (this.method_17682() * 0.8);
	}

	@Override
	public void method_5652(class_11372 view) {
		super.method_5652(view);

		view.method_71465("brainpower_ticks", brainpowerTicks);
	}

	@Override
	public void method_5749(class_11368 view) {
		super.method_5749(view);

		brainpowerTicks = view.method_71424("brainpower_ticks", 0);
	}

	/*
		SOUND
	 */

	@Override
	protected @Nullable class_3414 method_5994() {
		return null;
	}

	@Override
	protected class_3414 method_6002() {
		return null;
	}

	/*
		STATS
	 */

	@Override
	protected void method_5959() {
		//goalSelector.add(2, new LookAtEntityGoal(this, ZombieEntity.class, 3));
	}

	public static class_5132.class_5133 createAttributes() {
		return class_1308.method_26828()
			.method_26868(class_5134.field_23716, 400 * IPvzEntity.HEALTH_SCALE)
			.method_26868(class_5134.field_23721, 20 * IPvzEntity.HEALTH_SCALE)
			.method_26868(class_5134.field_23717, 3)
			.method_26868(class_5134.field_23719, 0);
	}
}
