package net.db64.homelawnsecurity.item;

import net.db64.homelawnsecurity.HomeLawnSecurity;
import net.db64.homelawnsecurity.component.*;
import net.db64.homelawnsecurity.entity.ModEntities;
import net.db64.homelawnsecurity.item.custom.*;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_10192;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3902;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import net.minecraft.item.*;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public class ModItems {
	public static final class_5250 OBSOLETE = class_2561.method_43471("tooltip.item.homelawnsecurity.obsolete")
		.method_10862(class_2583.field_24360.method_10977(class_124.field_1061).method_10982(true));

	public static final class_1792 PEASHOOTER_SPAWN_EGG = register("peashooter_spawn_egg", settings ->
		new class_1826(ModEntities.Plant.PEASHOOTER, settings), new class_1792.class_1793());
	public static final class_1792 BASIC_ZOMBIE_SPAWN_EGG = register("basic_zombie_spawn_egg", settings ->
		new class_1826(ModEntities.Zombie.BASIC_ZOMBIE, settings), new class_1792.class_1793());

	//public static final Item DAVES_PAN = registerItem("daves_pan",
		//new ArmorItem(ModArmorMaterials.DAVES_PAN, ArmorItem.Type.HELMET, new FabricItemSettings()));
	public static final class_1792 DAVES_PAN = register("daves_pan", settings ->
		new DavesPanItem(settings), new class_1792.class_1793().method_57349(class_9334.field_54196, class_10192.method_64202(class_1304.field_6169).method_64205(class_3417.field_14862).method_64210(false).method_64203()), List.of(
			class_2561.method_43471("tooltip.item.homelawnsecurity.daves_pan"),
			class_2561.method_43471("tooltip.item.homelawnsecurity.daves_pan.warning").method_10862(class_2583.field_24360.method_10977(class_124.field_1054))));

	public static final class_1792 SUN = register("sun", settings ->
		new CurrencyItem(settings, SeedPacketItem.SUN_BAG_PREDICATE), new class_1792.class_1793().method_57349(ModDataComponentTypes.CURRENCY,
		new CurrencyComponent(25, "sun")));
	public static final class_1792 BRAINPOWER = register("brainpower", settings ->
		new CurrencyItem(settings, SeedPacketItem.BRAINPOWER_BAG_PREDICATE), new class_1792.class_1793().method_57349(ModDataComponentTypes.CURRENCY,
		new CurrencyComponent(25, "brainpower")));

	public static final class_1792 BAG_OF_SUN = register("bag_of_sun", settings ->
		new BagOfCurrencyItem(settings), new class_1792.class_1793().method_7889(1).method_57349(ModDataComponentTypes.BAG_OF_CURRENCY,
		new BagOfCurrencyComponent(0, "sun")));
	public static final class_1792 BAG_OF_BRAINPOWER = register("bag_of_brainpower", settings ->
		new BagOfCurrencyItem(settings), new class_1792.class_1793().method_7889(1).method_57349(ModDataComponentTypes.BAG_OF_CURRENCY,
		new BagOfCurrencyComponent(0, "brainpower")));

	public static final class_1792 LAWN_MOWER = register("lawn_mower", settings ->
		new LawnMowerItem(ModEntities.Other.LAWN_MOWER, settings), new class_1792.class_1793());
	public static final class_1792 TARGET = register("target", settings ->
		new TargetItem(ModEntities.Other.TARGET_ZOMBIE, settings), new class_1792.class_1793(), List.of(
			class_2561.method_43471("tooltip.item.homelawnsecurity.target")));

	public static final class_1792 SHOVEL = register("shovel", settings ->
		new class_1792(settings), new class_1792.class_1793().method_7889(1).method_57349(ModDataComponentTypes.SHOVEL, class_3902.field_17274), List.of(
			class_2561.method_43471("tooltip.item.homelawnsecurity.shovel.use"),
			class_2561.method_43471("tooltip.item.homelawnsecurity.shovel.attack")));
	public static final class_1792 LAWN_GADGET = register("lawn_gadget", settings ->
		new LawnGadgetItem(settings), new class_1792.class_1793().method_7889(1)
		.method_57349(ModDataComponentTypes.LAWN_GADGET, new LawnGadgetComponent("turf_toggle")), List.of(
			class_2561.method_43471("tooltip.item.homelawnsecurity.lawn_gadget.use"),
			class_2561.method_43471("tooltip.item.homelawnsecurity.lawn_gadget.switch")));

	public static final class_1792 TURF = register("turf", settings ->
		new TurfItem(settings), new class_1792.class_1793(), List.of(
		class_2561.method_43471("tooltip.item.homelawnsecurity.turf")));

	public static final class_1792 BRAIN = register("brain", settings ->
		new class_1792(settings), new class_1792.class_1793(), List.of(
		class_2561.method_43471("tooltip.item.homelawnsecurity.brain")));



	public static final class_1792 SEED_PACKET_SUNFLOWER = register("seed_packet_sunflower", settings ->
		new LawnSeedPacketItem(ModEntities.Plant.SUNFLOWER, settings), new class_1792.class_1793()
		.method_57349(ModDataComponentTypes.SEED_PACKET, new SeedPacketComponent(50, 150)));

	public static final class_1792 SEED_PACKET_PEASHOOTER = register("seed_packet_peashooter", settings ->
		new LawnSeedPacketItem(ModEntities.Plant.PEASHOOTER, settings), new class_1792.class_1793()
		.method_57349(ModDataComponentTypes.SEED_PACKET, new SeedPacketComponent(100, 150)));

	public static final class_1792 SEED_PACKET_WALL_NUT = register("seed_packet_wall_nut", settings ->
		new PathSeedPacketItem(ModEntities.Plant.WALL_NUT, settings), new class_1792.class_1793()
		.method_57349(ModDataComponentTypes.SEED_PACKET, new SeedPacketComponent(50, 600)));



	public static final class_1792 SEED_PACKET_ZOMBIE_GRAVESTONE = register("seed_packet_zombie_gravestone", settings ->
		new ZombieSeedPacketItem(ModEntities.Zombie.ZOMBIE_GRAVESTONE, settings), new class_1792.class_1793()
		.method_57349(ModDataComponentTypes.SEED_PACKET, new SeedPacketComponent(25, 150)));

	public static final class_1792 SEED_PACKET_BASIC_ZOMBIE = register("seed_packet_basic_zombie", settings ->
		new ZombieSeedPacketItem(ModEntities.Zombie.BASIC_ZOMBIE, settings), new class_1792.class_1793()
		.method_57349(ModDataComponentTypes.SEED_PACKET, new SeedPacketComponent(25, 150)));

	public static final class_1792 SEED_PACKET_CONEHEAD_ZOMBIE = register("seed_packet_conehead_zombie", settings ->
		new ZombieSeedPacketItem(ModEntities.Zombie.CONEHEAD_ZOMBIE, settings), new class_1792.class_1793()
		.method_57349(ModDataComponentTypes.SEED_PACKET, new SeedPacketComponent(75, 600)));

	public static class_1792 register(class_5321<class_1792> key, Function<class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings) {
		HomeLawnSecurity.LOGGER.debug("Registering item with key {}", key.method_29177());

		return class_1802.method_51348(key, factory, settings);
	}

	public static class_1792 register(String id, Function<class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings) {
		HomeLawnSecurity.LOGGER.debug("Registering item {}:{}", HomeLawnSecurity.MOD_ID, id);

		return class_1802.method_51348(keyOf(id), factory, settings);
	}

	public static class_1792 register(String id, Function<class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings, @Nullable List<class_2561> tooltip) {
		return register(id, factory, settings.method_57349(ModDataComponentTypes.TOOLTIP, new TooltipComponent(tooltip)));
	}

	/*public static Item register(Block block, Item.Settings settings, @Nullable List<Text> tooltip) {
		if (tooltip != null)
			settings = settings.component(ModDataComponentTypes.TOOLTIP, new TooltipComponent(tooltip));

		return register(block.getRegistryEntry().registryKey(), settings1 -> new BlockItem(block, settings1), settings.useBlockPrefixedTranslationKey());
	}*/

	public static class_1792 register(class_2248 block) {
		return register(block, class_1747::new);
	}

	public static class_1792 register(class_2248 block, BiFunction<class_2248, class_1792.class_1793, class_1792> factory) {
		return register(block, factory, new class_1792.class_1793());
	}

	public static class_1792 register(class_2248 block, BiFunction<class_2248, class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings) {
		return register(
			keyOf(block.method_40142().method_40237()), itemSettings -> (class_1792)factory.apply(block, itemSettings), settings.method_63685()
		);
	}

	private static class_5321<class_1792> keyOf(class_5321<class_2248> blockKey) {
		return class_5321.method_29179(class_7924.field_41197, blockKey.method_29177());
	}

	private static class_5321<class_1792> keyOf(String id) {
		return class_5321.method_29179(class_7924.field_41197, class_2960.method_60655(HomeLawnSecurity.MOD_ID, id));
	}

	public static void registerModItems() {
		HomeLawnSecurity.LOGGER.debug("Registering items for Home Lawn Security (" + HomeLawnSecurity.MOD_ID + ")");

		HomeLawnSecurity.LOGGER.debug("Registering vanilla item groups for Home Lawn Security (" + HomeLawnSecurity.MOD_ID + ")");

		ItemGroupEvents.modifyEntriesEvent(class_7706.field_40195).register(VanillaItemGroups::addItemsToBuildingBlocksItemGroup);
		ItemGroupEvents.modifyEntriesEvent(class_7706.field_41059).register(VanillaItemGroups::addItemsToColoredBlocksItemGroup);
		ItemGroupEvents.modifyEntriesEvent(class_7706.field_40743).register(VanillaItemGroups::addItemsToNaturalBlocksItemGroup);
		ItemGroupEvents.modifyEntriesEvent(class_7706.field_40197).register(VanillaItemGroups::addItemsToFunctionalBlocksItemGroup);
		ItemGroupEvents.modifyEntriesEvent(class_7706.field_40198).register(VanillaItemGroups::addItemsToRedstoneBlocksItemGroup);

		ItemGroupEvents.modifyEntriesEvent(class_7706.field_41060).register(VanillaItemGroups::addItemsToToolsAndUtilitiesItemGroup);
		ItemGroupEvents.modifyEntriesEvent(class_7706.field_40202).register(VanillaItemGroups::addItemsToCombatItemGroup);
		ItemGroupEvents.modifyEntriesEvent(class_7706.field_41061).register(VanillaItemGroups::addItemsToFoodAndDrinksItemGroup);
		ItemGroupEvents.modifyEntriesEvent(class_7706.field_41062).register(VanillaItemGroups::addItemsToIngredientsItemGroup);
		ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(VanillaItemGroups::addItemsToSpawnEggsItemGroup);

		ItemGroupEvents.modifyEntriesEvent(class_7706.field_41063).register(VanillaItemGroups::addItemsToOperatorUtilitiesItemGroup);
	}

	private static class VanillaItemGroups {
		public static void addItemsToBuildingBlocksItemGroup(FabricItemGroupEntries entries) {
		}

		public static void addItemsToColoredBlocksItemGroup(FabricItemGroupEntries entries) {
		}

		public static void addItemsToNaturalBlocksItemGroup(FabricItemGroupEntries entries) {
		}

		public static void addItemsToFunctionalBlocksItemGroup(FabricItemGroupEntries entries) {
		}

		public static void addItemsToRedstoneBlocksItemGroup(FabricItemGroupEntries entries) {
		}

		public static void addItemsToToolsAndUtilitiesItemGroup(FabricItemGroupEntries entries) {
		}

		public static void addItemsToCombatItemGroup(FabricItemGroupEntries entries) {
		}

		public static void addItemsToFoodAndDrinksItemGroup(FabricItemGroupEntries entries) {
		}

		public static void addItemsToIngredientsItemGroup(FabricItemGroupEntries entries) {
		}

		public static void addItemsToSpawnEggsItemGroup(FabricItemGroupEntries entries) {
		}

		public static void addItemsToOperatorUtilitiesItemGroup(FabricItemGroupEntries entries) {
		}
	}
}
