package net.db64.homelawnsecurity.item.custom;

import com.mojang.serialization.MapCodec;
import net.db64.homelawnsecurity.component.BagOfCurrencyComponent;
import net.db64.homelawnsecurity.component.ModDataComponentTypes;
import net.db64.homelawnsecurity.component.SeedPacketComponent;
import net.db64.homelawnsecurity.entity.custom.PlantEntity;
import net.db64.homelawnsecurity.entity.custom.SeedPlacedEntity;
import net.db64.homelawnsecurity.item.ModItems;
import net.db64.homelawnsecurity.sound.ModSounds;
import net.db64.homelawnsecurity.util.ModTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2404;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import net.minecraft.class_7699;
import net.minecraft.class_7923;
import net.minecraft.class_8959;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.entity.*;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import java.util.function.Predicate;

public abstract class SeedPacketItem extends class_1792 {
	private static final MapCodec<class_1299<?>> ENTITY_TYPE_MAP_CODEC;
	private final class_1299<?> type;

	public static final Predicate<class_1799> SUN_BAG_PREDICATE = stack -> {
		if (stack == null) return false;
		return stack.method_31573(ModTags.Items.BAG_OF_SUN);
	};
	public static final Predicate<class_1799> BRAINPOWER_BAG_PREDICATE = stack -> {
		if (stack == null) return false;
		return stack.method_31573(ModTags.Items.BAG_OF_BRAINPOWER);
	};

	public SeedPacketItem(class_1299<? extends class_1308> type, class_1793 settings) {
		super(settings);
		this.type = type;
	}

	protected boolean isPlaceable(class_2338 blockPos, class_1937 world, boolean devMode, class_3222 player) {
		return PlantEntity.isPlaceable(blockPos, world, this);
	}

	public void playPlaceSound(class_1937 world, class_2338 pos) {
		if (world.method_8316(pos.method_10074()).method_15767(class_3486.field_15517))
			world.method_45447(null, pos, ModSounds.RANDOM_PLANT_WATER, class_3419.field_15254);
		else
			world.method_45447(null, pos, ModSounds.RANDOM_PLANT, class_3419.field_15254);
	}

	public static void playBuzzerSound(class_1937 world, class_2338 pos) {
		world.method_45447(null, pos, ModSounds.RANDOM_BUZZER, class_3419.field_15254);
	}

	protected static boolean isWearingDavesPan(@Nullable class_1657 user) {
		if (user == null) return false;

		return user.method_6118(class_1304.field_6169).method_31574(ModItems.DAVES_PAN);
	}

	@Override
	public class_1269 method_7884(class_1838 context) {
		class_2350 direction = context.method_8038();

		// Reject clients, return to servr
		class_1937 world = context.method_8045();
		if (!(world instanceof class_3218)) {
			return class_1269.field_5812;
		}

		// Variables
		class_1799 stack = context.method_8041();
		class_2338 pos = context.method_8037();
		class_2680 state = world.method_8320(pos);
		class_2586 blockEntity = world.method_8321(pos);

		class_1299<?> entityType = this.getEntityType(stack);

		// Spawner
		if (blockEntity instanceof class_8959 spawner) {
			spawner.method_46408(entityType, world.method_8409());
			world.method_8413(pos, state, state, class_2248.field_31036);
			world.method_33596(context.method_8036(), class_5712.field_28733, pos);
			stack.method_7934(1);
			//if (shouldCooldownBeUsed(context.getPlayer()))
				//context.getPlayer().getItemCooldownManager().set(this, cooldownLength);
			return class_1269.field_21466;
		}

		return useSeedPacket(stack, context.method_8036(), pos, (class_3218) context.method_8045(), direction);
	}

	@Override
	public class_1269 method_7836(class_1937 world, class_1657 player, class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		class_3965 blockHitResult = class_1826.method_7872(world, player, class_3959.class_242.field_1345);

		if (blockHitResult.method_17783() != class_239.class_240.field_1332) {
			return class_1269.field_5811;
		}
		if (!(world instanceof class_3218)) {
			return class_1269.field_5812;
		}

		class_2338 pos = blockHitResult.method_17777();

		if (!(world.method_8320(pos).method_26204() instanceof class_2404)) {
			return class_1269.field_5811;
		}
		if (!world.method_8505(player, pos) || !player.method_7343(pos, blockHitResult.method_17780(), stack)) {
			return class_1269.field_5814;
		}

		return useSeedPacket(stack, player, pos, (class_3218) world, blockHitResult.method_17780());
	}

	public class_1299<?> getEntityType(class_1799 stack) {
		class_9279 nbtComponent = stack.method_58695(class_9334.field_49609, class_9279.field_49302);
		return !nbtComponent.method_57458() ? nbtComponent.method_57446(ENTITY_TYPE_MAP_CODEC).result().orElse(this.type) : this.type;
	}

	@Override
	public class_7699 method_45322() {
		return this.type.method_45322();
	}

	public class_1799 getCurrentBag(class_1309 entity) {
		var predicate = getBagPredicate();
		if (predicate.test(entity.method_5998(class_1268.field_5810))) {
			return entity.method_5998(class_1268.field_5810);
		}
		else if (predicate.test(entity.method_5998(class_1268.field_5808))) {
			return entity.method_5998(class_1268.field_5808);
		}
		else if (entity instanceof class_3222 player) {
			class_1661 inventory = player.method_31548();
			for (int i = 0; i < inventory.method_5439(); i++) {
				class_1799 itemStack2 = inventory.method_5438(i);
				if (predicate.test(itemStack2)) {
					return itemStack2;
				}
			}
		}
		return class_1799.field_8037;
	}

	public abstract Predicate<class_1799> getBagPredicate();

	public class_1269 useSeedPacket(class_1799 stack, class_1657 player, class_2338 usePos, class_3218 world, class_2350 direction) {
		class_2338 groundPos = usePos.method_10093(direction).method_10074();
		class_2680 state = world.method_8320(usePos);
		class_1299<?> entityType = this.getEntityType(stack);

		// Invalid spawn position
		if (!isPlaceable(groundPos, world, isWearingDavesPan(player), (class_3222) player)) {
			//HomeLawnSecurity.LOGGER.warn("BlockPos {} is not a valid position for a seed packet of type {}!", pos, getClass().getSimpleName());
			playBuzzerSound(world, usePos);
			return class_1269.field_5812;
		}

		class_2338 spawnPos = state.method_26220(world, usePos).method_1110() ? usePos : usePos.method_10093(direction);

		if (!setCooldownAndCurrencyAndReturnIfInsufficient(player, stack, world, usePos))
			return class_1269.field_5812;

		class_1297 entity = entityType.method_5894(world, stack, player, spawnPos, class_3730.field_16465, true, !Objects.equals(usePos, spawnPos) && direction == class_2350.field_11036);
		if (entity != null) {
			stack.method_57008(1, player);

			setEntityData(stack, entity, player);

			world.method_33596(player, class_5712.field_28738, usePos);
			playPlaceSound(world, usePos);
		}

		return class_1269.field_21466;
	}

	protected boolean setCooldownAndCurrencyAndReturnIfInsufficient(@Nullable class_1657 player, class_1799 stack, class_1937 world, class_2338 usePos) {
		if (player != null) {
			boolean wearingPan = isWearingDavesPan(player);
			if (!wearingPan) {
				// Cost
				SeedPacketComponent seedData = stack.method_58694(ModDataComponentTypes.SEED_PACKET);
				int cost = 0;
				if (seedData != null) {
					cost = seedData.cost();
				}

				class_1799 bag = getCurrentBag(player);
				if (bag != null) {
					BagOfCurrencyComponent bagComponent = bag.method_58694(ModDataComponentTypes.BAG_OF_CURRENCY);
					if (bagComponent != null) {
						if (bagComponent.amount() < cost) {
							playBuzzerSound(world, usePos);
							return false;
						}

						bag.method_57379(ModDataComponentTypes.BAG_OF_CURRENCY, new BagOfCurrencyComponent(bagComponent.amount() - cost, bagComponent.name()));
					}
				}

				// Cooldown
				if (seedData != null) {
					player.method_7357().method_62835(stack, seedData.cooldown());
				}
			}
		}
		return true;
	}

	protected void setEntityData(class_1799 stack, class_1297 entity, @Nullable class_1297 source) {
		if (entity instanceof SeedPlacedEntity seedPlacedEntity) {
			if (source instanceof class_1657 player && !player.method_68878()) {
				seedPlacedEntity.shouldDropSpawnItem = true;
			}
			else if (!(source instanceof class_1657)) {
				seedPlacedEntity.shouldDropSpawnItem = true;
			}
			seedPlacedEntity.spawnItem = stack.method_46651(1);
		}
	}

	protected static void sendMessage(class_1657 player, class_2561 message) {
		((class_3222) player).method_43502(message, true);
	}

	static {
		ENTITY_TYPE_MAP_CODEC = class_7923.field_41177.method_39673().fieldOf("id");
	}
}
