package net.db64.homelawnsecurity.item.custom;

import net.db64.homelawnsecurity.entity.ModEntities;
import net.db64.homelawnsecurity.entity.custom.other.SeedPacketPathfindingEntity;
import net.db64.homelawnsecurity.entity.custom.ZombieEntity;
import net.db64.homelawnsecurity.entity.custom.other.ZombieSeedPacketPathfindingEntity;
import net.db64.homelawnsecurity.entity.custom.zombie.ZombieGravestoneEntity;
import net.db64.homelawnsecurity.sound.ModSounds;
import net.minecraft.class_11;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3730;
import java.util.function.Predicate;

public class ZombieSeedPacketItem extends SeedPacketItem {
	public ZombieSeedPacketItem(class_1299<? extends class_1308> type, class_1793 settings) {
		super(type, settings);
	}

	@Override
	protected boolean isPlaceable(class_2338 blockPos, class_1937 world, boolean devMode, class_3222 player) {
		if (!(world instanceof class_3218 serverWorld)) return false;

		// Return if it's not on a path
		if (!ZombieEntity.isPlaceable(blockPos, world)) {
			sendMessage(player, class_2561.method_43471("item.homelawnsecurity.seed_packet.zombie.placement.error.path"));
			return false;
		}

		// Check if it's too close to the goal
		SeedPacketPathfindingEntity entity = new ZombieSeedPacketPathfindingEntity(ModEntities.Other.ZOMBIE_SEED_PACKET_PATHFINDING, world);
		world.method_8649(entity);
		entity.method_5808(blockPos.method_10263(), blockPos.method_10264() + 1, blockPos.method_10260(), entity.method_36454(), entity.method_36455());
		entity.method_5943(serverWorld, world.method_8404(blockPos), class_3730.field_16465, null);

		// Return if it's too close to the garden
		if (!(devMode || isValidPositionOnPath(entity))) {
			sendMessage(player, class_2561.method_43471("item.homelawnsecurity.seed_packet.zombie.placement.error.too_close"));
			return false;
		}

		//entity.discard();
		return true;
	}

	public boolean isValidPositionOnPath(SeedPacketPathfindingEntity entity) {
		class_11 path = entity.findPathToStart(SeedPacketPathfindingEntity.searchDistanceFromClose());

		if (path == null) return false;
		else return path.method_38() <= SeedPacketPathfindingEntity.searchDistanceFromClose();
	}

	@Override
	public Predicate<class_1799> getBagPredicate() {
		return BRAINPOWER_BAG_PREDICATE;
	}

	@Override
	public void playPlaceSound(class_1937 world, class_2338 pos) {
		if (world.method_8316(pos.method_10074()).method_15767(class_3486.field_15517))
			world.method_45447(null, pos, ModSounds.ENTITY_ZOMBIE_PLACE_WATER, class_3419.field_15254);
		else
			world.method_45447(null, pos, ModSounds.ENTITY_ZOMBIE_PLACE, class_3419.field_15254);
	}

	@Override
	public class_1269 method_7847(class_1799 stack, class_1657 player, class_1309 entity, class_1268 hand) {
		// Reject clients, return to servr
		class_1937 world = player.method_37908();
		if (!(world instanceof class_3218)) {
			return class_1269.field_5812;
		}

		if (entity instanceof ZombieGravestoneEntity && !(getEntityType(stack).equals(ModEntities.Zombie.ZOMBIE_GRAVESTONE)))
			return useSeedPacket(stack, player, entity.method_23312(), (class_3218) world, class_2350.field_11036);

		return class_1269.field_5811;
	}
}
