package net.db64.homelawnsecurity.mixin;

import net.db64.homelawnsecurity.block.custom.MarkerBlock;
import net.db64.homelawnsecurity.entity.ModEntities;
import net.db64.homelawnsecurity.entity.custom.other.CurrencyEntity;
import net.db64.homelawnsecurity.item.custom.LawnGadgetItem;
import net.db64.homelawnsecurity.particle.custom.MarkerParticle;
import net.db64.homelawnsecurity.util.ModTags;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;

@Mixin(class_746.class)
public abstract class ClientPlayerEntityMixin extends PlayerEntityMixin {
	@Final
	@Shadow
	protected class_310 client;

	@Shadow public abstract boolean isSneaking();

	@Inject(
		method = "tick",
		at = @At("RETURN")
	)
	public void tickMarkerParticles(CallbackInfo ci) {
		List<class_1799> handItems = List.of(getMainHandStack(), getOffHandStack());
		for (class_1799 stack : handItems){
			if (stack != null && MarkerBlock.shouldRevealMarkers(stack, isSneaking())) {
				Iterable<class_2338> iterable = class_2338.method_62671(MarkerBlock.PARTICLE_DISTANCE.method_996(getBlockPos()));
				for (class_2338 blockPos : iterable) {
					class_1937 world = getWorld();
					class_2680 state = world.method_8320(blockPos);
					if (state.method_26164(ModTags.Blocks.MARKERS)) {
						//world.addParticleClient(new ItemStackParticleEffect(ModParticles.MARKER, stack), blockPos.getX() + 0.5, blockPos.getY() + 0.5, blockPos.getZ() + 0.5, 0, 0, 0);
						CurrencyEntity entity = new CurrencyEntity(ModEntities.Other.CURRENCY, world);
						entity.setStack(world.method_8320(blockPos).method_65171(world, blockPos, true));
						entity.method_5808(blockPos.method_10263() + 0.5, blockPos.method_10264() + 0.4, blockPos.method_10260() + 0.5, 0, 0);
						client.field_1713.method_3058(new MarkerParticle(client.method_1561(), (class_638) world, entity));

						/*float tickProgress = client.getRenderTickCounter().getTickProgress(!world.getTickManager().shouldSkipTick(entity));
						client.getEntityRenderDispatcher().render(entity, entity.lastRenderX, entity.lastRenderY, entity.lastRenderZ, tickProgress);*/

						entity.method_31472();
					}
				}
				break;
			}
		}
	}
}
