package net.db64.homelawnsecurity.mixin;

import net.db64.homelawnsecurity.block.ModBlocks;
import net.db64.homelawnsecurity.block.custom.lawn.ILawnBlock;
import net.db64.homelawnsecurity.block.custom.lawn.SoddedLawnBlockBlock;
import net.db64.homelawnsecurity.block.custom.lawn.SoddedLawnMarkerBlock;
import net.db64.homelawnsecurity.item.ModItems;
import net.minecraft.class_1269;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1820;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1820.class)
public abstract class ShearsItemMixin {
	@Inject(
		method = "Lnet/minecraft/item/ShearsItem;useOnBlock(Lnet/minecraft/item/ItemUsageContext;)Lnet/minecraft/util/ActionResult;",
		at = @At(
			value = "RETURN",
			ordinal = 1
		),
		cancellable = true
	)
	public void removeTurf(class_1838 context, CallbackInfoReturnable<class_1269> cir) {
		class_1937 world = context.method_8045();
		if (!world.method_8608()) {
			class_2338 pos = context.method_8037();
			class_2680 state = world.method_8320(pos);

			boolean turfRemoved = false;
			if (state.method_26204() instanceof SoddedLawnBlockBlock) {
				world.method_8501(pos, ModBlocks.UNSODDED_LAWN_BLOCK.method_9564()
					.method_11657(ILawnBlock.PATH_ID_MAIN, state.method_11654(ILawnBlock.PATH_ID_MAIN))
					.method_11657(ILawnBlock.PATH_ID_INTERSECTING, state.method_11654(ILawnBlock.PATH_ID_INTERSECTING))
				);
				turfRemoved = true;
			}
			else if (state.method_26204() instanceof SoddedLawnMarkerBlock) {
				world.method_8501(pos, ModBlocks.UNSODDED_LAWN_MARKER.method_9564()
					.method_11657(ILawnBlock.PATH_ID_MAIN, state.method_11654(ILawnBlock.PATH_ID_MAIN))
					.method_11657(ILawnBlock.PATH_ID_INTERSECTING, state.method_11654(ILawnBlock.PATH_ID_INTERSECTING))
				);
				turfRemoved = true;
			}

			if (turfRemoved) {
				world.method_45447(null, pos, state.method_26231().method_10595(), class_3419.field_15245);

				boolean creative = false;
				class_1657 user = context.method_8036();
				if (user != null) {
					context.method_8041().method_61653(1, user);
					creative = user.method_68878();
				}

				if (!creative) {
					class_243 itemPos = context.method_17698();
					class_1542 itemEntity = new class_1542(world, itemPos.field_1352, itemPos.field_1351, itemPos.field_1350, ModItems.TURF.method_7854().method_7972());
					class_5819 random = itemEntity.method_59922();
					itemEntity.method_18800(random.method_43057() * 0.1f - 0.05f, 0.1f, random.method_43057() * 0.1f - 0.05f);
					world.method_8649(itemEntity);
				}

				cir.setReturnValue(class_1269.field_52422);
			}
		}
	}
}
