package net.db64.homelawnsecurity.block;

import net.db64.homelawnsecurity.HomeLawnSecurity;
import net.db64.homelawnsecurity.block.custom.CurrencySpawnerBlock;
import net.db64.homelawnsecurity.block.custom.MarkerBlock;
import net.db64.homelawnsecurity.block.custom.lawn.SoddedLawnBlockBlock;
import net.db64.homelawnsecurity.block.custom.lawn.SoddedLawnMarkerBlock;
import net.db64.homelawnsecurity.block.custom.lawn.UnsoddedLawnBlockBlock;
import net.db64.homelawnsecurity.block.custom.lawn.UnsoddedLawnMarkerBlock;
import net.db64.homelawnsecurity.item.ModItems;
import net.minecraft.block.*;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.Function;

public class ModBlocks {
	public static final class_2248 GARDEN_BLOCK = register("garden_block", class_2248::new,
		class_4970.class_2251.method_55226(class_2246.field_28681), List.of(
			class_2561.method_43471("tooltip.block.homelawnsecurity.garden")));
	public static final class_2248 GRAVEYARD_BLOCK = register("graveyard_block", class_2248::new,
		class_4970.class_2251.method_55226(class_2246.field_28681), List.of(
			class_2561.method_43471("tooltip.block.homelawnsecurity.graveyard")));

	/*public static final Block LAWN_BLOCK = register("lawn_block", settings ->
		new Block(settings), AbstractBlock.Settings.copyShallow(Blocks.GRASS_BLOCK).sounds(BlockSoundGroup.WART_BLOCK), List.of(
			ModItems.OBSOLETE,
			Text.translatable("tooltip.block.homelawnsecurity.placement.allows"),
			Text.translatable("tooltip.block.homelawnsecurity.placement.lawn_plants"),
			Text.translatable("tooltip.block.homelawnsecurity.placement.path_plants")));

	public static final Block FERTILE_PATH_BLOCK_1 = register("fertile_path_block_1", settings ->
		new Block(settings), AbstractBlock.Settings.copyShallow(Blocks.GRASS_BLOCK).sounds(BlockSoundGroup.MUDDY_MANGROVE_ROOTS), List.of(
			ModItems.OBSOLETE,
			Text.translatable("tooltip.block.homelawnsecurity.placement.allows"),
			Text.translatable("tooltip.block.homelawnsecurity.placement.lawn_plants"),
			Text.translatable("tooltip.block.homelawnsecurity.placement.path_plants"),
			Text.translatable("tooltip.block.homelawnsecurity.placement.zombies")));
	public static final Block FERTILE_PATH_BLOCK_2 = register("fertile_path_block_2", settings ->
		new Block(settings), AbstractBlock.Settings.copyShallow(Blocks.GRASS_BLOCK).sounds(BlockSoundGroup.MUDDY_MANGROVE_ROOTS), List.of(
			ModItems.OBSOLETE,
			Text.translatable("tooltip.block.homelawnsecurity.placement.allows"),
			Text.translatable("tooltip.block.homelawnsecurity.placement.lawn_plants"),
			Text.translatable("tooltip.block.homelawnsecurity.placement.path_plants"),
			Text.translatable("tooltip.block.homelawnsecurity.placement.zombies")));
	public static final Block FERTILE_PATH_BLOCK_CROSS = register("fertile_path_block_cross", settings ->
		new Block(settings), AbstractBlock.Settings.copyShallow(Blocks.GRASS_BLOCK).sounds(BlockSoundGroup.MUDDY_MANGROVE_ROOTS), List.of(
			ModItems.OBSOLETE,
			Text.translatable("tooltip.block.homelawnsecurity.placement.allows"),
			Text.translatable("tooltip.block.homelawnsecurity.placement.lawn_plants"),
			Text.translatable("tooltip.block.homelawnsecurity.placement.path_plants"),
			Text.translatable("tooltip.block.homelawnsecurity.placement.zombies")));

	public static final Block ZOMBIE_PATH_BLOCK_1 = register("zombie_path_block_1", settings ->
		new Block(settings), AbstractBlock.Settings.copyShallow(Blocks.GRASS_BLOCK).sounds(BlockSoundGroup.ROOTED_DIRT), List.of(
			ModItems.OBSOLETE,
			Text.translatable("tooltip.block.homelawnsecurity.placement.allows"),
			Text.translatable("tooltip.block.homelawnsecurity.placement.path_plants"),
			Text.translatable("tooltip.block.homelawnsecurity.placement.zombies")));
	public static final Block ZOMBIE_PATH_BLOCK_2 = register("zombie_path_block_2", settings ->
		new Block(settings), AbstractBlock.Settings.copyShallow(Blocks.GRASS_BLOCK).sounds(BlockSoundGroup.ROOTED_DIRT), List.of(
			ModItems.OBSOLETE,
			Text.translatable("tooltip.block.homelawnsecurity.placement.allows"),
			Text.translatable("tooltip.block.homelawnsecurity.placement.path_plants"),
			Text.translatable("tooltip.block.homelawnsecurity.placement.zombies")));
	public static final Block ZOMBIE_PATH_BLOCK_CROSS = register("zombie_path_block_cross", settings ->
		new Block(settings), AbstractBlock.Settings.copyShallow(Blocks.GRASS_BLOCK).sounds(BlockSoundGroup.ROOTED_DIRT), List.of(
			ModItems.OBSOLETE,
			Text.translatable("tooltip.block.homelawnsecurity.placement.allows"),
			Text.translatable("tooltip.block.homelawnsecurity.placement.path_plants"),
			Text.translatable("tooltip.block.homelawnsecurity.placement.zombies")));

	public static final Block UNSODDED_LAWN_BLOCK = register("unsodded_lawn_block", settings ->
		new Block(settings), AbstractBlock.Settings.copyShallow(Blocks.DIRT).sounds(BlockSoundGroup.GRAVEL), List.of(
			ModItems.OBSOLETE,
			Text.translatable("tooltip.block.homelawnsecurity.placement.allows"),
			Text.translatable("tooltip.block.homelawnsecurity.placement.none")));*/

	public static final class_2248 SODDED_LAWN_BLOCK = register("sodded_lawn_block", SoddedLawnBlockBlock::new,
		class_4970.class_2251.method_55226(class_2246.field_10219).method_9626(class_2498.field_22144), List.of(
		class_2561.method_43471("tooltip.block.homelawnsecurity.lawn_block")));
	public static final class_2248 UNSODDED_LAWN_BLOCK = register("unsodded_lawn_block", UnsoddedLawnBlockBlock::new,
		class_4970.class_2251.method_55226(class_2246.field_10566).method_9626(class_2498.field_11529), List.of(
		class_2561.method_43471("tooltip.block.homelawnsecurity.lawn_block")));

	public static final class_2248 GARDEN_MARKER = register("garden_marker", MarkerBlock::new,
		class_4970.class_2251.method_9637().method_9626(class_2498.field_28697).method_9629(-1.0f, 3600000.8f).method_22488(), List.of(
		class_2561.method_43471("tooltip.block.homelawnsecurity.marker"),
		class_2561.method_43471("tooltip.block.homelawnsecurity.garden")));
	public static final class_2248 GRAVEYARD_MARKER = register("graveyard_marker", MarkerBlock::new,
		class_4970.class_2251.method_9637().method_9626(class_2498.field_28697).method_9629(-1.0f, 3600000.8f).method_22488(), List.of(
		class_2561.method_43471("tooltip.block.homelawnsecurity.marker"),
		class_2561.method_43471("tooltip.block.homelawnsecurity.graveyard")));

	/*public static final Block LAWN_MARKER = register("lawn_marker", settings ->
		new MarkerBlock(settings), AbstractBlock.Settings.create().sounds(BlockSoundGroup.NETHER_SPROUTS).strength(-1.0f, 3600000.8f).nonOpaque(), List.of(
		ModItems.OBSOLETE,
		Text.translatable("tooltip.block.homelawnsecurity.marker"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.allows"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.lawn_plants"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.path_plants")));

	public static final Block FERTILE_PATH_MARKER_1 = register("fertile_path_marker_1", settings ->
		new MarkerBlock(settings), AbstractBlock.Settings.create().sounds(BlockSoundGroup.HANGING_ROOTS).strength(-1.0f, 3600000.8f).nonOpaque(), List.of(
		ModItems.OBSOLETE,
		Text.translatable("tooltip.block.homelawnsecurity.marker"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.allows"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.lawn_plants"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.path_plants"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.zombies")));
	public static final Block FERTILE_PATH_MARKER_2 = register("fertile_path_marker_2", settings ->
		new MarkerBlock(settings), AbstractBlock.Settings.create().sounds(BlockSoundGroup.HANGING_ROOTS).strength(-1.0f, 3600000.8f).nonOpaque(), List.of(
		ModItems.OBSOLETE,
		Text.translatable("tooltip.block.homelawnsecurity.marker"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.allows"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.lawn_plants"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.path_plants"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.zombies")));
	public static final Block FERTILE_PATH_MARKER_CROSS = register("fertile_path_marker_cross", settings ->
		new MarkerBlock(settings), AbstractBlock.Settings.create().sounds(BlockSoundGroup.HANGING_ROOTS).strength(-1.0f, 3600000.8f).nonOpaque(), List.of(
		ModItems.OBSOLETE,
		Text.translatable("tooltip.block.homelawnsecurity.marker"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.allows"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.lawn_plants"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.path_plants"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.zombies")));

	public static final Block ZOMBIE_PATH_MARKER_1 = register("zombie_path_marker_1", settings ->
		new MarkerBlock(settings), AbstractBlock.Settings.create().sounds(BlockSoundGroup.HANGING_ROOTS).strength(-1.0f, 3600000.8f).nonOpaque(), List.of(
		ModItems.OBSOLETE,
		Text.translatable("tooltip.block.homelawnsecurity.marker"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.allows"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.path_plants"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.zombies")));
	public static final Block ZOMBIE_PATH_MARKER_2 = register("zombie_path_marker_2", settings ->
		new MarkerBlock(settings), AbstractBlock.Settings.create().sounds(BlockSoundGroup.HANGING_ROOTS).strength(-1.0f, 3600000.8f).nonOpaque(), List.of(
		ModItems.OBSOLETE,
		Text.translatable("tooltip.block.homelawnsecurity.marker"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.allows"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.path_plants"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.zombies")));
	public static final Block ZOMBIE_PATH_MARKER_CROSS = register("zombie_path_marker_cross", settings ->
		new MarkerBlock(settings), AbstractBlock.Settings.create().sounds(BlockSoundGroup.HANGING_ROOTS).strength(-1.0f, 3600000.8f).nonOpaque(), List.of(
		ModItems.OBSOLETE,
		Text.translatable("tooltip.block.homelawnsecurity.marker"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.allows"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.path_plants"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.zombies")));

	public static final Block UNSODDED_LAWN_MARKER = register("unsodded_lawn_marker", settings ->
		new MarkerBlock(settings), AbstractBlock.Settings.create().sounds(BlockSoundGroup.MUD).strength(-1.0f, 3600000.8f).nonOpaque(), List.of(
		ModItems.OBSOLETE,
		Text.translatable("tooltip.block.homelawnsecurity.marker"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.allows"),
		Text.translatable("tooltip.block.homelawnsecurity.placement.none")));*/

	public static final class_2248 SODDED_LAWN_MARKER = register("sodded_lawn_marker", SoddedLawnMarkerBlock::new,
		class_4970.class_2251.method_9637().method_9626(class_2498.field_22144).method_9629(-1.0f, 3600000.8f).method_22488(), List.of(
		class_2561.method_43471("tooltip.block.homelawnsecurity.marker"),
		class_2561.method_43471("tooltip.block.homelawnsecurity.lawn_block")));
	public static final class_2248 UNSODDED_LAWN_MARKER = register("unsodded_lawn_marker", UnsoddedLawnMarkerBlock::new,
		class_4970.class_2251.method_9637().method_9626(class_2498.field_37640).method_9629(-1.0f, 3600000.8f).method_22488(), List.of(
		class_2561.method_43471("tooltip.block.homelawnsecurity.marker"),
		class_2561.method_43471("tooltip.block.homelawnsecurity.lawn_block")));

	public static final class_2248 SUN_SPAWNER = register("sun_spawner", settings ->
		new CurrencySpawnerBlock(settings, new class_1799(ModItems.SUN)), class_4970.class_2251.method_55226(class_2246.field_10340).method_9626(class_2498.field_49834).method_22488(), List.of(
		class_2561.method_43471("tooltip.block.homelawnsecurity.sun_spawner")));
	public static final class_2248 BRAINPOWER_BEACON = register("brainpower_beacon", settings ->
		new CurrencySpawnerBlock(settings, new class_1799(ModItems.BRAINPOWER)), class_4970.class_2251.method_55226(class_2246.field_10340).method_9626(class_2498.field_49834).method_22488(), List.of(
		class_2561.method_43471("tooltip.block.homelawnsecurity.brainpower_beacon")));

	private static class_2248 register(String id, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings, boolean obtainable, List<class_2561> tooltip)
	{
		class_2248 block = class_2246.method_63053(keyOf(id), factory, settings);
		if (obtainable)
			ModItems.register(id, itemSettings -> new class_1747(block, itemSettings), new class_1792.class_1793().method_63685(), tooltip);
		return block;
	}

	private static class_2248 register(String id, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings, boolean obtainable)
	{
		return register(id, factory, settings, obtainable, null);
	}

	private static class_2248 register(String id, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
		return register(id, factory, settings, true);
	}

	private static class_2248 register(String id, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings, @Nullable List<class_2561> tooltip) {
		return register(id, factory, settings, true, tooltip);
	}

	/*private static Item registerBlockItem(String name, Block block) {
		return Registry.register(Registries.ITEM, RegistryKey.of(RegistryKeys.ITEM, Identifier.of(HomeLawnSecurity.MOD_ID, name)),
			new BlockItem(block, new Item.Settings()));
	}*/

	private static class_5321<class_2248> keyOf(String id) {
		return class_5321.method_29179(class_7924.field_41254, class_2960.method_60655(HomeLawnSecurity.MOD_ID, id));
	}

	public static void registerModBlocks() {
		HomeLawnSecurity.LOGGER.debug("Registering blocks for " + HomeLawnSecurity.MOD_ID);
	}

	public static class BlockSetTypes {
		//public static BlockSetType RUBBER_WOOD = new BlockSetType("rubber_wood", true, true, true, BlockSetType.ActivationRule.EVERYTHING, ModSounds.BlockSoundGroups.RUBBER_WOOD, ModSounds.RUBBERWOOD_DOOR_CLOSE, ModSounds.RUBBERWOOD_DOOR_OPEN, ModSounds.RUBBERWOOD_TRAPDOOR_CLOSE, ModSounds.RUBBERWOOD_TRAPDOOR_OPEN, ModSounds.RUBBERWOOD_PRESSURE_PLATE_CLICK_OFF, ModSounds.RUBBERWOOD_PRESSURE_PLATE_CLICK_ON, ModSounds.RUBBERWOOD_BUTTON_CLICK_OFF, ModSounds.RUBBERWOOD_BUTTON_CLICK_ON);
	}

	public static class WoodTypes {
		//public static WoodType RUBBER_WOOD = new WoodType("rubber_wood", BlockSetTypes.RUBBER_WOOD, ModSounds.BlockSoundGroups.RUBBER_WOOD, BlockSoundGroup.CHERRY_WOOD_HANGING_SIGN, ModSounds.RUBBERWOOD_FENCE_GATE_CLOSE, ModSounds.RUBBERWOOD_FENCE_GATE_OPEN);
	}
}
