package net.db64.homelawnsecurity.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record SeedPacketComponent(int cost, int cooldown) {
	public static final Codec<SeedPacketComponent> CODEC = RecordCodecBuilder.create(
		instance -> instance.group(
				class_5699.field_33441.fieldOf("cost").forGetter(SeedPacketComponent::cost),
				class_5699.field_33441.fieldOf("cooldown").forGetter(SeedPacketComponent::cooldown)
			)
			.apply(instance, SeedPacketComponent::new)
	);
	public static final class_9139<class_9129, SeedPacketComponent> PACKET_CODEC = class_9139.method_56435(
		class_9135.field_48550,
		SeedPacketComponent::cost,
		class_9135.field_48550,
		SeedPacketComponent::cooldown,
		SeedPacketComponent::new
	);

	public static class Builder {
		private int cost;
		private int cooldown;

		public SeedPacketComponent.Builder cost(int cost) {
			this.cost = cost;
			return this;
		}

		public SeedPacketComponent.Builder cooldown(int cooldown) {
			this.cooldown = cooldown;
			return this;
		}

		public SeedPacketComponent build() {
			return new SeedPacketComponent(this.cost, this.cooldown);
		}
	}
}
