package net.db64.homelawnsecurity.component;


import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;
import net.minecraft.class_9473;

public record TooltipComponent(List<class_2561> lines, List<class_2561> styledLines) implements class_9299 {
	public static final TooltipComponent DEFAULT = new TooltipComponent(List.of());
	public static final int MAX_TOOLTIPS = 256;
	private static final class_2583 STYLE;
	public static final Codec<TooltipComponent> CODEC;
	public static final class_9139<class_9129, TooltipComponent> PACKET_CODEC;

	public TooltipComponent(List<class_2561> lines) {
		this(lines, Lists.transform(lines, style -> class_2564.method_10889(style.method_27661(), STYLE)));
	}

	public TooltipComponent(List<class_2561> lines, List<class_2561> styledLines) {
		if (lines.size() > MAX_TOOLTIPS) {
			throw new IllegalArgumentException("Got " + lines.size() + " lines, but maximum is 256");
		} else {
			this.lines = lines;
			this.styledLines = styledLines;
		}
	}

	public TooltipComponent with(class_2561 line) {
		return new TooltipComponent(class_156.method_57108(this.lines, line));
	}

	@Override
	public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltip, class_1836 type, class_9473 components) {
		this.styledLines.forEach(tooltip);
	}

	static {
		STYLE = class_2583.field_24360.method_10977(class_124.field_1080);
		CODEC = class_8824.field_46597.sizeLimitedListOf(256).xmap(TooltipComponent::new, TooltipComponent::lines);
		PACKET_CODEC = class_8824.field_48540.method_56433(class_9135.method_58000(256)).method_56432(TooltipComponent::new, TooltipComponent::lines);
	}
}