package net.db64.homelawnsecurity.datagen;

import net.db64.homelawnsecurity.HomeLawnSecurity;
import net.db64.homelawnsecurity.block.ModBlocks;
import net.db64.homelawnsecurity.item.ModItems;
import net.db64.homelawnsecurity.util.ModTags;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2446;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_8790;
import java.util.concurrent.CompletableFuture;

public class ModRecipeProvider extends FabricRecipeProvider {
	//private static List<ItemConvertible> LIST_NAME = List.of(ModItems.RAW_BACON, ModBlocks.BACON_BLOCK, ModItems.LIVE_BABY);
	//private static List<ItemConvertible> RUBBER_LOGS = List.of(ModBlocks.RUBBER_LOG, ModBlocks.RUBBER_WOOD,
		//ModBlocks.STRIPPED_RUBBER_LOG, ModBlocks.STRIPPED_RUBBER_WOOD,
		//ModBlocks.DRIPPING_RUBBER_LOG, ModBlocks.DRIPPING_RUBBER_WOOD);

	public ModRecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
		super(output, registriesFuture);
	}

	@Override
	protected class_2446 method_62766(class_7225.class_7874 wrapperLookup, class_8790 recipeExporter) {
		return new class_2446(wrapperLookup, recipeExporter) {
			private final ModRecipeTemplates templates = new ModRecipeTemplates();

			@Override
			public void method_10419() {
				//offerSmelting(exporter, LIST_NAME, RecipeCategory.FOOD, ModItems.DOG_FOOD, 0.7f, 200, "dog_food");
				//offerSmokingUhhhh(exporter, LIST_NAME, RecipeCategory.FOOD, ModItems.DOG_FOOD, 0.7f, 100, "dog_food"); // Smoking isn't a default thing??

				// Turf
				method_62750(class_7800.field_40642, ModItems.TURF, 4)
					.method_10446(ModTags.Items.RECIPE_TURF_GRASS)
					.method_10446(ModTags.Items.RECIPE_TURF_GRASS)
					.method_10446(ModTags.Items.RECIPE_TURF_GRASS)
					.method_10446(ModTags.Items.RECIPE_TURF_GRASS)
					.method_10454(class_1802.field_8110)
					.method_10442("has_grass", method_10420(ModTags.Items.RECIPE_TURF_GRASS))
					.method_10431(field_53721);

				// Unsodded Lawn Block
				method_62747(class_7800.field_40642, ModBlocks.UNSODDED_LAWN_BLOCK, 4)
					.method_10433('d', ModTags.Items.RECIPE_GRASSLESS_DIRT)
					.method_10439("dd")
					.method_10439("dd")
					.method_10429("has_dirt", method_10420(ModTags.Items.RECIPE_GRASSLESS_DIRT))
					.method_10431(field_53721);

				// Sodded Lawn Block
				method_62750(class_7800.field_40642, ModBlocks.SODDED_LAWN_BLOCK, 1)
					.method_10454(ModItems.TURF)
					.method_10454(ModBlocks.UNSODDED_LAWN_BLOCK)
					.method_10442(method_32807(ModItems.TURF), method_10426(ModItems.TURF))
					.method_36443(field_53721, method_36450(ModBlocks.SODDED_LAWN_BLOCK) + "_from_" + method_33716(ModBlocks.UNSODDED_LAWN_BLOCK));

				// Sodded Lawn Block (Quick)
				method_62747(class_7800.field_40642, ModBlocks.SODDED_LAWN_BLOCK, 4)
					.method_10433('d', ModTags.Items.RECIPE_GRASSLESS_DIRT)
					.method_10434('t', ModItems.TURF)
					.method_10439("tt ")
					.method_10439("ddt") // Dark Dirigible Titan reference??
					.method_10439("ddt")
					.method_10429("has_dirt", method_10420(ModTags.Items.RECIPE_GRASSLESS_DIRT))
					.method_36443(field_53721, method_36450(ModBlocks.SODDED_LAWN_BLOCK) + "_from_" + method_33716(class_1802.field_8831));

				// Sodded Lawn Marker
				method_62750(class_7800.field_40642, ModBlocks.SODDED_LAWN_MARKER, 1)
					.method_10454(ModItems.TURF)
					.method_10454(ModBlocks.UNSODDED_LAWN_MARKER)
					.method_10442(method_32807(ModItems.TURF), method_10426(ModItems.TURF))
					.method_36443(field_53721, method_36450(ModBlocks.SODDED_LAWN_MARKER) + "_from_" + method_33716(ModBlocks.UNSODDED_LAWN_MARKER));

				// Garden Block
				method_62750(class_7800.field_40642, ModBlocks.GARDEN_BLOCK, 1)
					.method_10454(ModBlocks.SODDED_LAWN_BLOCK)
					.method_10446(class_3489.field_15543)
					.method_10442(method_32807(ModBlocks.SODDED_LAWN_BLOCK), method_10426(ModBlocks.SODDED_LAWN_BLOCK))
					.method_36443(field_53721, method_36450(ModBlocks.GARDEN_BLOCK) + "_from_" + method_33716(ModBlocks.SODDED_LAWN_BLOCK));

				// Garden Block (Quick)
				method_62750(class_7800.field_40642, ModBlocks.GARDEN_BLOCK, 1)
					.method_10454(ModBlocks.UNSODDED_LAWN_BLOCK)
					.method_10454(ModItems.TURF)
					.method_10446(class_3489.field_15543)
					.method_10442(method_32807(ModBlocks.UNSODDED_LAWN_BLOCK), method_10426(ModBlocks.UNSODDED_LAWN_BLOCK))
					.method_36443(field_53721, method_36450(ModBlocks.GARDEN_BLOCK) + "_from_" + method_33716(ModBlocks.UNSODDED_LAWN_BLOCK));

				// Graveyard Block
				method_62750(class_7800.field_40642, ModBlocks.GRAVEYARD_BLOCK, 1)
					.method_10454(class_1802.field_8711)
					.method_10454(ModBlocks.GARDEN_BLOCK)
					.method_10442(method_32807(ModBlocks.GARDEN_BLOCK), method_10426(ModBlocks.GARDEN_BLOCK))
					.method_36443(field_53721, method_36450(ModBlocks.GRAVEYARD_BLOCK) + "_from_" + method_33716(ModBlocks.GARDEN_BLOCK));

				// Graveyard Block (Quick)
				method_62750(class_7800.field_40642, ModBlocks.GRAVEYARD_BLOCK, 1)
					.method_10454(ModBlocks.SODDED_LAWN_BLOCK)
					.method_10446(class_3489.field_15543)
					.method_10454(class_1802.field_8711)
					.method_10442(method_32807(ModBlocks.SODDED_LAWN_BLOCK), method_10426(ModBlocks.SODDED_LAWN_BLOCK))
					.method_36443(field_53721, method_36450(ModBlocks.GRAVEYARD_BLOCK) + "_from_" + method_33716(ModBlocks.SODDED_LAWN_BLOCK));

				// Graveyard Block (Quicker)
				method_62750(class_7800.field_40642, ModBlocks.GRAVEYARD_BLOCK, 1)
					.method_10454(ModItems.TURF)
					.method_10454(ModBlocks.UNSODDED_LAWN_BLOCK)
					.method_10446(class_3489.field_15543)
					.method_10454(class_1802.field_8711)
					.method_10442(method_32807(ModItems.TURF), method_10426(ModItems.TURF))
					.method_36443(field_53721, method_36450(ModBlocks.GRAVEYARD_BLOCK) + "_from_" + method_33716(ModBlocks.UNSODDED_LAWN_BLOCK));

				// Garden Marker
				method_62750(class_7800.field_40642, ModBlocks.GARDEN_MARKER, 1)
					.method_10454(ModBlocks.SODDED_LAWN_MARKER)
					.method_10446(class_3489.field_15543)
					.method_10442(method_32807(ModBlocks.SODDED_LAWN_MARKER), method_10426(ModBlocks.SODDED_LAWN_MARKER))
					.method_36443(field_53721, method_36450(ModBlocks.GARDEN_MARKER) + "_from_" + method_33716(ModBlocks.SODDED_LAWN_MARKER));

				// Garden Marker (Quick)
				method_62750(class_7800.field_40642, ModBlocks.GARDEN_MARKER, 1)
					.method_10454(ModBlocks.UNSODDED_LAWN_MARKER)
					.method_10454(ModItems.TURF)
					.method_10446(class_3489.field_15543)
					.method_10442(method_32807(ModBlocks.UNSODDED_LAWN_MARKER), method_10426(ModBlocks.UNSODDED_LAWN_MARKER))
					.method_36443(field_53721, method_36450(ModBlocks.GARDEN_MARKER) + "_from_" + method_33716(ModBlocks.UNSODDED_LAWN_MARKER));

				// Graveyard Marker
				method_62750(class_7800.field_40642, ModBlocks.GRAVEYARD_MARKER, 1)
					.method_10454(class_1802.field_8711)
					.method_10454(ModBlocks.GARDEN_MARKER)
					.method_10442(method_32807(ModBlocks.GARDEN_MARKER), method_10426(ModBlocks.GARDEN_MARKER))
					.method_36443(field_53721, method_36450(ModBlocks.GRAVEYARD_MARKER) + "_from_" + method_33716(ModBlocks.GARDEN_MARKER));

				// Graveyard Marker (Quick)
				method_62750(class_7800.field_40642, ModBlocks.GRAVEYARD_MARKER, 1)
					.method_10454(ModBlocks.SODDED_LAWN_MARKER)
					.method_10446(class_3489.field_15543)
					.method_10454(class_1802.field_8711)
					.method_10442(method_32807(ModBlocks.SODDED_LAWN_MARKER), method_10426(ModBlocks.SODDED_LAWN_MARKER))
					.method_36443(field_53721, method_36450(ModBlocks.GRAVEYARD_MARKER) + "_from_" + method_33716(ModBlocks.SODDED_LAWN_MARKER));

				// Graveyard Marker (Quicker)
				method_62750(class_7800.field_40642, ModBlocks.GRAVEYARD_MARKER, 1)
					.method_10454(ModItems.TURF)
					.method_10454(ModBlocks.UNSODDED_LAWN_MARKER)
					.method_10446(class_3489.field_15543)
					.method_10454(class_1802.field_8711)
					.method_10442(method_32807(ModItems.TURF), method_10426(ModItems.TURF))
					.method_36443(field_53721, method_36450(ModBlocks.GRAVEYARD_MARKER) + "_from_" + method_33716(ModBlocks.UNSODDED_LAWN_MARKER));

				// Lawn Mower
				method_62750(class_7800.field_40642, ModItems.LAWN_MOWER, 1)
					.method_10454(class_1802.field_8620)
					.method_10454(class_1802.field_8264)
					.method_10446(class_3489.field_25808)
					.method_10446(class_3489.field_17487)
					.method_10442(method_32807(class_1802.field_8620), method_10426(class_1802.field_8620))
					.method_36443(field_53721, method_36450(ModItems.LAWN_MOWER));

				// Shovel
				method_62747(class_7800.field_40642, ModItems.SHOVEL, 1)
					.method_10434('i', class_1802.field_8620)
					.method_10434('d', class_1802.field_8264)
					.method_10434('s', class_1802.field_8600)
					.method_10434('n', class_1802.field_8675)
					.method_10439("i ")
					.method_10439("s ")
					.method_10439("nd")
					.method_10429(method_32807(class_1802.field_8620), method_10426(class_1802.field_8620))
					.method_36443(field_53721, method_36450(ModItems.SHOVEL));

				// Lawn Gadget
				method_62747(class_7800.field_40642, ModItems.LAWN_GADGET, 1)
					.method_10434('i', class_1802.field_8620)
					.method_10434('d', class_1802.field_8264)
					.method_10434('n', class_1802.field_8675)
					.method_10439("n n")
					.method_10439("ndn")
					.method_10439(" i ")
					.method_10429(method_32807(class_1802.field_8620), method_10426(class_1802.field_8620))
					.method_36443(field_53721, method_36450(ModItems.LAWN_GADGET));

				// Sun Spawner
				method_62747(class_7800.field_40642, ModBlocks.SUN_SPAWNER, 1)
					.method_10434('g', class_1802.field_8280)
					.method_10434('i', class_1802.field_8620)
					.method_10434('b', class_1802.field_8324)
					.method_10439("bbb")
					.method_10439("bgb")
					.method_10439("bib")
					.method_10429(method_32807(class_1802.field_8620), method_10426(class_1802.field_8620))
					.method_36443(field_53721, method_36450(ModBlocks.SUN_SPAWNER));

				// Brainpower Beacon
				method_62747(class_7800.field_40642, ModBlocks.BRAINPOWER_BEACON, 1)
					.method_10434('g', class_1802.field_8280)
					.method_10434('i', class_1802.field_8620)
					.method_10434('b', ModItems.BRAIN)
					.method_10439("bbb")
					.method_10439("bgb")
					.method_10439("bib")
					.method_10429(method_32807(class_1802.field_8620), method_10426(class_1802.field_8620))
					.method_36443(field_53721, method_36450(ModBlocks.BRAINPOWER_BEACON));

				// Bag of Sun
				method_62750(class_7800.field_40642, ModItems.BAG_OF_SUN, 1)
					.method_10454(class_1802.field_8745)
					.method_10454(class_1802.field_8324)
					.method_10442(method_32807(class_1802.field_8745), method_10426(class_1802.field_8745))
					.method_36443(field_53721, method_36450(ModItems.BAG_OF_SUN));

				// Bag of Brainpower
				method_62750(class_7800.field_40642, ModItems.BAG_OF_BRAINPOWER, 1)
					.method_10454(class_1802.field_8745)
					.method_10454(ModItems.BRAIN)
					.method_10442(method_32807(class_1802.field_8745), method_10426(class_1802.field_8745))
					.method_36443(field_53721, method_36450(ModItems.BAG_OF_BRAINPOWER));

				// Target
				method_62750(class_7800.field_40642, ModItems.TARGET, 1)
					.method_10446(class_3489.field_15537)
					.method_10454(class_1802.field_8446)
					.method_10454(class_1802.field_8264)
					.method_10442("has_planks", method_10420(class_3489.field_15537))
					.method_36443(field_53721, method_36450(ModItems.TARGET));

				/*// Rubber wood set
				templates.makeWoodType(exporter, new Item[][] {{ModBlocks.RUBBER_LOG.asItem(), ModBlocks.RUBBER_WOOD.asItem()},
					{ModBlocks.STRIPPED_RUBBER_LOG.asItem(), ModBlocks.STRIPPED_RUBBER_WOOD.asItem()},
					{ModBlocks.DRIPPING_RUBBER_LOG.asItem(), ModBlocks.DRIPPING_RUBBER_WOOD.asItem()}},
					ModTags.Items.RUBBER_LOGS, ModBlocks.RUBBERWOOD_PLANKS.asItem(),
					ModBlocks.RUBBERWOOD_STAIRS.asItem(), ModBlocks.RUBBERWOOD_SLAB.asItem(),
					ModBlocks.RUBBERWOOD_FENCE.asItem(), ModBlocks.RUBBERWOOD_FENCE_GATE.asItem(),
					ModBlocks.RUBBERWOOD_DOOR.asItem(), ModBlocks.RUBBERWOOD_TRAPDOOR.asItem(),
					ModBlocks.RUBBERWOOD_PRESSURE_PLATE.asItem(), ModBlocks.RUBBERWOOD_BUTTON.asItem());*/
			}

			private class ModRecipeTemplates {
				public ModRecipeTemplates() {} // Why do datagen providers need to be created like you would need multiple of the same type????

				private void makeWoodType(class_8790 exporter, class_1792[][] logToWood, class_6862<class_1792> logTag, class_1792 planks, class_1792 stairs, class_1792 slab, class_1792 fence, class_1792 fenceGate, class_1792 door, class_1792 trapdoor, class_1792 pressurePlate, class_1792 button) {
					for (class_1792[] items : logToWood) {
						makeBark(exporter, items[1], items[0]); // logToWood is formatted like {{log, wood}, {strippedLog, strippedWood}}
					}

					method_24477(planks, logTag, 4);

					makeStairs(exporter, stairs, planks);
					method_32814(class_7800.field_40634, slab, planks);

					makeWoodenFence(exporter, fence, planks);
					makeWoodenFenceGate(exporter, fenceGate, planks);

					makeDoor(exporter, door, planks);
					makeTrapdoor(exporter, trapdoor, planks);

					method_32813(pressurePlate, planks);
					makeButton(exporter, button, planks);
				}

				private void makeBark(class_8790 exporter, class_1792 output, class_1792 input) {
					method_62747(class_7800.field_40634, output, 4)
						.method_10439("##")
						.method_10439("##")
						.method_10434('#', input)
						.method_10429(method_32807(input), method_10426(input))
						.method_36443(exporter, method_36450(output));
				}

				private void makeStairs(class_8790 exporter, class_1792 output, class_1792 input) {
					method_62747(class_7800.field_40634, output, 4)
						.method_10439("#  ")
						.method_10439("## ")
						.method_10439("###")
						.method_10434('#', input)
						.method_10429(method_32807(input), method_10426(input))
						.method_36443(exporter, method_36450(output));
				}

				private void makeFence(class_8790 exporter, class_1792 output, class_1792 input, class_1792 stick, int count, String group) {
					method_62747(class_7800.field_40635, output, count)
						.method_10439("W#W")
						.method_10439("W#W")
						.method_10434('W', input)
						.method_10434('#', stick)
						.method_10429(method_32807(input), method_10426(input))
						.method_10435(group)
						.method_36443(exporter, method_36450(output));
				}

				private void makeWoodenFence(class_8790 exporter, class_1792 output, class_1792 input) {
					makeFence(exporter, output, input, class_1802.field_8600, 3, "wooden_fence");
				}

				private void makeFenceGate(class_8790 exporter, class_1792 output, class_1792 input, class_1792 stick, int count, String group) {
					method_62747(class_7800.field_40636, output, count)
						.method_10439("#W#")
						.method_10439("#W#")
						.method_10434('W', input)
						.method_10434('#', stick)
						.method_10429(method_32807(input), method_10426(input))
						.method_10435(group)
						.method_36443(exporter, method_36450(output));
				}

				private void makeWoodenFenceGate(class_8790 exporter, class_1792 output, class_1792 input) {
					makeFenceGate(exporter, output, input, class_1802.field_8600, 1, "wooden_fence_gate");
				}

				private void makeDoor(class_8790 exporter, class_1792 output, class_1792 input) {
					method_62747(class_7800.field_40636, output, 3)
						.method_10439("##")
						.method_10439("##")
						.method_10439("##")
						.method_10434('#', input)
						.method_10429(method_32807(input), method_10426(input))
						.method_36443(exporter, method_36450(output));
				}

				private void makeTrapdoor(class_8790 exporter, class_1792 output, class_1792 input) {
					method_62747(class_7800.field_40636, output, 2)
						.method_10439("###")
						.method_10439("###")
						.method_10434('#', input)
						.method_10429(method_32807(input), method_10426(input))
						.method_36443(exporter, method_36450(output));
				}

				private void makeButton(class_8790 exporter, class_1792 output, class_1792 input) {
					method_62750(class_7800.field_40636, output, 1)
						.method_10454(input)
						.method_10442(method_32807(input), method_10426(input))
						.method_36443(exporter, method_36450(output));
				}
			}
		};
	}

	@Override
	public String method_10321() {
		return "Recipe Provider from " + HomeLawnSecurity.MOD_ID;
	}
}
