package net.db64.homelawnsecurity.entity.ai.plant;

import net.db64.homelawnsecurity.entity.custom.IPathBoundEntity;
import net.db64.homelawnsecurity.entity.custom.PlantEntity;
import net.db64.homelawnsecurity.entity.custom.ZombieEntity;
import net.db64.homelawnsecurity.entity.custom.other.TargetZombieEntity;
import net.db64.homelawnsecurity.util.LawnUtil;
import net.minecraft.class_11;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1400;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4051;
import org.jetbrains.annotations.Nullable;

import java.util.function.Predicate;

public class PlantTargetGoal<T extends class_1309> extends class_1400<T> {
	public float attackRange;
	public float attackRangePath;

	public Predicate<class_1309> rangePredicate = entity -> {
		// Cubic attack range for a tile-based game

		float range = ((PlantEntity) field_6660).onPath ? attackRangePath : attackRange;

		/*HomeLawnSecurity.LOGGER.info("range: {}, in range: {}", range, (Math.abs(mob.getBlockX() - entity.getBlockX()) <= range)
			&& (Math.abs(mob.getBlockY() - entity.getBlockY()) <= range)
			&& (Math.abs(mob.getBlockZ() - entity.getBlockZ()) <= range));*/

		return (Math.abs(field_6660.method_31477() - entity.method_31477()) <= range)
			&& (Math.abs(field_6660.method_31478() - entity.method_31478()) <= range)
			&& (Math.abs(field_6660.method_31479() - entity.method_31479()) <= range);
	};

	public Predicate<class_1309> intersectionPredicate = entity -> {
		boolean result = false;

		for (int i = 1; i <= 2; i++) {
			int mainPathId = LawnUtil.getMainPathId(entity.method_24515(), entity.method_73183());
			int intersectingPathId = LawnUtil.getIntersectingPathId(entity.method_24515(), entity.method_73183());
			//int pathId = i == 1 ? mainPathId : intersectingPathId;
			int otherPathId = i == 1 ? intersectingPathId : mainPathId;

			// Find paths to the enemy and to the goal
			class_11 targetPath = field_6660.method_5942().method_6349(entity, 1);
			class_11 goalPath = findGoalPath();
			if (targetPath == null || goalPath == null) {
				((PlantEntity) field_6660).setPathId(otherPathId);
				continue;
			}
			//HomeLawnSecurity.LOGGER.info("targetPath: {}, goalPath: {}", targetPath, goalPath);

			// Get the position of the enemy
			class_2338 targetPos = targetPath.method_48();
			//HomeLawnSecurity.LOGGER.info("targetPos: {}", targetPos.toString());

			// Go through the goal path and see if the enemy is in front or not
			if (goalPath.method_48().equals(entity.method_24515())) return true; // *tells predicate to return true if the pos at the end of the path to the enemy is the same as the enemy's pos* "Why is it ignoring the pathfinding part of the predicate?" -Me, apparently
			for (int j = 0; j < goalPath.method_38(); j++) {
				//HomeLawnSecurity.LOGGER.info("checking for if goalPath has position {} at node #{}", targetPos.toShortString(), j);
				if (goalPath.method_40(j).method_22879().equals(targetPos)) {
					//HomeLawnSecurity.LOGGER.info("goalPath does share a node position with targetPos");

					result = true;
				}
			}
			//HomeLawnSecurity.LOGGER.info("goalPath did not share a node position with targetPos");

			// We switch the path because we need to trick the pathfinding into looking down the other path
			// And we do it in such a way that it triggers exactly twice
			((PlantEntity) field_6660).setPathId(otherPathId);
		}

		return result;
	};

	public Predicate<class_1309> pathPredicate = entity -> {
		// If it was planted on a path, it should only target entities that are between it and its goal

		//HomeLawnSecurity.LOGGER.info("checking pathPredicate");

		if (field_6660 instanceof PlantEntity plant && !plant.onPath) {
			// This plant is not on a path, behave as such
			return !(entity instanceof TargetZombieEntity);
		}

		if (LawnUtil.getIntersectingPathId(entity.method_24515().method_10074(), entity.method_73183()) != 0)
			// This plant needs to target entities on both paths, redirect them to a different predicate
			return intersectionPredicate.test(entity);

		if (!(entity instanceof IPathBoundEntity) || ((IPathBoundEntity) field_6660).getPathId() != ((IPathBoundEntity) entity).getPathId())
			// It's on a different path, the enemy is of no concern
			return false;
		//HomeLawnSecurity.LOGGER.info("pathTag of mob ({}) is the same as pathTag of entity ({})", ((IPathBoundEntity) mob).getPathTagNbt(), ((IPathBoundEntity) entity).getPathTagNbt());

		// Find paths to the enemy and to the goal
		class_11 targetPath = field_6660.method_5942().method_6349(entity, 1);
		class_11 goalPath = findGoalPath();
		if (targetPath == null || goalPath == null) return false;
		//HomeLawnSecurity.LOGGER.info("targetPath: {}, goalPath: {}", targetPath, goalPath);

		// Get the position of the enemy
		class_2338 targetPos = targetPath.method_48();
		//HomeLawnSecurity.LOGGER.info("targetPos: {}", targetPos.toString());

		// Go through the goal path and see if the enemy is in front or not
		if (goalPath.method_48().equals(entity.method_24515())) return true; // *tells predicate to return true if the pos at the end of the path to the enemy is the same as the enemy's pos* "Why is it ignoring the pathfinding part of the predicate?" -Me, apparently
		for (int i = 0; i < goalPath.method_38(); i++) {
			//HomeLawnSecurity.LOGGER.info("checking for if goalPath has position {} at node #{}", targetPos.toShortString(), i);
			if (goalPath.method_40(i).method_22879().equals(targetPos)) {
				//HomeLawnSecurity.LOGGER.info("goalPath does share a node position with targetPos");
				return true;
			}
		}
		//HomeLawnSecurity.LOGGER.info("goalPath did not share a node position with targetPos");
		return false;
	};

	public PlantTargetGoal(class_1308 mob, Class<T> targetClass, boolean checkVisibility, float attackRange, float attackRangePath) {
		super(mob, targetClass, checkVisibility);
		this.attackRange = attackRange;
		this.attackRangePath = attackRangePath;
	}

	@Override
	protected double method_6326() {
		if (((PlantEntity) field_6660).onPath) {
			return this.attackRangePath * 1.42;
		}

		return this.attackRange * 1.42; // Just barely enough to fill the cube
	}

	protected class_238 method_6321(double distance) {
		float range = ((PlantEntity) field_6660).onPath ? attackRangePath : attackRange;

		return new class_238(field_6660.method_23317() - range, field_6660.method_23318() - range, field_6660.method_23321() - range,
			field_6660.method_23317() + range, field_6660.method_23318() + range, field_6660.method_23321() + range);
	}

	@Override
	public boolean method_6266() {
		//HomeLawnSecurity.LOGGER.info("target: " + target + ", targetEntity: " + targetEntity);
		/*if (((PlantEntity) mob).onPath) {
			return (targetEntity == null || rangePredicate.test(targetEntity))
				&& super.shouldContinue()
				&& pathPredicate.test(targetEntity);
		}*/

		if (field_6644 != null && (!rangePredicate.test(field_6644) || !pathPredicate.test(field_6644)))
			field_6660.method_5980(null);
		return (field_6644 == null || rangePredicate.test(field_6644) && pathPredicate.test(field_6644))
			&& super.method_6266();
	}

	@Override
	public boolean method_6264() {
		/*if (((PlantEntity) mob).onPath) {
			return super.canStart() && rangePredicate.test(targetEntity) && pathPredicate.test(targetEntity);
		}

		return super.canStart() && rangePredicate.test(targetEntity);*/

		return super.method_6264();
	}

	@Override
	protected boolean method_6328(@Nullable class_1309 target, class_4051 targetPredicate) {
		return super.method_6328(target, targetPredicate) && rangePredicate.test(target) && pathPredicate.test(target);
	}

	protected void method_18415() {
		class_3218 serverWorld = method_64451(this.field_6660);
		if (this.field_6643 != class_1657.class && this.field_6643 != class_3222.class) {
			this.field_6644 = serverWorld.method_64393(
				this.field_6660.method_73183().method_8390(this.field_6643, this.method_6321(this.method_6326()),
					livingEntity -> rangePredicate.test(livingEntity) && pathPredicate.test(livingEntity)),
				this.method_61438(),
				this.field_6660,
				this.field_6660.method_23317(),
				this.field_6660.method_23320(),
				this.field_6660.method_23321()
			);
		} else {
			this.field_6644 = serverWorld.method_64389(this.method_61438(), this.field_6660, this.field_6660.method_23317(), this.field_6660.method_23320(), this.field_6660.method_23321());
		}
	}

	private class_4051 method_61438() {
		return this.field_6642.method_18418(this.method_6326());
	}

	@Nullable
	private class_11 findGoalPath() {
		int rangeH = 16;
		int rangeV = 5;
		Iterable<class_2338> iterable = class_2338.method_25996(field_6660.method_23312().method_10084(), rangeH, rangeV, rangeH);
		for (class_2338 blockPos : iterable) {
			//HomeLawnSecurity.LOGGER.info("plant is checking for if the block at {}, {}, {} is a goal", blockPos.getX(), blockPos.getY(), blockPos.getZ());
			if (!((IPathBoundEntity) field_6660).isGoal(blockPos.method_10074())) continue;
			//HomeLawnSecurity.LOGGER.info("plant is checking for if the goal at {}, {}, {} is reachable", blockPos.getX(), blockPos.getY(), blockPos.getZ());
			class_11 path = field_6660.method_5942().method_6348(blockPos, 1);
			if (path == null) continue;
			//HomeLawnSecurity.LOGGER.info("plant has decided the goal at {}, {}, {} is reachable", blockPos.getX(), blockPos.getY(), blockPos.getZ());
			return path;
		}
		return null;
	}
}
