package net.db64.homelawnsecurity.entity.custom;

import net.db64.homelawnsecurity.component.ModDataComponentTypes;
import net.db64.homelawnsecurity.item.custom.LawnSeedPacketItem;
import net.db64.homelawnsecurity.item.custom.PathSeedPacketItem;
import net.db64.homelawnsecurity.item.custom.SeedPacketItem;
import net.db64.homelawnsecurity.sound.ModSounds;
import net.db64.homelawnsecurity.util.LawnUtil;
import net.db64.homelawnsecurity.util.ModTags;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_7094;
import net.minecraft.entity.*;
import org.jetbrains.annotations.Nullable;

public abstract class PlantEntity extends SeedPlacedEntity {
	//private abstract static final TrackedData<Boolean> USING_ATTACK =
		//DataTracker.registerData(PlantEntityClassHere.class, TrackedDataHandlerRegistry.BOOLEAN);

	/*@Deprecated
	public TagKey<Block> pathTag = ModTags.Blocks.ZOMBIE_PATH_1;
	@Deprecated
	public TagKey<Block> pathMarkerTag = ModTags.Blocks.ZOMBIE_PATH_1_MARKERS;*/

	public final class_7094 attackAnimationState = new class_7094();
	public int attackAnimationTimeout = 0;
	public int maxAttackAnimationTimeout = 10;
	public int attackTimeout = 0;

	public boolean onPath;
	public int intersectingPath = 0;

	/*
		GENERAL
	 */

	protected PlantEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
		super(entityType, world);
	}

	@Nullable
	@Override
	public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
		class_1315 result = super.method_5943(world, difficulty, spawnReason, entityData);

		class_2338 pos = method_23312();

		// Where was this planted?
		onPath = false;

		if (LawnUtil.isAnyPath(pos, method_73183())) { // It's some kind of path
			onPath = true;

			intersectingPath = LawnUtil.getIntersectingPathId(pos, method_73183()); // It's two paths in one block! Intersection plants should target both lanes
		}

		return result;
	}

	@Override
	public void method_5773() {
		super.method_5773();

		if (this.method_73183().method_8608()) {
			updateAnimations();
		}
		else {
			if (attackTimeout > 0) {
				--this.attackTimeout;
			}

			if (attackTimeout <= 0) {
				setUsingAttack(false);
			}
		}
	}

	@Override
	public void method_6005(double strength, double x, double z) {
		// ahaha--*snap*

		if (method_6065() != null && method_6065().method_6047().method_57826(ModDataComponentTypes.SHOVEL)) {
			super.method_6005(strength * 3, x, z);
		}
	}

	@Override
	public boolean method_64397(class_3218 world, class_1282 source, float amount) {
		class_1297 attacker = source.method_5529();
		if (attacker instanceof class_1309 && ((class_1309) attacker).method_6047().method_57826(ModDataComponentTypes.SHOVEL)) {
			world.method_8396(this, method_24515(), ModSounds.RANDOM_SHOVEL_ATTACK, attacker.method_5634(), 0.5f, 1);
			return super.method_64397(world, source, 1000000);
		}
		else if (attacker instanceof IPvzEntity) {
			//boolean damaged = super.damage(world, source, amount);

			this.field_6235 = 0;
			this.field_6008 = 0;

			//return damaged;
		}
		//return super.damage(world, source, amount * 10);
		return super.method_64397(world, source, amount);
	}

	@Override
	protected class_1269 method_5992(class_1657 player, class_1268 hand) {
		class_1269 result = super.method_5992(player, hand);

		if (player.method_5998(hand).method_57826(ModDataComponentTypes.SHOVEL)) {
			class_1937 world = method_73183();
			if (world.method_8608()) {
				for (int i = 0; i < 5; i++) {
					world.method_8466(new class_2388(class_2398.field_11217, method_25936()), false, true, method_23317(), method_23318(), method_23321(), 0, 0, 0);
				}
				world.method_8486(method_23317(), method_23318(), method_23321(), ModSounds.ENTITY_PLANT_SHOVEL, class_3419.field_15254, 1, 1, false);
			}
			else {
				dropSpawnItemOnDeath();
				method_31472();
			}

			result = class_1269.field_5812;
		}

		return result;
	}

	@Override
	public void method_5652(class_11372 view) {
		super.method_5652(view);

		/*if (pathTag == ModTags.Blocks.ZOMBIE_PATH_2)
			view.putInt("path_tag", 2);
		else
			view.putInt("path_tag", 1);*/

		view.method_71472("on_path", onPath);
		view.method_71465("intersecting_path", intersectingPath);
	}

	@Override
	public void method_5749(class_11368 view) {
		super.method_5749(view);

		/*// path_tag
		int path = view.getInt("path_tag", 1);
		if (path == 2) {
			pathTag = ModTags.Blocks.ZOMBIE_PATH_2;
			pathMarkerTag = ModTags.Blocks.ZOMBIE_PATH_2_MARKERS;
		} else {
			pathTag = ModTags.Blocks.ZOMBIE_PATH_1;
			pathMarkerTag = ModTags.Blocks.ZOMBIE_PATH_1_MARKERS;
		}*/

		onPath = view.method_71433("on_path", false);

		intersectingPath = view.method_71424("intersecting_path", 0);
	}

	/*
		ANIMATIONS
	 */

	protected void updateAnimations() {
		if (this.isUsingAttack()) {
			attackAnimationTimeout = maxAttackAnimationTimeout;
			if (!attackAnimationState.method_41327()) {
				attackAnimationState.method_41322(this.field_6012);
			}
		}
		else if (attackAnimationTimeout > 0) {
			--this.attackAnimationTimeout;
		}

		if (attackAnimationTimeout <= 0) {
			attackAnimationState.method_41325();
		}
	}

	public abstract class_2940<Boolean> getUsingAttackTrackedData();

	public void setUsingAttack(boolean attacking) {
		this.field_6011.method_12778(getUsingAttackTrackedData(), attacking);
	}

	public boolean isUsingAttack() {
		return this.field_6011.method_12789(getUsingAttackTrackedData());
	}

	@Override
	protected void method_5693(class_2945.class_9222 builder) {
		super.method_5693(builder);
		builder.method_56912(getUsingAttackTrackedData(), false);
	}

	/*
		BLOCKS
	 */

	public boolean isWalkable(class_2338 pos) {
		return LawnUtil.isWalkable(pos, method_73183(), pathId, false);
	}

	/**
	 * @return Whether a lawn plant can be placed on top of this block.
	 */
	public static boolean isPlaceableLawn(class_2338 pos, class_1937 world) {
		return LawnUtil.hasTurf(pos, world);
	}

	/**
	 * @return Whether a path plant can be placed on top of this block.
	 */
	public static boolean isPlaceablePath(class_2338 pos, class_1937 world) {
		return LawnUtil.isAnyPath(pos, world);
	}

	/**
	 * @return Whether this kind of seed packet can be placed on top of this block.
	 */
	public static boolean isPlaceable(class_2338 pos, class_1937 world, SeedPacketItem item) {
		if (item instanceof LawnSeedPacketItem) {
			//HomeLawnSecurity.LOGGER.info(item.getClass() + " has a lawn plant");
			return isPlaceableLawn(pos, world);
		}
		else if (item instanceof PathSeedPacketItem) {
			//HomeLawnSecurity.LOGGER.info(item.getClass() + " has a path plant");
			return isPlaceablePath(pos, world);
		}
		//HomeLawnSecurity.LOGGER.info(item.getClass() + " has an idiot plant");
		return false;
	}

	/**
	 * @return Whether this block is a lawn mower goal.
	 */
	public boolean isGoal(class_2338 pos) {
		class_1937 world = method_73183();
		class_2680 state = world.method_8320(pos);
		class_2680 markerState = world.method_8320(pos.method_10084());

		if (markerState.method_26164(ModTags.Blocks.MARKERS)) {
			return markerState.method_26164(ModTags.Blocks.ZOMBIE_START_MARKERS);
		}
		return state.method_26164(ModTags.Blocks.ZOMBIE_START);
	}

	/**
	 * @return Whether this block is a lawn mower start.
	 */
	public boolean isStart(class_2338 pos) {
		class_1937 world = method_73183();
		class_2680 state = world.method_8320(pos);
		class_2680 markerState = world.method_8320(pos.method_10084());

		if (markerState.method_26164(ModTags.Blocks.MARKERS)) {
			return markerState.method_26164(ModTags.Blocks.ZOMBIE_GOAL_MARKERS);
		}
		return state.method_26164(ModTags.Blocks.ZOMBIE_GOAL);
	}

	/*
		STATS
	 */

	/**
	 * A class that has all the generic stats of the plant.
	 * For organization reasons.
	 */
	public static class PlantStats {
		public float attackRange = 3f;
		public float attackRangePath = 16f;
		public int attackTicks = 20;

		public PlantStats() {
		}

		public PlantStats attackRange(float value) {
			attackRange = value;
			return this;
		}

		public PlantStats attackRangePath(float value) {
			attackRangePath = value;
			return this;
		}

		public PlantStats attackTicks(int value) {
			attackTicks = value;
			return this;
		}

		public float getLargerAttackRange() {
			return Math.max(attackRange, attackRangePath);
		}
	}

	@Override
	protected boolean itemDuplicatesSpawnItem(class_1799 stack) {
		if (stack == null) return false;
		return stack.method_31573(ModTags.Items.PLANT_FEEDABLE_FOR_DUPLICATE);
	}

	/*
		SOUNDS
	 */

	@Nullable
	@Override
	protected class_3414 method_5994() {
		return null;
	}

	@Nullable
	@Override
	protected class_3414 method_6011(class_1282 source) {
		return null;
	}

	@Override
	protected class_3414 method_6002() {
		return null;
	}

	@Override
	protected class_3414 method_5737() {
		return null;
	}

	@Override
	protected class_3414 method_5625() {
		return null;
	}

	@Override
	protected class_3414 method_5672() {
		return null;
	}

	/*@Override
	public SoundEvent getEatSound(ItemStack stack) {
		return null;
	}

	@Override
	protected SoundEvent getDrinkSound(ItemStack stack) {
		return null;
	}*/

	@Override
	protected void playFeedSound() {
		method_73183().method_43129(null, this, ModSounds.ENTITY_PLANT_FEED, method_5634(), 1f, 1f);
	}

	@Override
	public class_3419 method_5634() {
		return class_3419.field_15254;
	}
}
