package net.db64.homelawnsecurity.entity.custom;

import net.db64.homelawnsecurity.entity.ai.PvzNavigation;
import net.db64.homelawnsecurity.util.LawnUtil;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1408;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public abstract class SeedPlacedEntity extends class_1314 implements IPvzEntity, IPathBoundEntity {
	public boolean shouldDropSpawnItem = false;
	public class_1799 spawnItem = class_1799.field_8037;

	protected SeedPlacedEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
		super(entityType, world);
	}

	/*
		DROPS
	*/

	@Override
	protected void method_16080(class_3218 world, class_1282 damageSource) {
		super.method_16080(world, damageSource);

		if (method_29504())
			dropSpawnItemOnDeath();
	}

	protected void dropSpawnItemOnDeath() {
		if (shouldDropSpawnItem) {
			class_1542 itemEntity = method_5775((class_3218) method_73183(), getSpawnItem());
			if (itemEntity != null) {
				itemEntity.method_18800(field_5974.method_43057() * 0.1f - 0.05f, 0.1f, field_5974.method_43057() * 0.1f - 0.05f);
			}
		}
	}

	protected void dropSpawnItemOnFeed() {
		class_1542 itemEntity = method_5775((class_3218) method_73183(), getSpawnItem());
		if (itemEntity != null) {
			itemEntity.method_18800(field_5974.method_43057() * 0.1f - 0.05f, 0.1f, field_5974.method_43057() * 0.1f - 0.05f);
		}
		playFeedSound();
	}

	public class_1799 getSpawnItem() {
		if (spawnItem != null) {
			return spawnItem;
		}
		return class_1799.field_8037.method_7972();
	}

	@Override
	protected class_1269 method_5992(class_1657 player, class_1268 hand) {
		if (method_73183().method_8608())
			return class_1269.field_5811;

		class_1799 stack = player.method_5998(hand);
		if (stack != null && itemDuplicatesSpawnItem(stack)) {
			dropSpawnItemOnFeed();
			stack.method_57008(1, player);

			return class_1269.field_52422;
		}

		return class_1269.field_5811;
	}

	protected abstract boolean itemDuplicatesSpawnItem(class_1799 stack);

	protected abstract void playFeedSound();

	/*
		IPATHBOUNDENTITY STUFF
	 */

	public int pathId = 1;

	@Nullable
	@Override
	public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
		class_1315 result = super.method_5943(world, difficulty, spawnReason, entityData);

		//HomeLawnSecurity.LOGGER.info("new seed-placed entity");
		class_2338 pos = method_23312();
		Iterable<class_2338> iterable = class_2338.method_25996(pos, 5, 5, 5);
		for (class_2338 blockPos : iterable) {
			//HomeLawnSecurity.LOGGER.info("block pos {} is:", blockPos.toShortString());
			if (LawnUtil.isAnyPath(blockPos, method_73183())) {
				for (int i = 1; i <= LawnUtil.getPathTypeAmount(); i++) {
					if (LawnUtil.isCertainPath(blockPos, method_73183(), i)) {
						//HomeLawnSecurity.LOGGER.info("path {}", i);
						pathId = i;
					}
				}
				break;
			}
			//HomeLawnSecurity.LOGGER.info("not a path");
		}

		return result;
	}

	public int getPathId() {
		return pathId;
	}

	public void setPathId(int pathId) {
		this.pathId = pathId;
	}

	public boolean isThisPath(class_2338 pos) {
		return isCertainPath(pos, pathId);
	}

	public boolean isCertainPath(class_2338 pos, int pathId) {
		return LawnUtil.isCertainPath(pos, method_73183(), pathId);
	}

	@Override
	protected class_1408 method_5965(class_1937 world) {
		return new PvzNavigation(this, world);
	}

	/*
		NBT
	*/

	@Override
	public void method_5652(class_11372 view) {
		super.method_5652(view);

		if (pathId < 1 || pathId > LawnUtil.getPathTypeAmount()) {
			pathId = 1;
		}
		view.method_71465("path_id", pathId);

		view.method_71472("should_drop_spawn_item", shouldDropSpawnItem);

		view.method_71468("spawn_item", class_1799.field_49266, class_1799.field_8037.method_7972());
	}

	@Override
	public void method_5749(class_11368 view) {
		super.method_5749(view);

		pathId = view.method_71424("path_id", 1);
		if (pathId < 1 || pathId > LawnUtil.getPathTypeAmount()) {
			pathId = 1;
			//view.putInt("path_id", pathId);
		}

		shouldDropSpawnItem = view.method_71433("should_drop_spawn_item", false);
		spawnItem = view.method_71426("spawn_item", class_1799.field_49266).orElse(class_1799.field_8037.method_7972());
	}

	protected class_1799 createErrorItem() {
		class_1799 stack = new class_1799(class_1802.field_8635);
		stack.method_57381(class_9334.field_53964);
		stack.method_57381(class_9334.field_50075);
		stack.method_57379(class_9334.field_54199, class_2960.method_60656("barrier"));
		stack.method_57379(class_9334.field_50239, class_2561.method_43471("error.homelawnsecurity.invalid_spawn_item").method_10862(class_2583.field_24360.method_36139(16711680)));
		return stack;
	}
}
