package net.db64.homelawnsecurity.entity.custom;

import net.db64.homelawnsecurity.component.ModDataComponentTypes;
import net.db64.homelawnsecurity.entity.ModDamageTypes;
import net.db64.homelawnsecurity.entity.ai.zombie.ZombieStayOnPathGoal;
import net.db64.homelawnsecurity.entity.ai.zombie.ZombieMoveGoal;
import net.db64.homelawnsecurity.entity.ai.zombie.ZombieTargetGoal;
import net.db64.homelawnsecurity.sound.ModSounds;
import net.db64.homelawnsecurity.util.LawnUtil;
import net.db64.homelawnsecurity.util.ModTags;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_7094;
import net.minecraft.entity.*;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;

public abstract class ZombieEntity extends SeedPlacedEntity implements IDegradableEntity {
	//private abstract static final TrackedData<Boolean> USING_ATTACK =
		//DataTracker.registerData(ZombieEntityClassHere.class, TrackedDataHandlerRegistry.BOOLEAN);

	/*@Deprecated
	public TagKey<Block> pathTag = ModTags.Blocks.ZOMBIE_PATH_1;
	@Deprecated
	public TagKey<Block> pathMarkerTag = ModTags.Blocks.ZOMBIE_PATH_1_MARKERS;*/

	public final class_7094 attackAnimationState = new class_7094();
	public int attackAnimationTimeout = 0;
	public int maxAttackAnimationTimeout = 10;
	public int attackTimeout = 0;
	protected int eatingSoundTimeout = 0;

	protected ZombieEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
		super(entityType, world);

		//limbAnimator.setSpeed(limbAnimator.getSpeed() * 10f);

		//setPathTagNbt(pathTag);
		/*World world2 = getEntityWorld();
		BlockState groundState = world2.getBlockState(this.getBlockPos().down());
		BlockState markerState = world2.getBlockState(this.getBlockPos());
		if (markerState.isIn(this.getOtherPathMarkerTag(pathMarkerTag)) // The block is marked as the other path
			|| (!markerState.isIn(ModTags.Blocks.REVEALS_MARKERS) && groundState.isIn(this.getOtherPathTag(pathTag)))) { // The block is not marked, but is the other path
			switchPathTag();
		}*/

		/*if (age == 0) {
			Iterable<BlockPos> iterable = BlockPos.iterateOutwards(getBlockPos().down(), 5, 5, 5);
			for (BlockPos blockPos : iterable) {
				if (isThisPath(blockPos)) {
					break;
				}
				if (isOtherPath(blockPos)) {
					switchPathTag();
					break;
				}
			}
		}*/
	}

	@Nullable
	@Override
	public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
		class_1315 result = super.method_5943(world, difficulty, spawnReason, entityData);

		return result;
	}

	@Override
	public void method_5773() {
		super.method_5773();
		tickDegradation(this);

		if (this.method_73183().method_8608()) {
			updateAnimations();
		}
		else {
			if (this.getUsingAttack()) {
				if (!hasHead()) {
					setUsingAttack(false);
					method_5980(null);
				}
				else {
					if (this.eatingSoundTimeout <= 0) {
						this.method_5783(ModSounds.ENTITY_ZOMBIE_EAT, 0.5f, 1.0f / (this.method_59922().method_43057() * 0.4f + 1f));
						this.eatingSoundTimeout = 10;
						//HomeLawnSecurity.LOGGER.info("zombie took bite");
					}
					else {
						--this.eatingSoundTimeout;
					}
				}
			}
			else {
				this.eatingSoundTimeout = 0;
			}

			if (attackTimeout > 0) {
				--this.attackTimeout;
			}

			if (attackTimeout <= 0) {
				setUsingAttack(false);
			}

			//HomeLawnSecurity.LOGGER.info("attackTimeout is " + attackTimeout + " and isUsingAttack() is " + isUsingAttack());

			/*if (getHasLostHead()) {
				damage((ServerWorld) getEntityWorld(), this.getDamageSources().create(ModDamageTypes.ZOMBIE_HEADLESS), 2);
			}*/
		}
	}

	@Override
	public void method_6005(double strength, double x, double z) {
		// oh no--i hope this really heavy beach ball doesn't break my leg

		if (method_6065() != null && method_6065().method_6047().method_57826(ModDataComponentTypes.SHOVEL)) {
			super.method_6005(strength * 3, x, z);
		}
	}

	@Override
	public boolean method_64397(class_3218 world, class_1282 source, float amount) {
		class_1297 attacker = source.method_5529();
		boolean damaged;
		if (attacker instanceof class_1309 && ((class_1309) attacker).method_6047().method_57826(ModDataComponentTypes.SHOVEL)) {
			world.method_8396(this, method_24515(), ModSounds.RANDOM_SHOVEL_ATTACK, attacker.method_5634(), 1, 1);
			damaged = super.method_64397(world, source, 1000000);
		}
		else {
			damaged = super.method_64397(world, source, amount);
		}

		if (attacker instanceof IPvzEntity
			|| source.method_49708(ModDamageTypes.ZOMBIE_HEADLESS)) {
			//damaged = super.damage(world, source, amount);

			this.field_6235 = 0;
			this.field_6008 = 0;
		}
		//else {
			//damaged = super.damage(world, source, amount * 10);
		//}

		/*if (!getHasLostHeadwear() && getHealth() < getLoseHeadwearHealth()) {
			setHasLostHeadwear(true);
			this.playSound(ModSounds.ENTITY_ZOMBIE_DETACH_HEADWEAR, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
		}
		if (!getHasLostArm() && getHealth() < getLoseArmHealth()) {
			setHasLostArm(true);
			this.playSound(ModSounds.ENTITY_ZOMBIE_DETACH_LIMB, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
		}
		if (!getHasLostHead() && getHealth() < getLoseHeadHealth()) {
			setHasLostHead(true);
			this.playSound(ModSounds.ENTITY_ZOMBIE_DETACH_HEAD, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
		}*/

		return damaged;
	}

	@Override
	public boolean method_30949(class_1297 other) {
		return (other.method_30948(this) || (other instanceof PlantEntity && this.hasHead())) && !this.method_5794(other);
	}

	@Override
	public void method_5652(class_11372 view) {
		super.method_5652(view);

		/*if (pathTag == ModTags.Blocks.ZOMBIE_PATH_2)
			view.putInt("path_tag", 2);
		else
			view.putInt("path_tag", 1);*/

		writeDegradationNbt(view);
	}

	@Override
	public void method_5749(class_11368 view) {
		super.method_5749(view);

		/*int path = view.getInt("path_tag", 1);
		if (path == 2) {
			pathTag = ModTags.Blocks.ZOMBIE_PATH_2;
			pathMarkerTag = ModTags.Blocks.ZOMBIE_PATH_2_MARKERS;
		} else {
			pathTag = ModTags.Blocks.ZOMBIE_PATH_1;
			pathMarkerTag = ModTags.Blocks.ZOMBIE_PATH_1_MARKERS;
		}*/

		readDegradationNbt(view);
	}

	/*
		ANIMATIONS
	 */

	protected void updateAnimations() {
		if (this.getUsingAttack()) {
			attackAnimationTimeout = maxAttackAnimationTimeout;
			if (!attackAnimationState.method_41327()) {
				attackAnimationState.method_41322(this.field_6012);
			}
		}
		else if (attackAnimationTimeout > 0) {
			--this.attackAnimationTimeout;
		}

		if (attackAnimationTimeout <= 0) {
			attackAnimationState.method_41325();
		}
	}

	@Override
	protected void method_48565(float posDelta) {
		float f = Math.min(posDelta * 16.0f, 1.0f);
		this.field_42108.method_48568(f, 0.8f, this.method_6109() ? 3.0f : 1.0f);
	}

	@Override
	public void method_6114(class_1297 target) {
		super.method_6114(target);
		setUsingAttack(true);
		attackTimeout = 2;

		if (target instanceof class_1309 && ((class_1309) target).method_6032() <= 0) {
			this.method_5783(ModSounds.ENTITY_ZOMBIE_GULP, 1.0f, 1.0f / (this.method_59922().method_43057() * 0.4f + 0.8f));
		}
	}

	/*
		DAMAGE
	 */

	/*
	 * @return The health at which this zombie will lose its headwear upon going below, or -1 if it doesn't normally spawn with any.
	 */
	//public abstract float getLoseHeadwearHealth();

	/*
	 * @return The health at which this zombie will lose its arm upon going below, or -1 if it never does.
	 * Typically, this is two thirds of the zombie's max health.
	 */
	//public abstract float getLoseArmHealth();

	/*
	 * @return The health at which this zombie will lose its head and start to die upon going below.
	 * Typically, this is a third of the zombie's max health.
	 */
	//public abstract float getLoseHeadHealth();

	public abstract class_2940<Boolean> getUsingAttackTrackedData();

	public void setUsingAttack(boolean usingAttack) {
		var usingAttackData = getUsingAttackTrackedData();
		if (usingAttackData != null)
			this.field_6011.method_12778(usingAttackData, usingAttack);
	}

	public boolean getUsingAttack() {
		var usingAttack = getUsingAttackTrackedData();
		if (usingAttack == null)
			return false;
		return this.field_6011.method_12789(usingAttack);
	}

	ArrayList<DegradationStage> degradationStages = new ArrayList<>();

	@Override
	public ArrayList<DegradationStage> getDegradationStageList() {
		return degradationStages;
	}

	public boolean hasHead() {
		if (getDegradationStage("head") != null) {
			return !hasTriggeredDegradationStage("head");
		}
		return true;
	}

	/*public abstract TrackedData<Boolean> getHasLostHeadwearTrackedData();

	public void setHasLostHeadwear(boolean hasLostHeadwear) {
		var lostHeadwear = getHasLostHeadwearTrackedData();
		if (lostHeadwear != null)
			this.dataTracker.set(lostHeadwear, hasLostHeadwear);
	}

	public boolean getHasLostHeadwear() {
		var lostHeadwear = getHasLostHeadwearTrackedData();
		if (lostHeadwear == null)
			return false;
		return this.dataTracker.get(lostHeadwear);
	}

	public abstract TrackedData<Boolean> getHasLostArmTrackedData();

	public void setHasLostArm(boolean hasLostArm) {
		var lostArm = getHasLostArmTrackedData();
		if (lostArm != null)
			this.dataTracker.set(lostArm, hasLostArm);
	}

	public boolean getHasLostArm() {
		var lostArm = getHasLostArmTrackedData();
		if (lostArm == null)
			return false;
		return this.dataTracker.get(lostArm);
	}

	public abstract TrackedData<Boolean> getHasLostHeadTrackedData();

	public void setHasLostHead(boolean hasLostHead) {
		var lostHead = getHasLostHeadTrackedData();
		if (lostHead != null)
			this.dataTracker.set(lostHead, hasLostHead);
	}

	public boolean getHasLostHead() {
		var lostHead = getHasLostHeadTrackedData();
		if (lostHead == null)
			return false;
		return this.dataTracker.get(lostHead);
	}*/

	@Override
	protected void method_5693(class_2945.class_9222 builder) {
		super.method_5693(builder);

		var usingAttack = getUsingAttackTrackedData();
		if (usingAttack != null)
			builder.method_56912(usingAttack, false);

		/*var lostHeadwear = getHasLostHeadwearTrackedData();
		if (lostHeadwear != null)
			builder.add(lostHeadwear, false);

		var lostArm = getHasLostArmTrackedData();
		if (lostArm != null)
			builder.add(lostArm, false);

		var lostHead = getHasLostHeadTrackedData();
		if (lostHead != null)
			builder.add(lostHead, false);*/
	}

	/*
		BLOCKS
	 */

	public boolean isWalkable(class_2338 pos) {
		return LawnUtil.isWalkable(pos, method_73183(), pathId, true);
	}

	/**
	 * @return Whether a zombie can be placed on top of this block.
	 */
	public static boolean isPlaceable(class_2338 pos, class_1937 world) {
		return LawnUtil.isAnyPath(pos, world);
	}

	/**
	 * @return Whether this block is a goal.
	 */
	public boolean isGoal(class_2338 pos) {
		class_1937 world = method_73183();
		class_2680 state = world.method_8320(pos);
		class_2680 markerState = world.method_8320(pos.method_10084());

		if (markerState.method_26164(ModTags.Blocks.MARKERS)) {
			return markerState.method_26164(ModTags.Blocks.ZOMBIE_GOAL_MARKERS);
		}
		return state.method_26164(ModTags.Blocks.ZOMBIE_GOAL);
	}

	/**
	 * @return Whether this block is a start.
	 */
	public boolean isStart(class_2338 pos) {
		class_1937 world = method_73183();
		class_2680 state = world.method_8320(pos);
		class_2680 markerState = world.method_8320(pos.method_10084());

		if (markerState.method_26164(ModTags.Blocks.MARKERS)) {
			return markerState.method_26164(ModTags.Blocks.ZOMBIE_START_MARKERS);
		}
		return state.method_26164(ModTags.Blocks.ZOMBIE_START);
	}

	/*@Override
	public float getPathfindingFavor(BlockPos pos, WorldView world) {
		//BlockState state = world.getBlockState(pos.down());
		if (isThisPath(pos.down())) {
			return 0f; // Path
		}
		else if (isGoal(pos.down())) {
			return 0f; // Goal
		}
		return Float.NEGATIVE_INFINITY; // Off-road
	}*/

	/*
		STATS
	 */

	@Override
	protected void method_5959() {
		this.field_6201.method_6277(0, new ZombieStayOnPathGoal(this, 1f));
		this.field_6201.method_6277(2, new ZombieTargetGoal<PlantEntity>(this, PlantEntity.class, true, 1));
		this.field_6201.method_6277(3, new ZombieMoveGoal(this, 1f));
	}

	@Override
	protected boolean itemDuplicatesSpawnItem(class_1799 stack) {
		if (stack == null) return false;
		return stack.method_31573(ModTags.Items.ZOMBIE_FEEDABLE_FOR_DUPLICATE);
	}

	/*
		SOUNDS
	 */

	@Nullable
	@Override
	protected class_3414 method_5994() {
		return ModSounds.ENTITY_ZOMBIE_IDLE;
	}

	@Nullable
	@Override
	protected class_3414 method_6011(class_1282 source) {
		return null;
	}

	@Override
	protected class_3414 method_6002() {
		if (this.method_73183().method_8316(this.method_24515()).method_15767(class_3486.field_15517))
			return ModSounds.ENTITY_ZOMBIE_COLLAPSE_UNDERWATER;
		return ModSounds.ENTITY_ZOMBIE_COLLAPSE;
	}

	@Override
	protected class_3414 method_5737() {
		return ModSounds.ENTITY_ZOMBIE_ENTER_WATER;
	}

	@Override
	protected class_3414 method_5625() {
		return ModSounds.ENTITY_ZOMBIE_ENTER_WATER;
	}

	@Override
	protected class_3414 method_5672() {
		return ModSounds.ENTITY_ZOMBIE_ENTER_WATER;
	}

	/*@Override
	public SoundEvent getEatSound(ItemStack stack) {
		return ModSounds.ENTITY_ZOMBIE_EAT;
	}

	@Override
	protected SoundEvent getDrinkSound(ItemStack stack) {
		return ModSounds.ENTITY_ZOMBIE_EAT;
	}*/

	@Override
	protected void playFeedSound() {
		method_73183().method_43129(null, this, ModSounds.ENTITY_ZOMBIE_FEED, method_5634(), 1f, 1f);
	}

	@Override
	public class_3419 method_5634() {
		return class_3419.field_15251;
	}
}
