package net.db64.homelawnsecurity.entity.custom.other;

import net.db64.homelawnsecurity.component.BagOfCurrencyComponent;
import net.db64.homelawnsecurity.component.CurrencyComponent;
import net.db64.homelawnsecurity.component.ModDataComponentTypes;
import net.db64.homelawnsecurity.entity.ModEntities;
import net.db64.homelawnsecurity.item.ModItems;
import net.db64.homelawnsecurity.item.custom.CurrencyItem;
import net.db64.homelawnsecurity.sound.ModSounds;
import net.minecraft.class_10774;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3856;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.entity.*;
import java.util.Iterator;

public class CurrencyEntity extends class_1676 implements class_3856 {
	private static final int MAX_IDLE_TIME = 200;

	private static final class_2940<class_1799> ITEM = class_2945.method_12791(CurrencyEntity.class, class_2943.field_13322);
	private static final class_2940<Boolean> CURRENCY_LEFT_OWNER = class_2945.method_12791(CurrencyEntity.class, class_2943.field_13323);

	public int idleTime = 0;
	public class_1799 stack = getDefaultItemStack();

	public CurrencyEntity(class_1299<? extends class_1676> entityType, class_1937 world) {
		super(entityType, world);
	}

	public CurrencyEntity(class_3218 world, class_1309 livingEntity, class_1799 stack) {
		this(livingEntity.method_23317(), livingEntity.method_23320() - (double) 0.1f, livingEntity.method_23321(), world, stack);
		method_7432(livingEntity);
	}

	public CurrencyEntity(double x, double y, double z, class_1937 world, class_1799 stack) {
		super(ModEntities.Other.CURRENCY, world);
		this.method_5814(x, y, z);
		field_6011.method_12778(ITEM, stack);
		this.stack = stack.method_7972();
	}

	@Override
	protected void method_5693(class_2945.class_9222 builder) {
		//super.initDataTracker(builder);
		builder.method_56912(ITEM, this.getDefaultItemStack());
		builder.method_56912(CURRENCY_LEFT_OWNER, false);
	}

	@Override
	public void method_5773() {
		this.tickInitialBubbleColumnCollision();
		this.method_56990();
		this.applyDrag();
		class_239 hitResult = class_1675.method_49997(this, this::method_26958);
		class_243 vec3d;
		if (hitResult.method_17783() != class_239.class_240.field_1333) {
			vec3d = hitResult.method_17784();
		} else {
			vec3d = this.method_73189().method_1019(this.method_18798());
		}

		//double d = this.getX() + vec3d.x;
		//double e = this.getY() + vec3d.y;
		//double f = this.getZ() + vec3d.z;

		this.method_33574(vec3d);
		this.method_26962();
		this.method_61409();
		super.method_5773();
		if (hitResult.method_17783() != class_239.class_240.field_1333 && this.method_5805()) {
			this.method_59860(hitResult);
		}

		class_243 velocity = this.method_18798();
		this.field_5994 += (float) Math.sqrt(velocity.field_1352 * velocity.field_1352 + velocity.field_1351 * velocity.field_1351 + velocity.field_1350 * velocity.field_1350);
		//this.setPosition(d, e, f);

		checkForCollection();

		/*if (isOnGround()) {
			idleTime += 1;
			// TO DO: Currency doesn't know that it touched the ground. Remember when it would sink in when it had the smaller hitbox?
		}*/
		if (this.idleTime > MAX_IDLE_TIME) {
			method_31472();
		}
	}

	protected double method_7490() {
		return 0.01d;
	}

	@Override
	protected void method_7454(class_3966 entityHitResult) {
		super.method_7454(entityHitResult);

		this.field_51621 = null;
	}

	@Override
	protected void method_24920(class_3965 blockHitResult) {
		super.method_24920(blockHitResult);

		idleTime += 1;
	}

	private void tickInitialBubbleColumnCollision() {
		if (this.field_5953) {
			Iterator var1 = class_2338.method_62671(this.method_5829()).iterator();

			while(var1.hasNext()) {
				class_2338 blockPos = (class_2338)var1.next();
				class_2680 blockState = this.method_73183().method_8320(blockPos);
				if (blockState.method_27852(class_2246.field_10422)) {
					blockState.method_26178(this.method_73183(), blockPos, this, class_10774.field_56634, true);
				}
			}
		}
	}

	private void applyDrag() {
		class_243 velocity = this.method_18798();
		float drag = 0.8F;

		this.method_18799(velocity.method_1021(drag));
	}

	private void checkForCollection() {
		if (this.method_73183() instanceof class_3218 world) {
			class_1297 owner = method_24921();
			if (owner != null) {
				class_238 box = this.method_5829().method_1014(1.0);
				if (!field_6011.method_12789(CURRENCY_LEFT_OWNER) && !box.method_994(owner.method_5829())) {
					field_6011.method_12778(CURRENCY_LEFT_OWNER, true);
					//HomeLawnSecurity.LOGGER.info("currency left owner");
				}
			}

			for (class_1309 entity : this.method_73183()
				.method_8390(class_1309.class, this.method_5829().method_1014(1.0), class_1301.field_6155)) {
				if (method_34714(entity) && !field_6011.method_12789(CURRENCY_LEFT_OWNER))
					continue;

				//HomeLawnSecurity.LOGGER.info("currency collided with {}", entity.getName());

				class_1799 stack = method_7495();
				class_1799 bag = ((CurrencyItem) method_7495().method_7909()).getCurrentBag((class_1309) entity);
				if (bag == null)
					continue;

				//HomeLawnSecurity.LOGGER.info("currency collided with {} who has a bag", entity.getName());

				CurrencyComponent pickupCurrency = stack.method_58694(ModDataComponentTypes.CURRENCY);
				BagOfCurrencyComponent bagCurrency = bag.method_58694(ModDataComponentTypes.BAG_OF_CURRENCY);

				//HomeLawnSecurity.LOGGER.info("pickupCurrency: {}, bagCurrency: {}", pickupCurrency, bagCurrency);
				if (pickupCurrency != null && bagCurrency != null) {
					bag.method_57379(ModDataComponentTypes.BAG_OF_CURRENCY, new BagOfCurrencyComponent(Math.min(bagCurrency.amount() + pickupCurrency.amount(), 10000), bagCurrency.name()));

					if (pickupCurrency.name().equals("brainpower"))
						world.method_8396(null, entity.method_24515(), ModSounds.ENTITY_BRAINPOWER_COLLECT, class_3419.field_15254, 1f, world.method_8409().method_43057() * 0.4f + 1f);
					else
						world.method_8396(null, entity.method_24515(), ModSounds.ENTITY_SUN_COLLECT, class_3419.field_15254, 1f, world.method_8409().method_43057() * 0.4f + 1f);

					this.method_31472();
					break;
				}
			}
		}
	}

	public void setStack(class_1799 stack) {
		class_1799 item;
		if (!stack.method_7960()) {
			item = stack;
		} else {
			item = this.getDefaultItemStack();
		}
		this.stack = item;
		method_5841().method_12778(ITEM, item.method_46651(1));
	}

	@Override
	public class_1799 method_7495() {
		return this.method_5841().method_12789(ITEM);
	}

	//@Override
	public class_1799 getDefaultItemStack() {
		return ModItems.SUN.method_7854();
	}

	@Override
	public void method_5652(class_11372 view) {
		super.method_5652(view);

		view.method_71468("item", class_1799.field_24671, this.stack);

		view.method_71465("idle_time", idleTime);
	}

	@Override
	public void method_5749(class_11368 view) {
		super.method_5749(view);

		this.setStack(view.method_71426("item", class_1799.field_24671).orElseGet(() -> this.getDefaultItemStack().method_7972()));

		idleTime = view.method_71424("idle_time", 0);
	}

	@Override
	protected class_2561 method_23315() {
		class_2561 placeholder = super.method_23315();

		if (stack != null)
			return stack.method_7964();
		
		return placeholder;
	}
}
