package net.db64.homelawnsecurity.entity.custom.other;

import net.db64.homelawnsecurity.entity.ai.PvzNavigation;
import net.db64.homelawnsecurity.entity.custom.IPathBoundEntity;
import net.db64.homelawnsecurity.entity.custom.IPvzEntity;
import net.db64.homelawnsecurity.util.LawnUtil;
import net.db64.homelawnsecurity.util.ModTags;
import net.minecraft.class_11;
import net.minecraft.class_1266;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1408;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import org.jetbrains.annotations.Nullable;

public abstract class SeedPacketPathfindingEntity extends class_1314 implements IPathBoundEntity {
	public int pathId = 1;

	/*@Deprecated
	public TagKey<Block> pathTag = ModTags.Blocks.ZOMBIE_PATH_1;
	@Deprecated
	public TagKey<Block> pathMarkerTag = ModTags.Blocks.ZOMBIE_PATH_1_MARKERS;*/

	protected SeedPacketPathfindingEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
		super(entityType, world);
	}

	@Nullable
	@Override
	public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
		class_1315 result = super.method_5943(world, difficulty, spawnReason, entityData);

		//HomeLawnSecurity.LOGGER.info("new seed packet pathfinding entity");
		class_2338 pos = method_23312();
		Iterable<class_2338> iterable = class_2338.method_25996(pos, 5, 5, 5);
		for (class_2338 blockPos : iterable) {
			//HomeLawnSecurity.LOGGER.info("block pos {} is:", blockPos.toShortString());
			if (LawnUtil.isAnyPath(blockPos, method_73183())) {
				for (int i = 1; i <= LawnUtil.getPathTypeAmount(); i++) {
					if (LawnUtil.isCertainPath(blockPos, method_73183(), i)) {
						//HomeLawnSecurity.LOGGER.info("path {}", i);
						pathId = i;
					}
				}
				break;
			}
			//HomeLawnSecurity.LOGGER.info("not a path");
		}

		return result;
	}

	/*@Override
	public void tick() {
		super.tick();

		discard();
	}*/



	public int getPathId() {
		return pathId;
	}

	public void setPathId(int pathId) {
		this.pathId = pathId;
	}

	public boolean isWalkable(class_2338 pos) {
		return LawnUtil.isWalkable(pos, method_73183(), pathId, false);
	}

	public boolean isThisPath(class_2338 pos) {
		return isCertainPath(pos, pathId);
	}

	public boolean isCertainPath(class_2338 pos, int pathId) {
		return LawnUtil.isCertainPath(pos, method_73183(), pathId);
	}



	@Override
	public void method_5982() {
		this.method_31472();
	}

	@Override
	protected class_1408 method_5965(class_1937 world) {
		return new PvzNavigation(this, world);
	}

	public static int searchDistanceFromClose() {
		return 3;
	}

	public static int searchDistanceFromOtherEnd() {
		return 16;
	}

	@Nullable
	public class_11 findPathToGoal(int searchDistance) {
		int rangeH = searchDistance;
		int rangeV = 5;
		Iterable<class_2338> iterable = class_2338.method_25996(method_23312().method_10084(), rangeH, rangeV, rangeH);
		for (class_2338 blockPos : iterable) {
			//HomeLawnSecurity.LOGGER.info("seed packet is checking for if the block at {}, {}, {} is a goal", blockPos.getX(), blockPos.getY(), blockPos.getZ());
			if (!isGoal(blockPos.method_10074())) continue;
			//HomeLawnSecurity.LOGGER.info("seed packet is checking for if the goal at {}, {}, {} is reachable", blockPos.getX(), blockPos.getY(), blockPos.getZ());
			class_11 path = method_5942().method_6352(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), 1);
			if (path == null) continue;
			//HomeLawnSecurity.LOGGER.info("seed packet has determined that the goal at {}, {}, {} is reachable", blockPos.getX(), blockPos.getY(), blockPos.getZ());
			return path;
		}
		return null;
	}

	@Nullable
	public class_11 findPathToStart(int searchDistance) {
		int rangeH = searchDistance;
		int rangeV = 5;
		Iterable<class_2338> iterable = class_2338.method_25996(method_23312().method_10084(), rangeH, rangeV, rangeH);
		for (class_2338 blockPos : iterable) {
			//HomeLawnSecurity.LOGGER.info("seed packet is checking for if the block at {}, {}, {} is a start", blockPos.getX(), blockPos.getY(), blockPos.getZ());
			if (!isStart(blockPos.method_10074())) continue;
			//HomeLawnSecurity.LOGGER.info("seed packet is checking for if the start at {}, {}, {} is reachable", blockPos.getX(), blockPos.getY(), blockPos.getZ());
			class_11 path = method_5942().method_6352(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), 1);
			if (path == null) continue;
			//HomeLawnSecurity.LOGGER.info("seed packet has determined that the start at {}, {}, {} is reachable", blockPos.getX(), blockPos.getY(), blockPos.getZ());
			return path;
		}
		return null;
	}

	public static class_5132.class_5133 createAttributes() {
		return class_1308.method_26828()
			.method_26868(class_5134.field_23716, 270 * IPvzEntity.HEALTH_SCALE)
			.method_26868(class_5134.field_23721, 5 * IPvzEntity.HEALTH_SCALE)
			.method_26868(class_5134.field_23717, 64)
			.method_26868(class_5134.field_23719, 0.1);
	}
}
