package net.db64.homelawnsecurity.entity.custom.plant;

import net.db64.homelawnsecurity.entity.ai.plant.PeashooterAttackGoal;
import net.db64.homelawnsecurity.entity.ai.plant.PlantTargetGoal;
import net.db64.homelawnsecurity.entity.custom.IPvzEntity;
import net.db64.homelawnsecurity.entity.custom.PlantEntity;
import net.db64.homelawnsecurity.entity.custom.ZombieEntity;
import net.db64.homelawnsecurity.entity.custom.projectile.PeaEntity;
import net.db64.homelawnsecurity.item.ModItems;
import net.db64.homelawnsecurity.sound.ModSounds;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1333;
import net.minecraft.class_1603;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7094;
import java.util.Optional;

public class PeashooterEntity extends PlantEntity implements IPvzEntity, ILawnPlant, class_1603 {
	private static final class_2940<Boolean> USING_ATTACK =
		class_2945.method_12791(PeashooterEntity.class, class_2943.field_13323);

	private static final PlantStats STATS = new PlantStats().attackRange(3f).attackRangePath(16f).attackTicks(30);

	public final class_7094 setupAnimationState = new class_7094();
	//public int setupAnimationTimeout = 0;

	//public int attackHeadRotTimeout = 0;

	/*
		GENERAL
	 */

	public PeashooterEntity(class_1299<? extends PlantEntity> entityType, class_1937 world) {
		super(entityType, world);
		this.field_6206 = new PeashooterLookControl(this);
	}

	/*
		ANIMATIONS
	 */

	protected void updateAnimations() {
		super.updateAnimations();

		if (!setupAnimationState.method_41327())
			setupAnimationState.method_41322(this.field_6012);

		/*if (this.isAttacking()) {
			attackHeadRotTimeout = 20;
		}
		else if (attackHeadRotTimeout > 0) {
			--this.attackHeadRotTimeout;
		}*/
	}

	@Override
	public class_2940<Boolean> getUsingAttackTrackedData() {
		return USING_ATTACK;
	}

	/*
		BLOCKS
	 */

	/*
		SHOOTING
	 */

	@Override
	public void method_7105(class_1309 target, float pullProgress) {
		setUsingAttack(true);
		attackTimeout = 10;

		class_1676 projectileEntity = createProjectile(this);
		double d = target.method_23317() - this.method_23317();
		//double e = target.getBodyY(0.3333333333333333) - projectileEntity.getY();
		double f = target.method_23321() - this.method_23321();
		//double g = Math.sqrt(d * d + f * f);
		projectileEntity.method_7485(d, /*e + g * (double)0.2f*/ 0, f, 0.5f, /*14 - this.getEntityWorld().getDifficulty().getId() * 4*/ 0);
		this.method_5783(ModSounds.ENTITY_PEA_THROW, 1.0f, 1.0f / (this.method_59922().method_43057() * 0.4f + 0.8f));
		this.method_73183().method_8649(projectileEntity);
	}

	public static class_1676 createProjectile(PeashooterEntity entity) {
		//ArrowItem arrowItem = (ArrowItem)(stack.getItem() instanceof ArrowItem ? stack.getItem() : Items.ARROW);
		float maxDistance = entity.onPath ? STATS.attackRangePath * 1.5f : STATS.attackRange * 1.5f;

		PeaEntity projectileEntity = new PeaEntity(entity.method_23317(), entity.method_23318() + entity.method_17682() * 0.6, entity.method_23321(), entity.method_73183(), maxDistance);
		projectileEntity.method_7432(entity);
		projectileEntity.setMaxDistance(maxDistance);

		return projectileEntity;
	}

	@Override
	public double method_23320() {
		return this.method_23318() + (this.method_17682() * 0.8);
	}

	protected class PeashooterLookControl extends class_1333 {
		public PeashooterLookControl(class_1308 entity) {
			super(entity);
		}

		@Override
		protected boolean method_20433() {
			return PeashooterEntity.this.method_5968() != null;
		}

		@Override
		protected Optional<Float> method_20250() {
			if (PeashooterEntity.this.method_5968() != null)
				return Optional.of(0f);
			return super.method_20250();
		}

		@Override
		public void method_6230(double x, double y, double z, float maxYawChange, float maxPitchChange) {
			super.method_6230(x, y, z, maxYawChange, maxPitchChange);
			this.field_6363 = PeashooterEntity.this.method_23320();
		}
	}

	/*
		STATS
	 */

	@Override
	protected void method_5959() {
		this.field_6201.method_6277(2, new PlantTargetGoal<>(this, ZombieEntity.class, false, STATS.attackRange, STATS.attackRangePath));
		this.field_6201.method_6277(2, new PeashooterAttackGoal(this, 1, STATS.attackTicks, STATS.getLargerAttackRange()));
	}

	public static class_5132.class_5133 createAttributes() {
		return class_1308.method_26828()
			.method_26868(class_5134.field_23716, 300 * IPvzEntity.HEALTH_SCALE)
			.method_26868(class_5134.field_23721, 20 * IPvzEntity.HEALTH_SCALE)
			.method_26868(class_5134.field_23717, STATS.getLargerAttackRange())
			.method_26868(class_5134.field_23719, 0);
	}
}
