package net.db64.homelawnsecurity.item.custom;

import net.db64.homelawnsecurity.component.CurrencyComponent;
import net.db64.homelawnsecurity.component.ModDataComponentTypes;
import net.db64.homelawnsecurity.entity.custom.other.CurrencyEntity;
import net.db64.homelawnsecurity.sound.ModSounds;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_9463;
import java.util.List;
import java.util.function.Predicate;

public class CurrencyItem extends class_1792 implements class_9463 {
	public Predicate<class_1799> bagPredicate;

	public CurrencyItem(class_1792.class_1793 settings, Predicate<class_1799> bagPredicate) {
		super(settings);
		this.bagPredicate = bagPredicate;
	}

	/*@Override
	public void appendTooltip(ItemStack stack, TooltipContext context, List<Text> tooltip, TooltipType type) {
		super.appendTooltip(stack, context, tooltip, type);

		var currencyComponent = stack.get(ModDataComponentTypes.CURRENCY);
		if (currencyComponent != null)
			tooltip.add(Text.translatable("tooltip.homelawnsecurity.currency." + currencyComponent.name(), currencyComponent.amount()));
	}*/

	public class_1799 getCurrentBag(class_1309 entity) {
		if (bagPredicate.test(entity.method_5998(class_1268.field_5810))) {
			return entity.method_5998(class_1268.field_5810);
		}
		else if (bagPredicate.test(entity.method_5998(class_1268.field_5808))) {
			return entity.method_5998(class_1268.field_5808);
		}
		else if (entity instanceof class_3222 player) {
			class_1661 inventory = player.method_31548();
			for (int i = 0; i < inventory.method_5439(); i++) {
				class_1799 itemStack2 = inventory.method_5438(i);
				if (bagPredicate.test(itemStack2)) {
					return itemStack2;
				}
			}
		}
		return class_1799.field_8037;
	}

	@Override
	public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
		class_1799 itemStack = user.method_5998(hand);
		class_3414 sound;
		CurrencyComponent currency = itemStack.method_58694(ModDataComponentTypes.CURRENCY);
		if (currency != null && currency.name().equals("brainpower"))
			sound = ModSounds.ENTITY_BRAINPOWER_THROW;
		else
			sound = ModSounds.ENTITY_SUN_THROW;

		world.method_43128(
			null,
			user.method_23317(),
			user.method_23318(),
			user.method_23321(),
			sound,
			class_3419.field_15254,
			0.5f,
			world.method_8409().method_43057() * 0.4f + 1f
		);

		if (world instanceof class_3218 serverWorld) {
			class_1676.method_61549(CurrencyEntity::new, serverWorld, itemStack, user, 0.0f, 1.5f, 1.0f);
		}

		user.method_7259(class_3468.field_15372.method_14956(this));
		itemStack.method_57008(1, user);
		return class_1269.field_5812;
	}

	@Override
	public class_1676 method_58648(class_1937 world, class_2374 pos, class_1799 stack, class_2350 direction) {
		return new CurrencyEntity(pos.method_10216(), pos.method_10214(), pos.method_10215(), world, stack);
	}
}
