package net.db64.homelawnsecurity.item.custom;

import com.mojang.serialization.MapCodec;
import net.db64.homelawnsecurity.entity.ModEntities;
import net.db64.homelawnsecurity.entity.custom.other.LawnMowerEntity;
import net.db64.homelawnsecurity.sound.ModSounds;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

import java.util.function.Predicate;

public class LawnMowerItem extends SeedPacketItem {
	private static final MapCodec<class_1299<?>> ENTITY_TYPE_MAP_CODEC = class_7923.field_41177.method_39673().fieldOf("id");
	private final class_1299<?> type;

	public LawnMowerItem(class_1299<? extends class_1308> type, class_1793 settings) {
		super(ModEntities.Other.LAWN_MOWER, settings);
		this.type = type;
	}

	@Override
	protected boolean isPlaceable(class_2338 blockPos, class_1937 world, boolean devMode, class_3222 player) {
		return LawnMowerEntity.isPlaceable(blockPos, world);
	}

	@Override
	public void playPlaceSound(class_1937 world, class_2338 pos) {

	}

	public static void playBuzzerSound(class_1937 world, class_2338 pos) {
		world.method_45447(null, pos, ModSounds.RANDOM_BUZZER, class_3419.field_15254);
	}

	/*@Override
	public ActionResult useOnBlock(ItemUsageContext context) {
		World world = context.getWorld();
		if (world.isClient) {
			return ActionResult.SUCCESS;
		} else {
			ItemStack itemStack = context.getStack();
			BlockPos blockPos = context.getBlockPos();
			Direction direction = context.getSide();
			BlockState blockState = world.getBlockState(blockPos);
			if (world.getBlockEntity(blockPos) instanceof Spawner spawner) {
				EntityType<?> entityType = this.getEntityType(itemStack);
				spawner.setEntityType(entityType, world.getRandom());
				world.updateListeners(blockPos, blockState, blockState, Block.NOTIFY_ALL);
				world.emitGameEvent(context.getPlayer(), GameEvent.BLOCK_CHANGE, blockPos);
				itemStack.decrement(1);
				return ActionResult.SUCCESS;
			} else {
				BlockPos blockPos2;
				if (blockState.getCollisionShape(world, blockPos).isEmpty()) {
					blockPos2 = blockPos;
				} else {
					blockPos2 = blockPos.offset(direction);
				}

				// Invalid spawn position
				if (!LawnMowerEntity.isPlaceable(blockPos.offset(direction).down(), world)) {
					playBuzzerSound(world, blockPos);
					sendMessage(context.getPlayer(), Text.translatable("item.homelawnsecurity.lawn_mower.placement.error"));
					return ActionResult.SUCCESS;
				}

				EntityType<?> entityType = this.getEntityType(itemStack);
				if (entityType.spawnFromItemStack(
					(ServerWorld)world,
					itemStack,
					context.getPlayer(),
					blockPos2,
					SpawnReason.SPAWN_ITEM_USE,
					true,
					!Objects.equals(blockPos, blockPos2) && direction == Direction.UP
				)
					!= null) {
					itemStack.decrement(1);
					world.emitGameEvent(context.getPlayer(), GameEvent.ENTITY_PLACE, blockPos);
				}

				return ActionResult.SUCCESS;
			}
		}
	}*/

	@Override
	protected boolean setCooldownAndCurrencyAndReturnIfInsufficient(@Nullable class_1657 player, class_1799 stack, class_1937 world, class_2338 usePos) {
		return true;
	}

	@Override
	protected void setEntityData(class_1799 stack, class_1297 entity, @Nullable class_1297 source) {
		if (entity instanceof LawnMowerEntity lawnMowerEntity) {
			if (source instanceof class_1657 player && !player.method_68878()) {
				lawnMowerEntity.shouldDropSpawnItem = true;
			}
			else if (!(source instanceof class_1657)) {
				lawnMowerEntity.shouldDropSpawnItem = true;
			}
			lawnMowerEntity.customSpawnItem = stack.method_46651(1);
		}
	}

	protected static void sendMessage(class_1657 player, class_2561 message) {
		((class_3222) player).method_43502(message, true);
	}

	public class_1299<?> getEntityType(class_1799 stack) {
		return super.getEntityType(stack);
	}

	@Override
	public Predicate<class_1799> getBagPredicate() {
		return null;
	}
}
