package net.db64.homelawnsecurity.item.custom;

import net.db64.homelawnsecurity.entity.ModEntities;
import net.db64.homelawnsecurity.entity.custom.IPathBoundEntity;
import net.db64.homelawnsecurity.entity.custom.PlantEntity;
import net.db64.homelawnsecurity.entity.custom.other.PlantSeedPacketPathfindingEntity;
import net.db64.homelawnsecurity.entity.custom.other.SeedPacketPathfindingEntity;
import net.db64.homelawnsecurity.sound.ModSounds;
import net.db64.homelawnsecurity.util.LawnUtil;
import net.minecraft.class_11;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3730;
import java.util.function.Predicate;

public class LawnSeedPacketItem extends SeedPacketItem {
	public LawnSeedPacketItem(class_1299<? extends class_1308> type, class_1793 settings) {
		super(type, settings);
	}

	@Override
	protected boolean isPlaceable(class_2338 blockPos, class_1937 world, boolean devMode, class_3222 player) {
		if (!(world instanceof class_3218 serverWorld)) return false;

		// Return if there is already a plant there
		if (!devMode && !world.method_8333(null, new class_238(0, 0, 0, 1, 1, 1).method_996(blockPos.method_10084()), entity -> entity instanceof PlantEntity).isEmpty())
			return false;

		// Return if it's not on turf
		if (!PlantEntity.isPlaceableLawn(blockPos, world)) {
			sendMessage(player, class_2561.method_43471("item.homelawnsecurity.seed_packet.plant.placement.error.turf"));
			return false;
		}

		// Return if it's not next to or on a path
		if (!(devMode || LawnUtil.isAnyPath(blockPos, world))) {
			boolean nearPath = false;
			Iterable<class_2338> iterable = class_2338.method_25996(blockPos, 1, 1, 1);
			for (class_2338 pos : iterable) {
				if (LawnUtil.isAnyPath(pos, world)) {
					nearPath = true;
					break;
				}
			}
			if (!nearPath) {
				sendMessage(player, class_2561.method_43471("item.homelawnsecurity.seed_packet.plant.placement.error.near_path"));
				return false;
			}
		}

		// Check if it's too far away from the garden
		SeedPacketPathfindingEntity entity = new PlantSeedPacketPathfindingEntity(ModEntities.Other.PLANT_SEED_PACKET_PATHFINDING, world);
		world.method_8649(entity);
		entity.method_5808(blockPos.method_10263(), blockPos.method_10264() + 1, blockPos.method_10260(), entity.method_36454(), entity.method_36455());
		entity.method_5943(serverWorld, world.method_8404(blockPos), class_3730.field_16465, null);

		// Check if it's on a path
		boolean isOffPath = !LawnUtil.isAnyPath(blockPos, world); // We need lawn plants to still be placeable off the path

		// Return if it's too far away from the garden and on a path
		if (!(devMode || isOffPath || isValidPositionOnPath(entity))) {
			sendMessage(player, class_2561.method_43471("item.homelawnsecurity.seed_packet.plant.placement.error.too_far"));
			return false;
		}

		//entity.discard();
		return true;
	}

	public boolean isValidPositionOnPath(SeedPacketPathfindingEntity entity) {
		class_11 path = entity.findPathToGoal(SeedPacketPathfindingEntity.searchDistanceFromOtherEnd());

		if (path == null) return false;
		else return path.method_38() > SeedPacketPathfindingEntity.searchDistanceFromClose();
	}

	@Override
	public Predicate<class_1799> getBagPredicate() {
		return SUN_BAG_PREDICATE;
	}

	@Override
	public void playPlaceSound(class_1937 world, class_2338 pos) {
		if (world.method_8316(pos.method_10074()).method_15767(class_3486.field_15517))
			world.method_45447(null, pos, ModSounds.ENTITY_PLANT_PLACE_WATER, class_3419.field_15254);
		else
			world.method_45447(null, pos, ModSounds.ENTITY_PLANT_PLACE, class_3419.field_15254);
	}
}
